/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa;

import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.xsuaa.XsuaaCredentials;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import java.net.URI;
import javax.annotation.Nullable;

public class XsuaaServiceConfigurationCustom
implements XsuaaServiceConfiguration {
    private final XsuaaCredentials credentials;

    public XsuaaServiceConfigurationCustom(XsuaaCredentials credentials) {
        this.credentials = credentials;
    }

    public String getClientId() {
        return this.credentials.getClientId();
    }

    public String getClientSecret() {
        return this.credentials.getClientSecret();
    }

    @Override
    public String getUaaUrl() {
        return this.credentials.getUrl();
    }

    @Nullable
    public URI getCertUrl() {
        return URI.create(this.credentials.getCertUrl());
    }

    @Override
    public String getAppId() {
        return this.credentials.getXsAppName();
    }

    @Override
    public String getUaaDomain() {
        return this.credentials.getUaaDomain();
    }

    @Override
    @Nullable
    public String getVerificationKey() {
        return this.credentials.getVerificationKey();
    }

    public CredentialType getCredentialType() {
        return this.credentials.getCredentialType();
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public ClientIdentity getClientIdentity() {
        ClientCertificate identity = new ClientCertificate(this.credentials.getCertificate(), this.credentials.getKey(), this.getClientId());
        if (!identity.isValid()) {
            identity = new ClientCredentials(this.getClientId(), this.getClientSecret());
        }
        return identity;
    }
}

