/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token;

import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.extractor.AuthoritiesExtractor;
import com.sap.cloud.security.xsuaa.extractor.DefaultAuthoritiesExtractor;
import com.sap.cloud.security.xsuaa.extractor.LocalAuthoritiesExtractor;
import com.sap.cloud.security.xsuaa.token.AuthenticationToken;
import com.sap.cloud.security.xsuaa.token.XsuaaToken;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public class TokenAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private AuthoritiesExtractor authoritiesExtractor;
    private String appId;

    public TokenAuthenticationConverter(AuthoritiesExtractor authoritiesExtractor) {
        this.authoritiesExtractor = authoritiesExtractor;
    }

    public TokenAuthenticationConverter(String appId) {
        this.authoritiesExtractor = new DefaultAuthoritiesExtractor();
        this.appId = appId;
    }

    public TokenAuthenticationConverter(XsuaaServiceConfiguration xsuaaServiceConfiguration) {
        this(xsuaaServiceConfiguration.getAppId());
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        return new AuthenticationToken(jwt, this.authoritiesExtractor.getAuthorities(new XsuaaToken(jwt)));
    }

    public TokenAuthenticationConverter setLocalScopeAsAuthorities(boolean extractLocalScopesOnly) {
        if (extractLocalScopesOnly) {
            Assert.state((this.appId != null ? 1 : 0) != 0, (String)"For local Scope extraction 'appId' must be provided to `TokenAuthenticationConverter`");
            this.authoritiesExtractor = new LocalAuthoritiesExtractor(this.appId);
        } else {
            this.authoritiesExtractor = new DefaultAuthoritiesExtractor();
        }
        return this;
    }
}

