/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token.authentication;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.token.authentication.PostValidationAction;
import com.sap.cloud.security.xsuaa.token.authentication.TokenInfoExtractor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;

public class XsuaaJwtDecoder
implements JwtDecoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XsuaaServiceConfiguration xsuaaServiceConfiguration;
    Cache<String, JwtDecoder> cache;
    private OAuth2TokenValidator<Jwt> tokenValidators;
    private Collection<PostValidationAction> postValidationActions;
    private TokenInfoExtractor tokenInfoExtractor;
    private RestOperations restOperations;

    XsuaaJwtDecoder(final XsuaaServiceConfiguration xsuaaServiceConfiguration, int cacheValidityInSeconds, int cacheSize, OAuth2TokenValidator<Jwt> tokenValidators, Collection<PostValidationAction> postValidationActions) {
        this.cache = Caffeine.newBuilder().expireAfterWrite((long)cacheValidityInSeconds, TimeUnit.SECONDS).maximumSize((long)cacheSize).build();
        this.tokenValidators = tokenValidators;
        this.xsuaaServiceConfiguration = xsuaaServiceConfiguration;
        this.tokenInfoExtractor = new TokenInfoExtractor(){

            @Override
            public String getJku(JWT jwt) {
                return new JSONObject(jwt.getHeader().toString()).optString("jku", null);
            }

            @Override
            public String getKid(JWT jwt) {
                return new JSONObject(jwt.getHeader().toString()).optString("kid", null);
            }

            @Override
            public String getUaaDomain(JWT jwt) {
                return xsuaaServiceConfiguration.getUaaDomain();
            }
        };
        this.postValidationActions = postValidationActions != null ? postValidationActions : Collections.emptyList();
    }

    public Jwt decode(String token) throws BadJwtException {
        JWT jwt;
        Assert.notNull((Object)token, (String)"token is required");
        try {
            jwt = JWTParser.parse((String)token);
        }
        catch (ParseException ex) {
            throw new BadJwtException("Error initializing JWT decoder: " + ex.getMessage());
        }
        Jwt verifiedToken = this.verifyToken(jwt);
        this.postValidationActions.forEach(action -> action.perform(verifiedToken));
        return verifiedToken;
    }

    public void setTokenInfoExtractor(TokenInfoExtractor tokenInfoExtractor) {
        this.tokenInfoExtractor = tokenInfoExtractor;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    private Jwt verifyToken(JWT jwt) {
        try {
            String jku = this.tokenInfoExtractor.getJku(jwt);
            String kid = this.tokenInfoExtractor.getKid(jwt);
            String uaaDomain = this.tokenInfoExtractor.getUaaDomain(jwt);
            return this.verifyToken(jwt.getParsedString(), jku, kid, uaaDomain);
        }
        catch (JwtException e) {
            return this.tryToVerifyWithVerificationKey(jwt.getParsedString(), e);
        }
    }

    private Jwt verifyToken(String token, String jku, String kid, String uaaDomain) {
        try {
            this.canVerifyWithKey(jku, kid, uaaDomain);
            this.validateJku(jku, uaaDomain);
            return this.verifyWithKey(token, jku, kid);
        }
        catch (JwtValidationException ex) {
            throw ex;
        }
        catch (JwtException ex) {
            throw new BadJwtException("JWT verification failed: " + ex.getMessage());
        }
    }

    private void canVerifyWithKey(String jku, String kid, String uaadomain) {
        if (jku != null && kid != null && uaadomain != null) {
            return;
        }
        ArrayList<String> nullParams = new ArrayList<String>();
        if (jku == null) {
            nullParams.add("jku");
        }
        if (kid == null) {
            nullParams.add("kid");
        }
        if (uaadomain == null) {
            nullParams.add("uaadomain");
        }
        throw new BadJwtException(String.format("Cannot verify with online token key, %s is null", String.join((CharSequence)", ", nullParams)));
    }

    private void validateJku(String jku, String uaadomain) {
        try {
            URI jkuUri = new URI(jku);
            if (jkuUri.getHost() == null) {
                throw new BadJwtException("JKU of token is not valid");
            }
            if (!jkuUri.getHost().endsWith(uaadomain)) {
                this.logger.warn("Error: Do not trust jku '{}' because it does not match uaa domain '{}'.", (Object)jku, (Object)uaadomain);
                throw new BadJwtException("Do not trust 'jku' token header.");
            }
            if (!jkuUri.getPath().endsWith("token_keys") || StringUtils.hasText((String)jkuUri.getQuery()) || StringUtils.hasText((String)jkuUri.getFragment())) {
                this.logger.warn("Error: Do not trust jku '{}' because it contains invalid path, query or fragment.", (Object)jku);
                throw new BadJwtException("Jwt token does not contain a valid 'jku' header parameter: " + jkuUri);
            }
        }
        catch (URISyntaxException e) {
            throw new BadJwtException("JKU of token header is not valid");
        }
    }

    private Jwt verifyWithKey(String token, String jku, String kid) {
        String cacheKey = jku + kid;
        JwtDecoder decoder = (JwtDecoder)this.cache.get((Object)cacheKey, k -> this.getDecoder(jku));
        return decoder.decode(token);
    }

    private JwtDecoder getDecoder(String jku) {
        NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder jwkSetUriJwtDecoderBuilder = NimbusJwtDecoder.withJwkSetUri((String)jku);
        if (this.restOperations != null) {
            jwkSetUriJwtDecoderBuilder.restOperations(this.restOperations);
        }
        NimbusJwtDecoder jwtDecoder = jwkSetUriJwtDecoderBuilder.build();
        jwtDecoder.setJwtValidator(this.tokenValidators);
        return jwtDecoder;
    }

    private Jwt tryToVerifyWithVerificationKey(String token, JwtException verificationException) {
        String verificationKey = this.xsuaaServiceConfiguration.getVerificationKey();
        if (!StringUtils.hasText((String)verificationKey)) {
            throw verificationException;
        }
        return this.verifyWithVerificationKey(token, verificationKey);
    }

    private Jwt verifyWithVerificationKey(String token, String verificationKey) {
        try {
            RSAPublicKey verficationKey = this.createPublicKey(verificationKey);
            NimbusJwtDecoder decoder = NimbusJwtDecoder.withPublicKey((RSAPublicKey)verficationKey).build();
            decoder.setJwtValidator(this.tokenValidators);
            return decoder.decode(token);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new BadJwtException(e.getMessage());
        }
    }

    private static String convertPEMKey(String pemEncodedKey) {
        String key = pemEncodedKey;
        key = key.replace("-----BEGIN PUBLIC KEY-----", "");
        key = key.replace("-----END PUBLIC KEY-----", "");
        return key;
    }

    private RSAPublicKey createPublicKey(String pemEncodedPublicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decodedKey = Base64.getDecoder().decode(XsuaaJwtDecoder.convertPEMKey(pemEncodedPublicKey));
        X509EncodedKeySpec spec = new X509EncodedKeySpec(decodedKey);
        return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(spec);
    }
}

