/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hcp.cf.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.sap.hcp.cf.logback.converter.api.LogbackContextFieldSupplier;
import com.sap.hcp.cf.logging.common.Markers;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BaseFieldSupplier
implements LogbackContextFieldSupplier {
    public Map<String, Object> map(ILoggingEvent event) {
        HashMap<String, Object> fields = new HashMap<String, Object>(6);
        fields.put("written_at", Instant.ofEpochMilli(event.getTimeStamp()).toString());
        fields.put("written_ts", this.now());
        fields.put("type", this.isRequestLog(event) ? "request" : "log");
        fields.put("level", String.valueOf(event.getLevel()));
        fields.put("logger", event.getLoggerName());
        fields.put("thread", event.getThreadName());
        if (!this.isRequestLog(event)) {
            fields.put("msg", event.getFormattedMessage());
        }
        if (event.getThrowableProxy() != null && event.getThrowableProxy() instanceof ThrowableProxy) {
            Throwable throwable = ((ThrowableProxy)event.getThrowableProxy()).getThrowable();
            fields.put("exception_type", throwable.getClass().getName());
            if (StringUtils.isNotBlank((CharSequence)throwable.getMessage())) {
                fields.put("exception_message", throwable.getMessage());
            }
        }
        return fields;
    }

    private String now() {
        Instant now = Instant.now();
        long timestamp = now.getEpochSecond() * 1000000000L + (long)now.getNano();
        return String.valueOf(timestamp);
    }

    private boolean isRequestLog(ILoggingEvent event) {
        return Markers.REQUEST_MARKER.equals((Object)event.getMarker());
    }
}

