/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hcp.cf.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONComposer;
import com.fasterxml.jackson.jr.ob.comp.ArrayComposer;
import com.fasterxml.jackson.jr.ob.comp.ComposerBase;
import com.fasterxml.jackson.jr.ob.comp.ObjectComposer;
import com.sap.hcp.cf.logback.converter.api.LogbackContextFieldSupplier;
import com.sap.hcp.cf.logback.encoder.BaseFieldSupplier;
import com.sap.hcp.cf.logback.encoder.EventContextFieldSupplier;
import com.sap.hcp.cf.logback.encoder.RequestRecordFieldSupplier;
import com.sap.hcp.cf.logging.common.converter.LineWriter;
import com.sap.hcp.cf.logging.common.converter.StacktraceLines;
import com.sap.hcp.cf.logging.common.serialization.ContextFieldConverter;
import com.sap.hcp.cf.logging.common.serialization.ContextFieldSupplier;
import com.sap.hcp.cf.logging.common.serialization.JsonSerializationException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class JsonEncoder
extends EncoderBase<ILoggingEvent> {
    private static final String NEWLINE = "\n";
    private Charset charset = StandardCharsets.UTF_8;
    private List<String> customFieldMdcKeyNames = new ArrayList<String>();
    private List<String> retainFieldMdcKeyNames = new ArrayList<String>();
    private boolean sendDefaultValues = false;
    private List<LogbackContextFieldSupplier> logbackContextFieldSuppliers = new ArrayList<LogbackContextFieldSupplier>();
    private List<ContextFieldSupplier> contextFieldSuppliers = new ArrayList<ContextFieldSupplier>();
    private int maxStacktraceSize = 56320;
    private JSON.Builder jsonBuilder = JSON.builder();
    private JSON json;
    private ContextFieldConverter contextFieldConverter;

    public JsonEncoder() {
        this.logbackContextFieldSuppliers.add(new BaseFieldSupplier());
        this.logbackContextFieldSuppliers.add(new EventContextFieldSupplier());
        this.logbackContextFieldSuppliers.add(new RequestRecordFieldSupplier());
    }

    public void addCustomFieldMdcKeyName(String name) {
        this.customFieldMdcKeyNames.add(name);
    }

    public void addRetainFieldMdcKeyName(String name) {
        this.retainFieldMdcKeyNames.add(name);
    }

    public void setCharset(String name) {
        try {
            this.charset = Charset.forName(name);
        }
        catch (IllegalArgumentException cause) {
            LoggerHolder.LOG.warn("Cannot set charset ''" + name + "''. Falling back to default.", (Throwable)cause);
        }
    }

    public void setMaxStacktraceSize(int maxStacktraceSize) {
        this.maxStacktraceSize = maxStacktraceSize;
    }

    public void setSendDefaultValues(boolean sendDefaultValues) {
        this.sendDefaultValues = sendDefaultValues;
    }

    public void setJsonBuilder(String className) {
        try {
            JSON.Builder builder;
            this.jsonBuilder = builder = this.createInstance(className, JSON.Builder.class);
        }
        catch (Exception cause) {
            LoggerHolder.LOG.warn("Cannot register JsonBuilder, using default.", (Throwable)cause);
        }
    }

    private <T> T createInstance(String className, Class<T> interfaceClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Class<T> clazz = classLoader.loadClass(className).asSubclass(interfaceClass);
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void addLogbackContextFieldSupplier(String className) {
        try {
            LogbackContextFieldSupplier instance = this.createInstance(className, LogbackContextFieldSupplier.class);
            this.logbackContextFieldSuppliers.add(instance);
        }
        catch (Exception cause) {
            LoggerHolder.LOG.warn("Cannot register LogbackContextFieldSupplier.", (Throwable)cause);
        }
    }

    public void addContextFieldSupplier(String className) {
        try {
            ContextFieldSupplier instance = this.createInstance(className, ContextFieldSupplier.class);
            this.contextFieldSuppliers.add(instance);
        }
        catch (Exception cause) {
            LoggerHolder.LOG.warn("Cannot register ContextFieldSupplier.", (Throwable)cause);
        }
    }

    public void start() {
        this.json = new JSON(this.jsonBuilder);
        this.contextFieldConverter = new ContextFieldConverter(this.sendDefaultValues, this.customFieldMdcKeyNames, this.retainFieldMdcKeyNames);
        super.start();
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] footerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        return this.getJson(event).getBytes(this.charset);
    }

    private String getJson(ILoggingEvent event) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            ObjectComposer oc = this.json.composeTo((Writer)writer).startObject();
            this.addMarkers(oc, event);
            Map<String, Object> contextFields = this.collectContextFields(event);
            this.contextFieldConverter.addContextFields(oc, contextFields);
            this.contextFieldConverter.addCustomFields(oc, contextFields);
            this.addStacktrace(oc, event);
            ((JSONComposer)oc.end()).finish();
            string = writer.append(NEWLINE).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSerializationException | IOException ex) {
                LoggerHolder.LOG.error("Conversion failed ", ex);
                return event.getFormattedMessage() + NEWLINE;
            }
        }
        writer.close();
        return string;
    }

    private <P extends ComposerBase> void addMarkers(ObjectComposer<P> oc, ILoggingEvent event) throws IOException, JsonProcessingException {
        if (this.sendDefaultValues || event.getMarker() != null) {
            ArrayComposer ac = oc.startArrayField("categories");
            this.addMarker(ac, event.getMarker());
            ac.end();
        }
    }

    private <P extends ComposerBase> void addMarker(ArrayComposer<P> ac, Marker parent) throws IOException {
        if (parent == null) {
            return;
        }
        if (parent.hasReferences()) {
            Iterator current = parent.iterator();
            while (current.hasNext()) {
                this.addMarker(ac, (Marker)current.next());
            }
        }
        ac.add(parent.getName());
    }

    private Map<String, Object> collectContextFields(ILoggingEvent event) {
        HashMap<String, Object> contextFields = new HashMap<String, Object>();
        this.contextFieldSuppliers.forEach(s -> contextFields.putAll((Map)s.get()));
        this.logbackContextFieldSuppliers.forEach(s -> contextFields.putAll(s.map(event)));
        return contextFields;
    }

    private <P extends ComposerBase> void addStacktrace(ObjectComposer<P> oc, ILoggingEvent event) throws IOException, JsonProcessingException {
        IThrowableProxy proxy = event.getThrowableProxy();
        if (proxy != null && ThrowableProxy.class.isAssignableFrom(proxy.getClass())) {
            Throwable throwable = ((ThrowableProxy)proxy).getThrowable();
            LineWriter lw = new LineWriter();
            throwable.printStackTrace(new PrintWriter((Writer)lw));
            List lines = lw.getLines();
            StacktraceLines stacktraceLines = new StacktraceLines(lines);
            ArrayComposer ac = oc.startArrayField("stacktrace");
            if (stacktraceLines.getTotalLineLength() <= this.maxStacktraceSize) {
                for (String line : stacktraceLines.getLines()) {
                    ac.add(line);
                }
            } else {
                ac.add("-------- STACK TRACE TRUNCATED --------");
                for (String line : stacktraceLines.getFirstLines(this.maxStacktraceSize / 3)) {
                    ac.add(line);
                }
                ac.add("-------- OMITTED --------");
                for (String line : stacktraceLines.getLastLines(this.maxStacktraceSize / 3 * 2)) {
                    ac.add(line);
                }
            }
            ac.end();
        }
    }

    private static class LoggerHolder {
        static final Logger LOG = LoggerFactory.getLogger(LoggerHolder.class.getEnclosingClass());

        private LoggerHolder() {
        }
    }
}

