/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hcp.cf.logback.filter;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class DynamicLevelPrefixLoggerTurboFilter
extends TurboFilter {
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        String logLevel = MDC.get((String)"dynamic_log_level");
        if (logLevel != null && level.isGreaterOrEqual(Level.toLevel((String)logLevel)) && this.checkPackages(logger)) {
            return FilterReply.ACCEPT;
        }
        return FilterReply.NEUTRAL;
    }

    private boolean checkPackages(Logger logger) {
        String logLevelPackages = MDC.get((String)"dynamic_log_level_prefixes");
        if (StringUtils.isNotBlank((CharSequence)logLevelPackages)) {
            for (String current : logLevelPackages.split(",")) {
                if (!logger.getName().startsWith(current)) continue;
                return true;
            }
        }
        return false;
    }
}

