/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hcp.cf.logback.perf;

import com.sap.hcp.cf.logging.common.Markers;
import com.sap.hcp.cf.logging.common.request.RequestRecord;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTestRequestRecord {
    private static final int DEF_ITERATIONS = 1000000;
    private final int iterations;
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfTestRequestRecord.class);

    public PerfTestRequestRecord(int iterations) {
        this.iterations = iterations > 0 ? iterations : 1000000;
    }

    public static void main(String[] args) {
        new PerfTestRequestRecord(1000000).run(args);
    }

    private void run(String[] args) {
        long start = System.nanoTime();
        PrintStream defOut = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }));
        for (int i = 0; i < this.iterations; ++i) {
            RequestRecord rrec = new RequestRecord(PerfTestRequestRecord.class.getName());
            LOGGER.info(Markers.REQUEST_MARKER, rrec.toString());
        }
        double delta = (double)(System.nanoTime() - start) / 1000000.0;
        System.setOut(defOut);
        System.out.println("Writing " + this.iterations + " records took " + delta + " msecs, " + delta / (double)this.iterations + " msecs per record");
    }
}

