/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Call {
    private final HttpURLConnection con;
    static final ObjectMapper MAPPER = new ObjectMapper();

    Call(HttpURLConnection con) {
        this.con = con;
    }

    public <T> T post(Object json, Class<T> responseType) throws IOException {
        return this.putOrPost("POST", json, responseType);
    }

    public <T> T put(Object json, Class<T> responseType) throws IOException {
        return this.putOrPost("PUT", json, responseType);
    }

    private <T> T putOrPost(String method, Object json, Class<T> responseType) throws IOException {
        this.con.setRequestMethod(method);
        this.con.setRequestProperty("Content-Type", "application/json");
        this.con.setDoOutput(true);
        this.con.connect();
        OutputStream out = this.con.getOutputStream();
        MAPPER.writeValue(out, json);
        if (this.con.getResponseCode() >= 400) {
            throw this.handleErrorResponse();
        }
        return (T)MAPPER.readValue(this.con.getInputStream(), responseType);
    }

    public <T> T get(TypeReference<T> responseType) throws IOException {
        this.con.connect();
        if (this.con.getResponseCode() >= 400) {
            throw this.handleErrorResponse();
        }
        return (T)MAPPER.readValue(this.con.getInputStream(), responseType);
    }

    public <T> T get(Class<T> responseType) throws IOException {
        this.con.connect();
        if (this.con.getResponseCode() >= 400) {
            throw this.handleErrorResponse();
        }
        return (T)MAPPER.readValue(this.con.getInputStream(), responseType);
    }

    public void delete() throws IOException {
        this.con.setRequestMethod("DELETE");
        this.con.connect();
        if (this.con.getResponseCode() != 200) {
            throw this.handleErrorResponse();
        }
        this.con.getInputStream().close();
    }

    private IOException handleErrorResponse() throws IOException {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)this.con.getErrorStream(), (OutputStream)err);
        return new IOException("API called failed. " + this.con.getResponseCode() + " " + this.con.getResponseMessage() + "\n" + err);
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

