/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.rest;

import com.saucelabs.rest.SauceTunnelFactory;
import com.saucelabs.rest.StatusResponse;
import com.trilead.ssh2.Connection;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SauceTunnel {
    private final SauceTunnelFactory factory;
    private final String id;
    private StatusResponse status;
    private Connection ssh;
    private static final Logger LOGGER = Logger.getLogger(SauceTunnel.class.getName());

    SauceTunnel(SauceTunnelFactory factory, String id) {
        this.factory = factory;
        this.id = id;
    }

    SauceTunnel(SauceTunnelFactory factory, StatusResponse status) {
        this(factory, status.id);
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public Date getCreationTime() throws IOException {
        return new Date(this.status().CreationTime);
    }

    public Date getShutDownTime() throws IOException {
        long t = this.status().ShutDownTime;
        if (t == 0L) {
            return null;
        }
        return new Date(t);
    }

    public String getHost() throws IOException {
        return this.status().Host;
    }

    public List<String> getDomainNames() throws IOException {
        return Collections.unmodifiableList(this.status().DomainNames);
    }

    public boolean isRunning() throws IOException {
        return "running".equals(this.status().Status);
    }

    public void waitUntilRunning(long timeout) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        while (timeout >= 0L && System.currentTimeMillis() < start + timeout) {
            this.refresh();
            Thread.sleep(3000L);
            if (!this.isRunning()) continue;
            return;
        }
        LOGGER.fine("Tunnel didn't come online after timeout=" + timeout + ". Current status is " + this.status().Status);
    }

    public void destroy() throws IOException {
        LOGGER.fine("Detroying tunnel id=" + this.id);
        this.factory.credential.call("tunnels/" + this.id).delete();
    }

    private StatusResponse status() throws IOException {
        if (this.status == null) {
            this.refresh();
        }
        return this.status;
    }

    public synchronized void connect(int remotePort, String localHost, int localPort) throws IOException {
        if (this.getHost() == null || !this.isRunning()) {
            throw new IllegalStateException("Tunnel id=" + this.id + " is not connected yet");
        }
        if (this.ssh == null) {
            LOGGER.fine("Connecting to " + this.getHost() + " via ssh. id=" + this.id);
            this.ssh = new Connection(this.getHost());
            this.ssh.connect();
        }
        LOGGER.fine("Authenticating");
        this.factory.credential.authenticate(this.ssh);
        this.ssh.requestRemotePortForwarding("0.0.0.0", remotePort, localHost, localPort);
    }

    public synchronized void disconnect(int remotePort) throws IOException {
        if (this.ssh != null) {
            this.ssh.cancelRemotePortForwarding(remotePort);
        }
    }

    public synchronized void disconnectAll() {
        if (this.ssh != null) {
            LOGGER.fine("Disconnecting tunnel id=" + this.id);
            this.ssh.close();
            this.ssh = null;
        }
    }

    public void refresh() throws IOException {
        LOGGER.fine("Requesting the current tunnel status for " + this.id);
        this.status = this.factory.credential.call("tunnels/" + this.id).get(StatusResponse.class);
        LOGGER.fine("Updated status is " + this.status);
    }
}

