/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.SocketDescriptor;
import com.tigervnc.network.SocketException;
import com.tigervnc.network.SocketListener;
import com.tigervnc.network.TcpSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class TcpListener
extends SocketListener {
    public static boolean socketsInitialised = false;
    private boolean closeFd;
    private ServerSocketChannel channel;
    private Selector selector;

    public TcpListener(String listenaddr, int port, boolean localhostOnly, SocketDescriptor sock, boolean close_) throws Exception {
        this.closeFd = close_;
        if (sock != null) {
            this.fd = sock;
            return;
        }
        TcpSocket.initSockets();
        try {
            this.channel = ServerSocketChannel.open();
            this.channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new Exception("unable to create listening socket: " + e.toString());
        }
        InetAddress addr = null;
        try {
            addr = localhostOnly ? InetAddress.getByName(null) : (listenaddr != null ? InetAddress.getByName(listenaddr) : InetAddress.getByName("0.0.0.0"));
        }
        catch (UnknownHostException e) {
            throw new Exception(e.getMessage());
        }
        try {
            this.channel.socket().bind(new InetSocketAddress(addr, port));
        }
        catch (IOException e) {
            throw new Exception("unable to bind listening socket: " + e.toString());
        }
        try {
            this.selector = Selector.open();
            this.channel.register(this.selector, 16);
        }
        catch (IOException e) {
            throw new Exception("unable to set socket to listening mode: " + e.toString());
        }
    }

    public TcpListener(String listenaddr, int port) throws Exception {
        this(listenaddr, port, false, null, true);
    }

    protected void finalize() throws Exception {
        if (this.closeFd) {
            try {
                ((SocketDescriptor)this.getFd()).close();
            }
            catch (IOException e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    @Override
    public void shutdown() throws Exception {
        try {
            ((SocketDescriptor)this.getFd()).shutdown();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public TcpSocket accept() {
        SocketChannel new_sock = null;
        try {
            if (this.selector.select(0L) > 0) {
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isAcceptable()) continue;
                    new_sock = this.channel.accept();
                    break;
                }
                keys.clear();
                if (new_sock == null) {
                    return null;
                }
            }
        }
        catch (IOException e) {
            throw new SocketException("unable to accept new connection: " + e.toString());
        }
        try {
            new_sock.socket().setTcpNoDelay(true);
        }
        catch (java.net.SocketException e) {
            throw new SocketException(e.getMessage());
        }
        SocketDescriptor fd = null;
        try {
            fd = new SocketDescriptor();
        }
        catch (Exception e) {
            throw new SocketException(e.getMessage());
        }
        fd.setChannel(new_sock);
        TcpSocket s = new TcpSocket(fd);
        return s;
    }

    public int getMyPort() {
        return ((SocketDescriptor)this.getFd()).socket().getLocalPort();
    }
}

