/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.Socket;
import com.tigervnc.network.SocketDescriptor;
import com.tigervnc.network.SocketException;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import com.tigervnc.rfb.LogWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class TcpSocket
extends Socket {
    public static boolean socketsInitialised = false;
    private boolean closeFd;
    static LogWriter vlog = new LogWriter("TcpSocket");

    public static void initSockets() {
        if (socketsInitialised) {
            return;
        }
        socketsInitialised = true;
    }

    public TcpSocket(SocketDescriptor sock, boolean close) {
        super(new FdInStream(sock), new FdOutStream(sock), true);
        this.closeFd = close;
    }

    public TcpSocket(SocketDescriptor sock) {
        this(sock, true);
    }

    public TcpSocket(String host, int port) throws Exception {
        this.closeFd = true;
        SocketDescriptor sock = null;
        InetAddress addr = null;
        boolean result = false;
        TcpSocket.initSockets();
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new Exception("unable to resolve host by name: " + e.toString());
        }
        try {
            sock = new SocketDescriptor();
        }
        catch (Exception e) {
            throw new SocketException("unable to create socket: " + e.toString());
        }
        try {
            result = sock.connect(new InetSocketAddress(addr, port));
        }
        catch (IOException e) {
            throw new SocketException("unable to connect:" + e.getMessage());
        }
        if (!result && sock.isConnectionPending()) {
            while (!result) {
                try {
                    result = sock.finishConnect();
                }
                catch (IOException e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
        if (!result) {
            throw new SocketException("unable connect to socket");
        }
        TcpSocket.enableNagles(sock, false);
        this.instream = new FdInStream(sock);
        this.outstream = new FdOutStream(sock);
        this.ownStreams = true;
    }

    protected void finalize() throws Exception {
        if (this.closeFd) {
            try {
                ((SocketDescriptor)this.getFd()).close();
            }
            catch (IOException e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    @Override
    public int getMyPort() {
        return this.getSockPort();
    }

    @Override
    public String getPeerAddress() {
        InetAddress peer = ((SocketDescriptor)this.getFd()).socket().getInetAddress();
        if (peer != null) {
            return peer.getHostAddress();
        }
        return "";
    }

    @Override
    public String getPeerName() {
        InetAddress peer = ((SocketDescriptor)this.getFd()).socket().getInetAddress();
        if (peer != null) {
            return peer.getHostName();
        }
        return "";
    }

    @Override
    public int getPeerPort() {
        int port = ((SocketDescriptor)this.getFd()).socket().getPort();
        return port;
    }

    @Override
    public String getPeerEndpoint() {
        String address = this.getPeerAddress();
        int port = this.getPeerPort();
        return address + "::" + port;
    }

    @Override
    public boolean sameMachine() throws Exception {
        try {
            SocketAddress peeraddr = ((SocketDescriptor)this.getFd()).getRemoteAddress();
            SocketAddress myaddr = ((SocketDescriptor)this.getFd()).getLocalAddress();
            return myaddr.equals(peeraddr);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        try {
            ((SocketDescriptor)this.getFd()).shutdown();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        ((SocketDescriptor)this.getFd()).close();
    }

    public static boolean enableNagles(SocketDescriptor sock, boolean enable) {
        try {
            sock.channel.socket().setTcpNoDelay(!enable);
        }
        catch (java.net.SocketException e) {
            vlog.error("unable to setsockopt TCP_NODELAY: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean isSocket(java.net.Socket sock) {
        return sock.getClass().toString().equals("com.tigervnc.net.Socket");
    }

    public boolean isConnected() {
        return ((SocketDescriptor)this.getFd()).isConnected();
    }

    public int getSockPort() {
        return ((SocketDescriptor)this.getFd()).socket().getLocalPort();
    }

    public static int findFreeTcpPort() {
        int port;
        try {
            ServerSocket sock = new ServerSocket(0);
            port = sock.getLocalPort();
            sock.close();
        }
        catch (IOException e) {
            throw new SocketException("unable to create socket: " + e.toString());
        }
        return port;
    }
}

