/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReaderV3;
import com.tigervnc.rfb.CMsgWriterV3;
import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.ConnFailedException;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.SecurityClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CConnection
extends CMsgHandler {
    public static final int RFBSTATE_UNINITIALISED = 0;
    public static final int RFBSTATE_PROTOCOL_VERSION = 1;
    public static final int RFBSTATE_SECURITY_TYPES = 2;
    public static final int RFBSTATE_SECURITY = 3;
    public static final int RFBSTATE_SECURITY_RESULT = 4;
    public static final int RFBSTATE_INITIALISATION = 5;
    public static final int RFBSTATE_NORMAL = 6;
    public static final int RFBSTATE_INVALID = 7;
    InStream is = null;
    OutStream os = null;
    CMsgReaderV3 reader_ = null;
    CMsgWriterV3 writer_ = null;
    boolean shared = false;
    public CSecurity csecurity = null;
    public SecurityClient security = new SecurityClient();
    public static final int maxSecTypes = 8;
    int nSecTypes;
    int[] secTypes;
    int state_ = 0;
    String serverName;
    int serverPort;
    boolean useProtocol3_3 = false;
    boolean clientSecTypeOrder;
    static LogWriter vlog = new LogWriter("CConnection");

    public void deleteReaderAndWriter() {
        this.reader_ = null;
        this.writer_ = null;
    }

    public final void initialiseProtocol() {
        this.state_ = 1;
    }

    public void processMsg() {
        switch (this.state_) {
            case 1: {
                this.processVersionMsg();
                break;
            }
            case 2: {
                this.processSecurityTypesMsg();
                break;
            }
            case 3: {
                this.processSecurityMsg();
                break;
            }
            case 4: {
                this.processSecurityResultMsg();
                break;
            }
            case 5: {
                this.processInitMsg();
                break;
            }
            case 6: {
                this.reader_.readMsg();
                break;
            }
            case 0: {
                throw new Exception("CConnection.processMsg: not initialised yet?");
            }
            default: {
                throw new Exception("CConnection.processMsg: invalid state");
            }
        }
    }

    private void processVersionMsg() {
        vlog.debug("reading protocol version");
        if (!this.cp.readVersion(this.is)) {
            this.state_ = 7;
            throw new Exception("reading version failed: not an RFB server?");
        }
        if (!this.cp.done) {
            return;
        }
        vlog.info("Server supports RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
        if (this.cp.beforeVersion(3, 3)) {
            String msg = "Server gave unsupported RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion;
            vlog.error(msg);
            this.state_ = 7;
            throw new Exception(msg);
        }
        if (this.useProtocol3_3 || this.cp.beforeVersion(3, 7)) {
            this.cp.setVersion(3, 3);
        } else if (this.cp.afterVersion(3, 8)) {
            this.cp.setVersion(3, 8);
        }
        this.cp.writeVersion(this.os);
        this.state_ = 2;
        vlog.info("Using RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processSecurityTypesMsg() {
        int secType;
        block11: {
            List<Object> secTypes;
            block10: {
                vlog.debug("processing security types message");
                secType = 0;
                secTypes = new ArrayList();
                secTypes = Security.GetEnabledSecTypes();
                if (!this.cp.isVersion(3, 3)) break block10;
                secType = this.is.readU32();
                if (secType == 0) {
                    this.throwConnFailedException();
                    break block11;
                } else {
                    if (secType != 1 && secType != 2) {
                        vlog.error("Unknown 3.3 security type " + secType);
                        throw new Exception("Unknown 3.3 security type");
                    }
                    Iterator<Object> i = secTypes.iterator();
                    while (i.hasNext()) {
                        int refType = (Integer)i.next();
                        if (refType != secType) continue;
                        secType = refType;
                        break;
                    }
                    if (!secTypes.contains(secType)) {
                        secType = 0;
                    }
                }
                break block11;
            }
            int nServerSecTypes = this.is.readU8();
            if (nServerSecTypes == 0) {
                this.throwConnFailedException();
            }
            block1: for (int i = 0; i < nServerSecTypes; ++i) {
                int serverSecType = this.is.readU8();
                vlog.debug("Server offers security type " + Security.secTypeName(serverSecType) + "(" + serverSecType + ")");
                if (secType != 0) continue;
                Iterator<Object> j = secTypes.iterator();
                while (j.hasNext()) {
                    int refType = (Integer)j.next();
                    if (refType != serverSecType) continue;
                    secType = refType;
                    continue block1;
                }
            }
            if (secType != 0) {
                this.os.writeU8(secType);
                this.os.flush();
                vlog.debug("Choosing security type " + Security.secTypeName(secType) + "(" + secType + ")");
            }
        }
        if (secType == 0) {
            this.state_ = 7;
            vlog.error("No matching security types");
            throw new Exception("No matching security types");
        }
        this.state_ = 3;
        this.csecurity = this.security.GetCSecurity(secType);
        this.processSecurityMsg();
    }

    private void processSecurityMsg() {
        vlog.debug("processing security message");
        if (this.csecurity.processMsg(this)) {
            this.state_ = 4;
            this.processSecurityResultMsg();
        }
    }

    private void processSecurityResultMsg() {
        int result;
        vlog.debug("processing security result message");
        if (this.cp.beforeVersion(3, 8) && this.csecurity.getType() == 1) {
            result = 0;
        } else {
            if (!this.is.checkNoWait(1)) {
                return;
            }
            result = this.is.readU32();
        }
        switch (result) {
            case 0: {
                this.securityCompleted();
                return;
            }
            case 1: {
                vlog.debug("auth failed");
                break;
            }
            case 2: {
                vlog.debug("auth failed - too many tries");
                break;
            }
            default: {
                throw new Exception("Unknown security result from server");
            }
        }
        String reason = this.cp.beforeVersion(3, 8) ? "Authentication failure" : this.is.readString();
        this.state_ = 7;
        throw new AuthFailureException(reason);
    }

    private void processInitMsg() {
        vlog.debug("reading server initialisation");
        this.reader_.readServerInit();
    }

    private void throwConnFailedException() {
        this.state_ = 7;
        String reason = this.is.readString();
        throw new ConnFailedException(reason);
    }

    private void securityCompleted() {
        this.state_ = 5;
        this.reader_ = new CMsgReaderV3(this, this.is);
        this.writer_ = new CMsgWriterV3(this.cp, this.os);
        vlog.debug("Authentication success!");
        this.authSuccess();
        this.writer_.writeClientInit(this.shared);
    }

    public final void setServerName(String name) {
        this.serverName = name;
    }

    public final void setStreams(InStream is_, OutStream os_) {
        this.is = is_;
        this.os = os_;
    }

    public final void setShared(boolean s) {
        this.shared = s;
    }

    public final void setProtocol3_3(boolean s) {
        this.useProtocol3_3 = s;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public void initSecTypes() {
        this.nSecTypes = 0;
    }

    public void authSuccess() {
    }

    @Override
    public void serverInit() {
        this.state_ = 6;
        vlog.debug("initialisation done");
    }

    public void setClientSecTypeOrder(boolean csto) {
        this.clientSecTypeOrder = csto;
    }

    public CMsgReaderV3 reader() {
        return this.reader_;
    }

    public CMsgWriterV3 writer() {
        return this.writer_;
    }

    public InStream getInStream() {
        return this.is;
    }

    public OutStream getOutStream() {
        return this.os;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int state() {
        return this.state_;
    }

    protected final void setState(int s) {
        this.state_ = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fence(int flags, int len, byte[] data) {
        super.fence(flags, len, data);
        if ((flags & Integer.MIN_VALUE) != 0) {
            return;
        }
        flags = 0;
        CConnection cConnection = this;
        synchronized (cConnection) {
            this.writer().writeFence(flags, len, data);
        }
    }

    private void throwAuthFailureException() {
        vlog.debug("state=" + this.state() + ", ver=" + this.cp.majorVersion + "." + this.cp.minorVersion);
        String reason = this.state() == 4 && !this.cp.beforeVersion(3, 8) ? this.is.readString() : "Authentication failure";
        this.state_ = 7;
        vlog.error(reason);
        throw new AuthFailureException(reason);
    }
}

