/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.network.SSLEngineManager;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import com.tigervnc.rdr.SystemException;
import com.tigervnc.rdr.TLSInStream;
import com.tigervnc.rdr.TLSOutStream;
import com.tigervnc.rdr.WarningException;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.StringParameter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.UserPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import javax.xml.bind.DatatypeConverter;

public class CSecurityTLS
extends CSecurity {
    public static StringParameter x509ca = new StringParameter("x509ca", "X509 CA certificate", "", Configuration.ConfigurationObject.ConfViewer);
    public static StringParameter x509crl = new StringParameter("x509crl", "X509 CRL file", "", Configuration.ConfigurationObject.ConfViewer);
    protected CConnection client;
    private SSLContext ctx;
    private SSLEngine engine;
    private SSLEngineManager manager;
    private boolean anon;
    private String cafile;
    private String crlfile;
    private FdInStream is;
    private FdOutStream os;
    static LogWriter vlog = new LogWriter("CSecurityTLS");

    private void initGlobal() {
        try {
            this.ctx = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.toString());
        }
    }

    public CSecurityTLS(boolean _anon) {
        this.anon = _anon;
        this.manager = null;
        CSecurityTLS.setDefaults();
        this.cafile = x509ca.getData();
        this.crlfile = x509crl.getData();
    }

    public static String getDefaultCA() {
        if (UserPreferences.get("viewer", "x509ca") != null) {
            return UserPreferences.get("viewer", "x509ca");
        }
        return FileUtils.getVncHomeDir() + "x509_ca.pem";
    }

    public static String getDefaultCRL() {
        if (UserPreferences.get("viewer", "x509crl") != null) {
            return UserPreferences.get("viewer", "x509crl");
        }
        return FileUtils.getVncHomeDir() + "x509_crl.pem";
    }

    public static void setDefaults() {
        if (new File(CSecurityTLS.getDefaultCA()).exists()) {
            x509ca.setDefaultStr(CSecurityTLS.getDefaultCA());
        }
        if (new File(CSecurityTLS.getDefaultCRL()).exists()) {
            x509crl.setDefaultStr(CSecurityTLS.getDefaultCRL());
        }
    }

    @Override
    public boolean processMsg(CConnection cc) {
        this.is = (FdInStream)cc.getInStream();
        this.os = (FdOutStream)cc.getOutStream();
        this.client = cc;
        this.initGlobal();
        if (this.manager == null) {
            if (!this.is.checkNoWait(1)) {
                return false;
            }
            if (this.is.readU8() == 0) {
                int result = this.is.readU32();
                String reason = result == 1 || result == 2 ? this.is.readString() : new String("Authentication failure (protocol error)");
                throw new AuthFailureException(reason);
            }
            this.setParam();
        }
        try {
            this.manager = new SSLEngineManager(this.engine, this.is, this.os);
            this.manager.doHandshake();
        }
        catch (java.lang.Exception e) {
            throw new SystemException(e.toString());
        }
        cc.setStreams(new TLSInStream(this.is, this.manager), new TLSOutStream(this.os, this.manager));
        return true;
    }

    private void setParam() {
        int i;
        if (this.anon) {
            try {
                this.ctx.init(null, null, null);
            }
            catch (KeyManagementException e) {
                throw new AuthFailureException(e.toString());
            }
        }
        try {
            TrustManager[] myTM = new TrustManager[]{new MyX509TrustManager()};
            this.ctx.init(null, myTM, null);
        }
        catch (GeneralSecurityException e) {
            throw new AuthFailureException(e.toString());
        }
        SSLSocketFactory sslfactory = this.ctx.getSocketFactory();
        this.engine = this.ctx.createSSLEngine(this.client.getServerName(), this.client.getServerPort());
        this.engine.setUseClientMode(true);
        String[] supported = this.engine.getSupportedProtocols();
        ArrayList<String> enabled = new ArrayList<String>();
        for (i = 0; i < supported.length; ++i) {
            if (!supported[i].matches("TLS.*")) continue;
            enabled.add(supported[i]);
        }
        this.engine.setEnabledProtocols(enabled.toArray(new String[0]));
        if (this.anon) {
            supported = this.engine.getSupportedCipherSuites();
            enabled = new ArrayList();
            for (i = 0; i < supported.length; ++i) {
                if (!supported[i].matches("TLS_ECDH_anon.*")) continue;
                enabled.add(supported[i]);
            }
            for (i = 0; i < supported.length; ++i) {
                if (!supported[i].matches("TLS_DH_anon.*")) continue;
                enabled.add(supported[i]);
            }
            this.engine.setEnabledCipherSuites(enabled.toArray(new String[0]));
        } else {
            this.engine.setEnabledCipherSuites(this.engine.getSupportedCipherSuites());
        }
    }

    @Override
    public final int getType() {
        return this.anon ? 257 : 260;
    }

    @Override
    public final String description() {
        return this.anon ? "TLS Encryption without VncAuth" : "X509 Encryption without VncAuth";
    }

    class MyX509TrustManager
    implements X509TrustManager {
        X509TrustManager tm;

        MyX509TrustManager() throws GeneralSecurityException {
            KeyStore ks = KeyStore.getInstance("JKS");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try {
                File cacert;
                ks.load(null, null);
                String a = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(a);
                tmf.init((KeyStore)null);
                for (TrustManager m : tmf.getTrustManagers()) {
                    if (!(m instanceof X509TrustManager)) continue;
                    for (X509Certificate c : ((X509TrustManager)m).getAcceptedIssuers()) {
                        ks.setCertificateEntry(c.getSubjectX500Principal().getName(), c);
                    }
                }
                File castore = new File(FileUtils.getVncHomeDir() + "x509_savedcerts.pem");
                if (castore.exists() && castore.canRead()) {
                    MyFileInputStream caStream = new MyFileInputStream(castore);
                    Collection<? extends Certificate> cacerts = cf.generateCertificates(caStream);
                    for (Certificate certificate : cacerts) {
                        String string = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                        ks.setCertificateEntry(string, (X509Certificate)certificate);
                    }
                }
                if ((cacert = new File(CSecurityTLS.this.cafile)).exists() && cacert.canRead()) {
                    MyFileInputStream caStream = new MyFileInputStream(cacert);
                    Collection<? extends Certificate> cacerts = cf.generateCertificates(caStream);
                    for (Certificate certificate : cacerts) {
                        String dn = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                        ks.setCertificateEntry(dn, (X509Certificate)certificate);
                    }
                }
                PKIXBuilderParameters params = new PKIXBuilderParameters(ks, (CertSelector)new X509CertSelector());
                File crlcert = new File(CSecurityTLS.this.crlfile);
                if (!crlcert.exists() || !crlcert.canRead()) {
                    params.setRevocationEnabled(false);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(CSecurityTLS.this.crlfile);
                    Collection<? extends CRL> collection = cf.generateCRLs(fileInputStream);
                    CollectionCertStoreParameters csp = new CollectionCertStoreParameters(collection);
                    CertStore store = CertStore.getInstance("Collection", csp);
                    params.addCertStore(store);
                    params.setRevocationEnabled(true);
                }
                tmf = TrustManagerFactory.getInstance("PKIX");
                tmf.init(new CertPathTrustManagerParameters(params));
                this.tm = (X509TrustManager)tmf.getTrustManagers()[0];
            }
            catch (java.lang.Exception e) {
                throw new Exception(e.getMessage());
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.tm.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
                this.verifyHostname(chain[0]);
                this.tm.checkServerTrusted(chain, authType);
            }
            catch (java.lang.Exception e) {
                if (e.getCause() instanceof CertPathBuilderException) {
                    Object[] answer = new Object[]{"YES", "NO"};
                    X509Certificate cert = chain[0];
                    md.update(cert.getEncoded());
                    String thumbprint = DatatypeConverter.printHexBinary((byte[])md.digest());
                    thumbprint = thumbprint.replaceAll("..(?!$)", "$0 ");
                    int ret = JOptionPane.showOptionDialog(null, "This certificate has been signed by an unknown authority\n\n  Subject: " + cert.getSubjectX500Principal().getName() + "\n  Issuer: " + cert.getIssuerX500Principal().getName() + "\n  Serial Number: " + cert.getSerialNumber() + "\n  Version: " + cert.getVersion() + "\n  Signature Algorithm: " + cert.getPublicKey().getAlgorithm() + "\n  Not Valid Before: " + cert.getNotBefore() + "\n  Not Valid After: " + cert.getNotAfter() + "\n  SHA1 Fingerprint: " + thumbprint + "\n\nDo you want to save it and continue?", "Certificate Issuer Unknown", 0, 2, null, answer, answer[0]);
                    if (ret == 0) {
                        Collection<? extends Certificate> cacerts = null;
                        File vncDir = new File(FileUtils.getVncHomeDir());
                        File caFile = new File(vncDir, "x509_savedcerts.pem");
                        try {
                            if (!vncDir.exists()) {
                                vncDir.mkdir();
                            }
                            if (!caFile.createNewFile()) {
                                vlog.error("Certificate save failed.");
                                return;
                            }
                        }
                        catch (java.lang.Exception ioe) {
                            vlog.error("Certificate save failed: " + ioe.getMessage());
                            return;
                        }
                        MyFileInputStream caStream = new MyFileInputStream(caFile);
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        cacerts = cf.generateCertificates(caStream);
                        for (int i = 0; i < chain.length; ++i) {
                            if (cacerts != null && cacerts.contains(chain[i])) continue;
                            byte[] der = chain[i].getEncoded();
                            String pem = DatatypeConverter.printBase64Binary((byte[])der);
                            pem = pem.replaceAll("(.{64})", "$1\n");
                            FileWriter fw = null;
                            try {
                                fw = new FileWriter(caFile.getAbsolutePath(), true);
                                fw.write("-----BEGIN CERTIFICATE-----\n");
                                fw.write(pem + "\n");
                                fw.write("-----END CERTIFICATE-----\n");
                                continue;
                            }
                            catch (IOException ioe) {
                                throw new Exception(ioe.getMessage());
                            }
                            finally {
                                try {
                                    if (fw != null) {
                                        fw.close();
                                    }
                                }
                                catch (IOException ioe2) {
                                    throw new Exception(ioe2.getMessage());
                                }
                            }
                        }
                    }
                    throw new WarningException("Peer certificate verification failed.");
                }
                throw new SystemException(e.getMessage());
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        private void verifyHostname(X509Certificate cert) throws CertificateParsingException {
            try {
                Object[] answer;
                int ret;
                Collection<List<?>> sans = cert.getSubjectAlternativeNames();
                if (sans == null) {
                    String dn = cert.getSubjectX500Principal().getName();
                    LdapName ln = new LdapName(dn);
                    for (Rdn rdn : ln.getRdns()) {
                        String peer;
                        if (!rdn.getType().equalsIgnoreCase("CN") || !(peer = ((CConn)CSecurityTLS.this.client).getSocket().getPeerName().toLowerCase()).equals(((String)rdn.getValue()).toLowerCase())) continue;
                        return;
                    }
                } else {
                    for (List<?> nxt : sans) {
                        String peer;
                        if (!((Integer)nxt.get(0) == 2 ? (peer = ((CConn)CSecurityTLS.this.client).getSocket().getPeerName().toLowerCase()).equals(((String)nxt.get(1)).toLowerCase()) : (Integer)nxt.get(0) == 7 && (peer = ((CConn)CSecurityTLS.this.client).getSocket().getPeerAddress()).equals(((String)nxt.get(1)).toLowerCase()))) continue;
                        return;
                    }
                }
                if ((ret = JOptionPane.showOptionDialog(null, "Hostname verification failed. Do you want to continue?", "Hostname Verification Failure", 0, 2, null, answer = new Object[]{"YES", "NO"}, answer[0])) != 0) {
                    throw new WarningException("Hostname verification failed.");
                }
            }
            catch (CertificateParsingException e) {
                throw new SystemException(e.getMessage());
            }
            catch (InvalidNameException e) {
                throw new SystemException(e.getMessage());
            }
        }

        private class MyFileInputStream
        extends InputStream {
            ByteBuffer buf;

            public MyFileInputStream(String name) {
                this(new File(name));
            }

            public MyFileInputStream(File file) {
                StringBuffer sb = new StringBuffer();
                BufferedReader reader = null;
                try {
                    String l;
                    reader = new BufferedReader(new FileReader(file));
                    while ((l = reader.readLine()) != null) {
                        if (l.trim().length() <= 0) continue;
                        sb.append(l + "\n");
                    }
                }
                catch (java.lang.Exception e) {
                    throw new Exception(e.toString());
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ioe) {
                        throw new Exception(ioe.getMessage());
                    }
                }
                Charset utf8 = Charset.forName("UTF-8");
                this.buf = ByteBuffer.wrap(sb.toString().getBytes(utf8));
                this.buf.limit(this.buf.capacity());
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, this.buf.remaining());
                this.buf.get(b, off, len);
                return len;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }
        }
    }
}

