/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.Encoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.JpegCompressor;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.ScreenSet;

public class ConnParams {
    static LogWriter vlog = new LogWriter("ConnParams");
    public int majorVersion = 0;
    public int minorVersion = 0;
    public int width = 0;
    public int height = 0;
    public ScreenSet screenLayout = new ScreenSet();
    public boolean done;
    public boolean useCopyRect = false;
    public boolean supportsLocalCursor = false;
    public boolean supportsLocalXCursor = false;
    public boolean supportsDesktopResize = false;
    public boolean supportsExtendedDesktopSize = false;
    public boolean supportsDesktopRename = false;
    public boolean supportsClientRedirect = false;
    public boolean supportsFence = false;
    public boolean supportsContinuousUpdates = false;
    public boolean supportsLastRect = false;
    public boolean supportsSetDesktopSize = false;
    public boolean customCompressLevel = false;
    public int compressLevel = 6;
    public boolean noJpeg = false;
    public int qualityLevel = -1;
    public int fineQualityLevel = -1;
    public String subsampling = "SUBSAMP_UNDEFINED";
    private PixelFormat pf_;
    private String name_ = null;
    private int nEncodings_ = 0;
    private int[] encodings_ = null;
    private int currentEncoding_ = 0;
    private StringBuilder verStr;
    private int verStrPos = 0;

    public ConnParams() {
        this.setName("");
    }

    public boolean readVersion(InStream is) {
        this.done = false;
        if (this.verStrPos >= 12) {
            return false;
        }
        this.verStr = new StringBuilder(13);
        while (is.checkNoWait(1) && this.verStrPos < 12) {
            this.verStr.insert(this.verStrPos++, (char)is.readU8());
        }
        if (this.verStrPos < 12) {
            this.done = false;
            return true;
        }
        this.done = true;
        this.verStr.insert(12, '0');
        this.verStrPos = 0;
        if (this.verStr.toString().matches("RFB \\d{3}\\.\\d{3}\\n0")) {
            this.majorVersion = Integer.parseInt(this.verStr.substring(4, 7));
            this.minorVersion = Integer.parseInt(this.verStr.substring(8, 11));
            return true;
        }
        return false;
    }

    public void writeVersion(OutStream os) {
        String str = String.format("RFB %03d.%03d\n", this.majorVersion, this.minorVersion);
        os.writeBytes(str.getBytes(), 0, 12);
        os.flush();
    }

    public void setVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    public boolean isVersion(int major, int minor) {
        return this.majorVersion == major && this.minorVersion == minor;
    }

    public boolean beforeVersion(int major, int minor) {
        return this.majorVersion < major || this.majorVersion == major && this.minorVersion < minor;
    }

    public boolean afterVersion(int major, int minor) {
        return !this.beforeVersion(major, minor + 1);
    }

    public PixelFormat pf() {
        return this.pf_;
    }

    public void setPF(PixelFormat pf) {
        this.pf_ = pf;
        if (pf.bpp != 8 && pf.bpp != 16 && pf.bpp != 32) {
            throw new Exception("setPF: not 8, 16 or 32 bpp?");
        }
    }

    public String name() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public int currentEncoding() {
        return this.currentEncoding_;
    }

    public int nEncodings() {
        return this.nEncodings_;
    }

    public int[] encodings() {
        return this.encodings_;
    }

    public void setEncodings(int nEncodings, int[] encodings) {
        int i;
        if (nEncodings > this.nEncodings_) {
            this.encodings_ = new int[nEncodings];
        }
        this.nEncodings_ = nEncodings;
        this.useCopyRect = false;
        this.supportsLocalCursor = false;
        this.supportsDesktopResize = false;
        this.supportsExtendedDesktopSize = false;
        this.supportsLocalXCursor = false;
        this.supportsLastRect = false;
        this.customCompressLevel = false;
        this.compressLevel = -1;
        this.noJpeg = true;
        this.qualityLevel = -1;
        this.fineQualityLevel = -1;
        this.subsampling = "SUBSAMP_UNDEFINED";
        this.currentEncoding_ = 0;
        for (i = nEncodings - 1; i >= 0; --i) {
            this.encodings_[i] = encodings[i];
            if (encodings[i] == 1) {
                this.useCopyRect = true;
                continue;
            }
            if (encodings[i] == -239) {
                this.supportsLocalCursor = true;
                continue;
            }
            if (encodings[i] == -240) {
                this.supportsLocalXCursor = true;
                continue;
            }
            if (encodings[i] == -223) {
                this.supportsDesktopResize = true;
                continue;
            }
            if (encodings[i] == -308) {
                this.supportsExtendedDesktopSize = true;
                continue;
            }
            if (encodings[i] == -307) {
                this.supportsDesktopRename = true;
                continue;
            }
            if (encodings[i] == -224) {
                this.supportsLastRect = true;
                continue;
            }
            if (encodings[i] == -312) {
                this.supportsFence = true;
                continue;
            }
            if (encodings[i] == -313) {
                this.supportsContinuousUpdates = true;
                continue;
            }
            if (encodings[i] == -311) {
                this.supportsClientRedirect = true;
                continue;
            }
            if (encodings[i] >= -256 && encodings[i] <= -247) {
                this.customCompressLevel = true;
                this.compressLevel = encodings[i] - -256;
                continue;
            }
            if (encodings[i] >= -32 && encodings[i] <= -23) {
                this.noJpeg = false;
                this.qualityLevel = encodings[i] - -32;
                continue;
            }
            if (encodings[i] > 255 || !Encoder.supported(encodings[i])) continue;
            this.currentEncoding_ = encodings[i];
        }
        for (i = nEncodings - 1; i >= 0; --i) {
            if (encodings[i] >= -511 && encodings[i] <= -412) {
                this.noJpeg = false;
                this.fineQualityLevel = encodings[i] - -512;
                continue;
            }
            if (encodings[i] < -768 || encodings[i] > -765) continue;
            this.noJpeg = false;
            this.subsampling = JpegCompressor.subsamplingName(encodings[i] - -768);
        }
    }
}

