/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.VoidParameter;

public class IntParameter
extends VoidParameter {
    protected int value;
    protected int defValue;
    protected int minValue;
    protected int maxValue;

    public IntParameter(String name_, String desc_, int v, int minValue_, int maxValue_, Configuration.ConfigurationObject co) {
        super(name_, desc_, co);
        this.value = v;
        this.defValue = v;
        this.minValue = minValue_;
        this.maxValue = maxValue_;
    }

    public IntParameter(String name_, String desc_, int v) {
        this(name_, desc_, v, Integer.MIN_VALUE, Integer.MAX_VALUE, Configuration.ConfigurationObject.ConfGlobal);
    }

    @Override
    public boolean setParam(String v) {
        if (this.immutable) {
            return true;
        }
        vlog.debug("set " + this.getName() + "(Int) to " + v);
        try {
            int i = Integer.parseInt(v);
            if (i < this.minValue || i > this.maxValue) {
                return false;
            }
            this.value = i;
            return true;
        }
        catch (NumberFormatException e) {
            throw new Exception(e.toString());
        }
    }

    public boolean setParam(int v) {
        if (this.immutable) {
            return true;
        }
        vlog.debug("set " + this.getName() + "(Int) to " + v);
        if (v < this.minValue || v > this.maxValue) {
            return false;
        }
        this.value = v;
        return true;
    }

    @Override
    public String getDefaultStr() {
        return Integer.toString(this.defValue);
    }

    @Override
    public String getValueStr() {
        return Integer.toString(this.value);
    }

    public int getValue() {
        return this.value;
    }
}

