/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.PixelFormat;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class PixelBuffer {
    public int[] data;
    public ColorModel cm;
    protected PixelFormat format;
    protected int width_;
    protected int height_;

    public PixelBuffer() {
        this.setPF(new PixelFormat());
    }

    public void setPF(PixelFormat pf) {
        if (pf.bpp != 32 && pf.bpp != 16 && pf.bpp != 8) {
            throw new Exception("Internal error: bpp must be 8, 16, or 32 in PixelBuffer (" + pf.bpp + ")");
        }
        this.format = pf;
        switch (pf.depth) {
            case 3: 
            case 6: 
            case 8: {
                if (!pf.trueColour) {
                    if (this.cm != null) break;
                    this.cm = new IndexColorModel(8, 256, new byte[256], new byte[256], new byte[256]);
                    break;
                }
                int rmask = pf.redMax << pf.redShift;
                int gmask = pf.greenMax << pf.greenShift;
                int bmask = pf.blueMax << pf.blueShift;
                this.cm = new DirectColorModel(8, rmask, gmask, bmask);
                break;
            }
            case 16: {
                this.cm = new DirectColorModel(32, 63488, 1984, 62);
                break;
            }
            case 24: {
                this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
                break;
            }
            case 32: {
                this.cm = new DirectColorModel(32, 255 << pf.redShift, 255 << pf.greenShift, 255 << pf.blueShift);
                break;
            }
            default: {
                throw new Exception("Unsupported color depth (" + pf.depth + ")");
            }
        }
    }

    public PixelFormat getPF() {
        return this.format;
    }

    public final int width() {
        return this.width_;
    }

    public final int height() {
        return this.height_;
    }

    public final int area() {
        return this.width_ * this.height_;
    }

    public void fillRect(int x, int y, int w, int h, int pix) {
        for (int ry = y; ry < y + h; ++ry) {
            for (int rx = x; rx < x + w; ++rx) {
                this.data[ry * this.width_ + rx] = pix;
            }
        }
    }

    public void imageRect(int x, int y, int w, int h, int[] pix) {
        for (int j = 0; j < h; ++j) {
            System.arraycopy(pix, w * j, this.data, this.width_ * (y + j) + x, w);
        }
    }

    public void copyRect(int x, int y, int w, int h, int srcX, int srcY) {
        int dest = this.width_ * y + x;
        int src = this.width_ * srcY + srcX;
        int inc = this.width_;
        if (y > srcY) {
            src += (h - 1) * inc;
            dest += (h - 1) * inc;
            inc = -inc;
        }
        int destEnd = dest + h * inc;
        while (dest != destEnd) {
            System.arraycopy(this.data, src, this.data, dest, w);
            src += inc;
            dest += inc;
        }
    }

    public void maskRect(int x, int y, int w, int h, int[] pix, byte[] mask) {
        int maskBytesPerRow = (w + 7) / 8;
        for (int j = 0; j < h; ++j) {
            int cy = y + j;
            if (cy < 0 || cy >= this.height_) continue;
            for (int i = 0; i < w; ++i) {
                int bit;
                int byte_;
                int cx = x + i;
                if (cx < 0 || cx >= this.width_ || (mask[byte_ = j * maskBytesPerRow + i / 8] & 1 << (bit = 7 - i % 8)) == 0) continue;
                this.data[cy * this.width_ + cx] = pix[j * w + i];
            }
        }
    }
}

