/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReader;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Rect;

public class RREDecoder
extends Decoder {
    CMsgReader reader;

    public RREDecoder(CMsgReader reader_) {
        this.reader = reader_;
    }

    @Override
    public void readRect(Rect r, CMsgHandler handler) {
        InStream is = this.reader.getInStream();
        int bytesPerPixel = handler.cp.pf().bpp / 8;
        boolean bigEndian = handler.cp.pf().bigEndian;
        int nSubrects = is.readU32();
        int bg = is.readPixel(bytesPerPixel, bigEndian);
        handler.fillRect(r, bg);
        for (int i = 0; i < nSubrects; ++i) {
            int pix = is.readPixel(bytesPerPixel, bigEndian);
            int x = is.readU16();
            int y = is.readU16();
            int w = is.readU16();
            int h = is.readU16();
            handler.fillRect(new Rect(r.tl.x + x, r.tl.y + y, r.tl.x + x + w, r.tl.y + y + h), pix);
        }
    }
}

