/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.BoolParameter;
import com.tigervnc.rfb.Cursor;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ManagedPixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.vncviewer.BIPixelBuffer;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.PlatformPixelBuffer;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.BufferCapabilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;

class DesktopWindow
extends JPanel
implements Runnable,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final Integer keyEventLock = 0;
    CConn cc;
    PlatformPixelBuffer im;
    Thread setColourMapEntriesTimerThread;
    Cursor cursor;
    boolean cursorVisible = false;
    boolean cursorAvailable = false;
    int cursorPosX;
    int cursorPosY;
    ManagedPixelBuffer cursorBacking;
    int cursorBackingX;
    int cursorBackingY;
    java.awt.Cursor softCursor;
    java.awt.Cursor nullCursor;
    static Toolkit tk = Toolkit.getDefaultToolkit();
    public int scaledWidth = 0;
    public int scaledHeight = 0;
    float scaleWidthRatio;
    float scaleHeightRatio;
    int lastX;
    int lastY;
    Rect damage = new Rect();
    static LogWriter vlog = new LogWriter("DesktopWindow");

    public DesktopWindow(int width, int height, PixelFormat serverPF, CConn cc_) {
        this.cc = cc_;
        this.setSize(width, height);
        this.setScaledSize();
        this.setOpaque(false);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferCapabilities bufCaps = gc.getBufferCapabilities();
        ImageCapabilities imgCaps = gc.getImageCapabilities();
        if (bufCaps.isPageFlipping() || bufCaps.isMultiBufferAvailable() || imgCaps.isAccelerated()) {
            vlog.debug("GraphicsDevice supports HW acceleration.");
        } else {
            vlog.debug("GraphicsDevice does not support HW acceleration.");
        }
        this.im = new BIPixelBuffer(width, height, this.cc, this);
        this.cursor = new Cursor();
        this.cursorBacking = new ManagedPixelBuffer();
        Dimension bestSize = tk.getBestCursorSize(16, 16);
        BufferedImage cursorImage = new BufferedImage(bestSize.width, bestSize.height, 2);
        java.awt.Point hotspot = new java.awt.Point(0, 0);
        this.nullCursor = tk.createCustomCursor(cursorImage, hotspot, "nullCursor");
        cursorImage.flush();
        if (!this.cc.cp.supportsLocalCursor && !bestSize.equals(new Dimension(0, 0))) {
            this.setCursor(this.nullCursor);
        }
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DesktopWindow.this.cc.clipboardDialog.clientCutText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DesktopWindow.this.cc.releaseDownKeys();
            }
        });
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusable(true);
    }

    public int width() {
        return this.getWidth();
    }

    public int height() {
        return this.getHeight();
    }

    public final PixelFormat getPF() {
        return this.im.getPF();
    }

    public void setViewport(JViewport viewport) {
        this.setScaledSize();
        viewport.setView(this);
        if (viewport.getRootPane() != null && this.getRootPane().getParent() instanceof JFrame) {
            ((JFrame)this.getRootPane().getParent()).pack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(int w, int h, Point hotspot, int[] data, byte[] mask) {
        BoolParameter boolParameter = this.cc.viewer.useLocalCursor;
        synchronized (boolParameter) {
            if (!this.cc.viewer.useLocalCursor.getValue()) {
                return;
            }
        }
        this.hideLocalCursor();
        this.cursor.hotspot = hotspot != null ? hotspot : new Point(0, 0);
        this.cursor.setSize(w, h);
        this.cursor.setPF(this.getPF());
        this.cursorBacking.setSize(this.cursor.width(), this.cursor.height());
        this.cursorBacking.setPF(this.getPF());
        this.cursor.data = new int[this.cursor.width() * this.cursor.height()];
        this.cursor.mask = new byte[this.cursor.maskLen()];
        int maskBytesPerRow = (w + 7) / 8;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int byte_ = y * maskBytesPerRow + x / 8;
                int bit = 7 - x % 8;
                if ((mask[byte_] & 1 << bit) <= 0) continue;
                this.cursor.data[y * this.cursor.width() + x] = 0xFF000000 | this.im.cm.getRed(data[y * w + x]) << 16 | this.im.cm.getGreen(data[y * w + x]) << 8 | this.im.cm.getBlue(data[y * w + x]);
            }
            System.arraycopy(mask, y * maskBytesPerRow, this.cursor.mask, y * ((this.cursor.width() + 7) / 8), maskBytesPerRow);
        }
        int cw = (int)Math.floor((float)this.cursor.width() * this.scaleWidthRatio);
        int ch = (int)Math.floor((float)this.cursor.height() * this.scaleHeightRatio);
        Dimension bestSize = tk.getBestCursorSize(cw, ch);
        MemoryImageSource cursorSrc = new MemoryImageSource(this.cursor.width(), this.cursor.height(), ColorModel.getRGBdefault(), this.cursor.data, 0, this.cursor.width());
        Image srcImage = tk.createImage(cursorSrc);
        BufferedImage cursorImage = new BufferedImage(bestSize.width, bestSize.height, 2);
        Graphics2D g2 = cursorImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.drawImage(srcImage, 0, 0, Math.min(cw, bestSize.width), Math.min(ch, bestSize.height), 0, 0, this.cursor.width(), this.cursor.height(), null);
        g2.dispose();
        srcImage.flush();
        int x = (int)Math.floor((float)this.cursor.hotspot.x * this.scaleWidthRatio);
        int y = (int)Math.floor((float)this.cursor.hotspot.y * this.scaleHeightRatio);
        x = Math.min(x, Math.max(bestSize.width - 1, 0));
        y = Math.min(y, Math.max(bestSize.height - 1, 0));
        java.awt.Point hs = new java.awt.Point(x, y);
        if (!bestSize.equals(new Dimension(0, 0))) {
            this.softCursor = tk.createCustomCursor(cursorImage, hs, "softCursor");
        }
        cursorImage.flush();
        if (this.softCursor != null) {
            this.setCursor(this.softCursor);
            this.cursorAvailable = false;
            return;
        }
        if (!this.cursorAvailable) {
            this.cursorAvailable = true;
        }
        this.showLocalCursor();
    }

    public void setServerPF(PixelFormat pf) {
        this.im.setPF(pf);
    }

    public PixelFormat getPreferredPF() {
        return this.im.getNativePF();
    }

    public synchronized void setColourMapEntries(int firstColour, int nColours, int[] rgbs) {
        this.im.setColourMapEntries(firstColour, nColours, rgbs);
        if (nColours <= 256) {
            this.im.updateColourMap();
        } else if (this.setColourMapEntriesTimerThread == null) {
            this.setColourMapEntriesTimerThread = new Thread(this);
            this.setColourMapEntriesTimerThread.start();
        }
    }

    public void updateWindow() {
        Rect r = this.damage;
        if (!r.is_empty()) {
            if (this.cc.cp.width != this.scaledWidth || this.cc.cp.height != this.scaledHeight) {
                int x = (int)Math.floor((float)r.tl.x * this.scaleWidthRatio);
                int y = (int)Math.floor((float)r.tl.y * this.scaleHeightRatio);
                int width = (int)Math.ceil((float)r.width() * this.scaleWidthRatio) + 1;
                int height = (int)Math.ceil((float)r.height() * this.scaleHeightRatio) + 1;
                this.paintImmediately(x, y, width, height);
            } else {
                this.paintImmediately(r.tl.x, r.tl.y, r.width(), r.height());
            }
            this.damage.clear();
        }
    }

    public void resize() {
        int w = this.cc.cp.width;
        int h = this.cc.cp.height;
        this.hideLocalCursor();
        this.setSize(w, h);
        this.setScaledSize();
        this.im.resize(w, h);
    }

    public final void fillRect(int x, int y, int w, int h, int pix) {
        if (this.overlapsCursor(x, y, w, h)) {
            this.hideLocalCursor();
        }
        this.im.fillRect(x, y, w, h, pix);
        this.damageRect(new Rect(x, y, x + w, y + h));
        this.showLocalCursor();
    }

    public final void imageRect(int x, int y, int w, int h, Object pix) {
        if (this.overlapsCursor(x, y, w, h)) {
            this.hideLocalCursor();
        }
        this.im.imageRect(x, y, w, h, pix);
        this.damageRect(new Rect(x, y, x + w, y + h));
        this.showLocalCursor();
    }

    public final void copyRect(int x, int y, int w, int h, int srcX, int srcY) {
        if (this.overlapsCursor(x, y, w, h) || this.overlapsCursor(srcX, srcY, w, h)) {
            this.hideLocalCursor();
        }
        this.im.copyRect(x, y, w, h, srcX, srcY);
        this.damageRect(new Rect(x, y, x + w, y + h));
        this.showLocalCursor();
    }

    final boolean overlapsCursor(int x, int y, int w, int h) {
        return x < this.cursorBackingX + this.cursorBacking.width() && y < this.cursorBackingY + this.cursorBacking.height() && x + w > this.cursorBackingX && y + h > this.cursorBackingY;
    }

    void resetLocalCursor() {
        if (this.cc.cp.supportsLocalCursor) {
            if (this.softCursor != null) {
                this.setCursor(this.softCursor);
            }
        } else {
            this.setCursor(this.nullCursor);
        }
        this.hideLocalCursor();
        this.cursorAvailable = false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    public void setScaledSize() {
        String scaleString = this.cc.viewer.scalingFactor.getValue();
        if (!scaleString.equalsIgnoreCase("Auto") && !scaleString.equalsIgnoreCase("FixedRatio")) {
            int scalingFactor = Integer.parseInt(scaleString);
            this.scaledWidth = (int)Math.floor((double)((float)this.cc.cp.width * (float)scalingFactor) / 100.0);
            this.scaledHeight = (int)Math.floor((double)((float)this.cc.cp.height * (float)scalingFactor) / 100.0);
        } else if (this.cc.viewport == null) {
            this.scaledWidth = this.cc.cp.width;
            this.scaledHeight = this.cc.cp.height;
        } else {
            Dimension vpSize = this.cc.viewport.getSize();
            Insets vpInsets = this.cc.viewport.getInsets();
            Dimension availableSize = new Dimension(vpSize.width - vpInsets.left - vpInsets.right, vpSize.height - vpInsets.top - vpInsets.bottom);
            if (availableSize.width == 0 || availableSize.height == 0) {
                availableSize = new Dimension(this.cc.cp.width, this.cc.cp.height);
            }
            if (scaleString.equalsIgnoreCase("FixedRatio")) {
                float widthRatio = (float)availableSize.width / (float)this.cc.cp.width;
                float heightRatio = (float)availableSize.height / (float)this.cc.cp.height;
                float ratio = Math.min(widthRatio, heightRatio);
                this.scaledWidth = (int)Math.floor((float)this.cc.cp.width * ratio);
                this.scaledHeight = (int)Math.floor((float)this.cc.cp.height * ratio);
            } else {
                this.scaledWidth = availableSize.width;
                this.scaledHeight = availableSize.height;
            }
        }
        this.scaleWidthRatio = (float)this.scaledWidth / (float)this.cc.cp.width;
        this.scaleHeightRatio = (float)this.scaledHeight / (float)this.cc.cp.height;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.cc.cp.width != this.scaledWidth || this.cc.cp.height != this.scaledHeight) {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.drawImage(this.im.getImage(), 0, 0, this.scaledWidth, this.scaledHeight, null);
        } else {
            g2.drawImage(this.im.getImage(), 0, 0, null);
        }
        g2.dispose();
    }

    private void mouseMotionCB(MouseEvent e) {
        if (!this.cc.viewer.viewOnly.getValue() && e.getX() >= 0 && e.getX() <= this.scaledWidth && e.getY() >= 0 && e.getY() <= this.scaledHeight) {
            this.cc.writePointerEvent(e);
        }
        if (this.cursorAvailable && (e.getX() != this.cursorPosX || e.getY() != this.cursorPosY)) {
            this.hideLocalCursor();
            if (e.getX() >= 0 && e.getX() < this.im.width() && e.getY() >= 0 && e.getY() < this.im.height()) {
                this.cursorPosX = e.getX();
                this.cursorPosY = e.getY();
                this.showLocalCursor();
            }
        }
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMotionCB(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseMotionCB(e);
    }

    private void mouseCB(MouseEvent e) {
        if (!this.cc.viewer.viewOnly.getValue() && (e.getID() == 502 || e.getX() >= 0 && e.getX() <= this.scaledWidth && e.getY() >= 0 && e.getY() <= this.scaledHeight)) {
            this.cc.writePointerEvent(e);
        }
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseCB(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseCB(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.cc.viewer.embed.getValue()) {
            this.requestFocus();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void mouseWheelCB(MouseWheelEvent e) {
        if (!this.cc.viewer.viewOnly.getValue()) {
            this.cc.writeWheelEvent(e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseWheelCB(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        Integer n = keyEventLock;
        synchronized (n) {
            this.cc.writeKeyEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == MenuKey.getMenuKeyCode()) {
            int sx = (double)this.scaleWidthRatio == 1.0 ? this.lastX : (int)Math.floor((float)this.lastX * this.scaleWidthRatio);
            int sy = (double)this.scaleHeightRatio == 1.0 ? this.lastY : (int)Math.floor((float)this.lastY * this.scaleHeightRatio);
            java.awt.Point ev = new java.awt.Point(this.lastX, this.lastY);
            ev.translate(sx - this.lastX, sy - this.lastY);
            this.cc.showMenu((int)ev.getX(), (int)ev.getY());
            return;
        }
        int ctrlAltShiftMask = 11;
        if ((e.getModifiers() & ctrlAltShiftMask) == ctrlAltShiftMask) {
            switch (e.getKeyCode()) {
                case 65: {
                    this.cc.showAbout();
                    return;
                }
                case 70: {
                    this.cc.toggleFullScreen();
                    return;
                }
                case 72: {
                    this.cc.refresh();
                    return;
                }
                case 73: {
                    this.cc.showInfo();
                    return;
                }
                case 79: {
                    this.cc.options.showDialog(this.cc.viewport);
                    return;
                }
                case 87: {
                    VncViewer.newViewer(this.cc.viewer);
                    return;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    return;
                }
            }
        }
        if ((e.getModifiers() & 4) == 4) {
            switch (e.getKeyCode()) {
                case 44: 
                case 70: 
                case 73: 
                case 76: 
                case 78: 
                case 82: 
                case 84: 
                case 87: 
                case 90: {
                    return;
                }
            }
        }
        Integer n = keyEventLock;
        synchronized (n) {
            this.cc.writeKeyEvent(e);
        }
    }

    private synchronized void hideLocalCursor() {
        if (this.cursorVisible) {
            this.cursorVisible = false;
            this.im.imageRect(this.cursorBackingX, this.cursorBackingY, this.cursorBacking.width(), this.cursorBacking.height(), this.cursorBacking.data);
            this.damageRect(new Rect(this.cursorBackingX, this.cursorBackingY, this.cursorBackingX + this.cursorBacking.width(), this.cursorBackingY + this.cursorBacking.height()));
        }
    }

    private synchronized void showLocalCursor() {
        if (this.cursorAvailable && !this.cursorVisible) {
            if (!this.im.getPF().equal(this.cursor.getPF()) || this.cursor.width() == 0 || this.cursor.height() == 0) {
                vlog.debug("attempting to render invalid local cursor");
                this.cursorAvailable = false;
                return;
            }
            this.cursorVisible = true;
            int cursorLeft = this.cursor.hotspot.x;
            int cursorTop = this.cursor.hotspot.y;
            int cursorRight = cursorLeft + this.cursor.width();
            int cursorBottom = cursorTop + this.cursor.height();
            int x = cursorLeft >= 0 ? cursorLeft : 0;
            int y = cursorTop >= 0 ? cursorTop : 0;
            int w = (cursorRight < this.im.width() ? cursorRight : this.im.width()) - x;
            int h = (cursorBottom < this.im.height() ? cursorBottom : this.im.height()) - y;
            this.cursorBackingX = x;
            this.cursorBackingY = y;
            this.cursorBacking.setSize(w, h);
            for (int j = 0; j < h; ++j) {
                System.arraycopy(this.im.data, (y + j) * this.im.width() + x, this.cursorBacking.data, j * w, w);
            }
            this.im.maskRect(cursorLeft, cursorTop, this.cursor.width(), this.cursor.height(), this.cursor.data, this.cursor.mask);
            this.damageRect(new Rect(x, y, x + w, y + h));
        }
    }

    void damageRect(Rect r) {
        if (this.damage.is_empty()) {
            this.damage.setXYWH(r.tl.x, r.tl.y, r.width(), r.height());
        } else {
            r = this.damage.union_boundary(r);
            this.damage.setXYWH(r.tl.x, r.tl.y, r.width(), r.height());
        }
    }

    @Override
    public synchronized void run() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.im.updateColourMap();
        this.setColourMapEntriesTimerThread = null;
    }
}

