/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.Cursor;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class Viewport
extends JFrame {
    CConn cc;
    JScrollPane sp;
    boolean canDoLionFS;
    static LogWriter vlog = new LogWriter("Viewport");

    public Viewport(String name, CConn cc_) {
        this.cc = cc_;
        this.setTitle(name + " - TigerVNC");
        this.setFocusable(false);
        this.setFocusTraversalKeysEnabled(false);
        if (!VncViewer.os.startsWith("mac os x")) {
            this.setIconImage(VncViewer.frameIcon);
        }
        UIManager.getDefaults().put("ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[0]));
        this.sp = new JScrollPane();
        this.sp.getViewport().setBackground(Color.BLACK);
        this.sp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.sp);
        if (VncViewer.os.startsWith("mac os x") && !VncViewer.noLionFS.getValue()) {
            this.enableLionFS();
        }
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (Viewport.this.isVisible()) {
                    Viewport.this.sp.getViewport().getView().requestFocusInWindow();
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                Viewport.this.cc.releaseDownKeys();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (VncViewer.nViewers == 1) {
                    if (Viewport.this.cc.closeListener != null) {
                        Viewport.this.cc.close();
                    } else {
                        Viewport.this.cc.viewer.exit(1);
                    }
                } else {
                    Viewport.this.cc.close();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                String scaleString = Viewport.this.cc.viewer.scalingFactor.getValue();
                if (scaleString.equalsIgnoreCase("Auto") || scaleString.equalsIgnoreCase("FixedRatio")) {
                    if (Viewport.this.sp.getSize().width != Viewport.this.cc.desktop.scaledWidth || Viewport.this.sp.getSize().height != Viewport.this.cc.desktop.scaledHeight) {
                        Viewport.this.cc.desktop.setScaledSize();
                        Viewport.this.sp.setHorizontalScrollBarPolicy(31);
                        Viewport.this.sp.setVerticalScrollBarPolicy(21);
                        Viewport.this.sp.validate();
                        if (Viewport.this.getExtendedState() != 6 && !Viewport.this.cc.fullScreen) {
                            Viewport.this.sp.setSize(new Dimension(Viewport.this.cc.desktop.scaledWidth, Viewport.this.cc.desktop.scaledHeight));
                            int w = Viewport.this.cc.desktop.scaledWidth + Viewport.this.getInsets().left + Viewport.this.getInsets().right;
                            int h = Viewport.this.cc.desktop.scaledHeight + Viewport.this.getInsets().top + Viewport.this.getInsets().bottom;
                            if (scaleString.equalsIgnoreCase("FixedRatio")) {
                                Viewport.this.setSize(w, h);
                            }
                        }
                    }
                } else {
                    Viewport.this.sp.setHorizontalScrollBarPolicy(30);
                    Viewport.this.sp.setVerticalScrollBarPolicy(20);
                    Viewport.this.sp.validate();
                }
                if (Viewport.this.cc.desktop.cursor != null) {
                    Cursor cursor = Viewport.this.cc.desktop.cursor;
                    Viewport.this.cc.setCursor(cursor.width(), cursor.height(), cursor.hotspot, cursor.data, cursor.mask);
                }
            }
        });
    }

    boolean lionFSSupported() {
        return this.canDoLionFS;
    }

    void enableLionFS() {
        try {
            double v;
            String version = System.getProperty("os.version");
            int firstDot = version.indexOf(46);
            int lastDot = version.lastIndexOf(46);
            if (lastDot > firstDot && lastDot >= 0) {
                version = version.substring(0, version.indexOf(46, firstDot + 1));
            }
            if ((v = Double.parseDouble(version)) < 10.7) {
                throw new Exception("Operating system version is " + v);
            }
            Class<?> fsuClass = Class.forName("com.apple.eawt.FullScreenUtilities");
            Class[] argClasses = new Class[]{Window.class, Boolean.TYPE};
            Method setWindowCanFullScreen = fsuClass.getMethod("setWindowCanFullScreen", argClasses);
            setWindowCanFullScreen.invoke(fsuClass, this, true);
            this.canDoLionFS = true;
        }
        catch (Exception e) {
            vlog.debug("Could not enable OS X 10.7+ full-screen mode: " + e.getMessage());
        }
    }

    public void toggleLionFS() {
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Method getApplication = appClass.getMethod("getApplication", null);
            Object app = getApplication.invoke(appClass, new Object[0]);
            Method requestToggleFullScreen = appClass.getMethod("requestToggleFullScreen", Window.class);
            requestToggleFullScreen.invoke(app, this);
        }
        catch (Exception e) {
            vlog.debug("Could not toggle OS X 10.7+ full-screen mode: " + e.getMessage());
        }
    }

    public JViewport getViewport() {
        return this.sp.getViewport();
    }

    public void setGeometry(int x, int y, int w, int h) {
        this.pack();
        if (!this.cc.fullScreen) {
            this.setLocation(x, y);
        }
    }

    public Dimension getScreenSize() {
        return this.getScreenBounds().getSize();
    }

    public Rectangle getScreenBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle r = new Rectangle();
        this.setMaximizedBounds(null);
        if (this.cc.viewer.fullScreenAllMonitors.getValue()) {
            for (GraphicsDevice gd : ge.getScreenDevices()) {
                for (GraphicsConfiguration gc : gd.getConfigurations()) {
                    r = r.union(gc.getBounds());
                }
            }
            Rectangle mb = new Rectangle(r);
            mb.grow(this.getInsets().left, this.getInsets().bottom);
            this.setMaximizedBounds(mb);
        } else {
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            r = gc.getBounds();
        }
        return r;
    }

    public static Window getFullScreenWindow() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        Window fullScreenWindow = gd.getFullScreenWindow();
        return fullScreenWindow;
    }

    public static void setFullScreenWindow(Window fullScreenWindow) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        if (gd.isFullScreenSupported()) {
            gd.setFullScreenWindow(fullScreenWindow);
        }
    }
}

