/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.FBConfig;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.sikuli.basics.Debug;

public class Framebuffer
extends GraphicsDevice {
    private FBConfig conf = null;
    private BufferedImage buffer;
    private int[][] rgbs = null;
    private boolean updated = false;
    private BufferedImage doubleBuffer;

    protected boolean setPF(int[] data, String name) {
        if (this.conf != null) {
            int[] array = new int[]{this.getWidth(), this.getHeight(), data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8], data[9]};
            this.conf = new FBConfig(array, name);
        } else {
            this.conf = new FBConfig(data, name);
        }
        return this.conf.getIdNum() != 5;
    }

    protected boolean resetPF(int[] data) {
        return this.setPF(data, this.conf.getName());
    }

    protected GraphicsConfiguration getPF() {
        return this.conf;
    }

    protected int getWidth() {
        return this.conf.getBounds().width;
    }

    protected int getHeight() {
        return this.conf.getBounds().height;
    }

    private synchronized void setBuffer(WritableRaster raster) {
        this.buffer = this.conf.createCompatibleImage(this.conf.getBounds().width, this.conf.getBounds().height);
        this.buffer.setData(raster);
        this.updated = true;
        this.doubleBuffer = this.buffer;
    }

    protected synchronized BufferedImage getBuffer() {
        if (this.updated) {
            this.updated = false;
            return this.buffer;
        }
        return this.doubleBuffer;
    }

    protected void raw(int x, int y, int w, int h, int[] input) {
        if (this.rgbs == null) {
            this.rgbs = new int[this.conf.getBounds().width * 3][this.conf.getBounds().height];
        }
        int count = 0;
        block0: for (int j = y; j < h + y; ++j) {
            for (int i = x * 3; i < w * 3 + x * 3; ++i) {
                this.rgbs[i][j] = input[count];
                if (++count == input.length) break block0;
            }
        }
    }

    protected void convertToBufferedImage() {
        switch (this.conf.getIdNum()) {
            case 0: {
                Debug.log(3, "Error: Config not supported", new Object[0]);
                break;
            }
            case 1: {
                Debug.log(3, "Error: Config not supported", new Object[0]);
                break;
            }
            case 2: {
                Debug.log(3, "Error: Config not supported", new Object[0]);
                break;
            }
            case 3: {
                Debug.log(3, "Error: Config not supported", new Object[0]);
                break;
            }
            case 4: {
                Debug.log(3, "Error: Config not supported", new Object[0]);
                break;
            }
            case 5: {
                int[] rgbSamples = new int[this.conf.getBounds().width * this.conf.getBounds().height * 3];
                int count = 0;
                for (int j = 0; j < this.conf.getBounds().height; ++j) {
                    for (int i = 0; i < this.conf.getBounds().width * 3; ++i) {
                        rgbSamples[count] = this.rgbs[i][j];
                        ++count;
                    }
                }
                WritableRaster raster = (WritableRaster)this.conf.createCompatibleRaster();
                raster.setPixels(0, 0, this.conf.getBounds().width, this.conf.getBounds().height, rgbSamples);
                this.setBuffer(raster);
                break;
            }
            default: {
                Debug.log(3, "Error: Config not supported", new Object[0]);
            }
        }
    }

    protected synchronized void copyRect(int x, int y, int w, int h, int srcx, int srcy) {
        BufferedImage sub = this.buffer.getSubimage(srcx, srcy, w, h);
        this.buffer.setData(sub.getRaster().createTranslatedChild(x, y));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getIDstring() {
        return "RFB";
    }

    @Override
    public GraphicsConfiguration[] getConfigurations() {
        return new GraphicsConfiguration[]{this.conf};
    }

    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        return this.conf;
    }
}

