/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.ProtocolVersion;
import edu.unh.iol.dlc.VersionParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.sikuli.basics.Debug;

public class VNCClient {
    private BufferedWriter out = null;
    private BufferedReader in = null;
    private DataOutputStream dataOut = null;
    private DataInputStream dataIn = null;
    private int version = 0;
    private Socket socket = null;
    private int bef;

    public VNCClient(Socket soc) {
        this.socket = soc;
        try {
            this.socket.setTcpNoDelay(true);
            this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "US-ASCII"));
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "US-ASCII"));
            this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.dataIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (IOException e) {
            Debug.log(3, "Error: IO Exception" + e, new Object[0]);
        }
    }

    protected void protocolHandshake() throws IOException {
        String protocolVersion = this.in.readLine();
        VersionParser parser = new VersionParser(protocolVersion);
        ProtocolVersion parse = parser.parse();
        String replyCode = parse.getReplyCode();
        this.out.write(replyCode + "\n");
        this.out.flush();
        this.version = Character.getNumericValue(replyCode.charAt(10));
    }

    protected int securityInit(int desiredSecurityType) throws IOException {
        int selectedType = 0;
        byte[] securityTypes = new byte[10];
        if (this.version >= 7) {
            byte numSecurityTypes = this.dataIn.readByte();
            if (numSecurityTypes == 0) {
                Debug.log(3, "Error: Server reported an error, closing connection", new Object[0]);
                this.socket.close();
            }
            this.dataIn.read(securityTypes, 0, numSecurityTypes);
            boolean flag = false;
            for (int i = 0; i < securityTypes.length; ++i) {
                if (securityTypes[i] != desiredSecurityType) continue;
                flag = true;
                this.dataOut.write((byte)desiredSecurityType);
                this.dataOut.flush();
                break;
            }
            if (flag) {
                selectedType = desiredSecurityType;
                return selectedType;
            }
        } else {
            selectedType = this.dataIn.readInt();
            return selectedType;
        }
        Debug.log(3, "Error: Desired Security Type Not supported by Server, closing connection", new Object[0]);
        this.socket.close();
        return selectedType;
    }

    protected void securityMethod(int type) {
        switch (type) {
            case 0: {
                try {
                    Debug.log(3, "Error: Server reported an error, closing connection", new Object[0]);
                    this.socket.close();
                }
                catch (IOException e) {
                    Debug.log(3, "Error: IO Exception" + e, new Object[0]);
                }
                break;
            }
            case 1: {
                if (this.version != 8) break;
                this.securityResult();
                break;
            }
            case 2: {
                break;
            }
            default: {
                try {
                    Debug.log(3, "Error: Desired Security Type Not supported, closing connection", new Object[0]);
                    this.socket.close();
                    break;
                }
                catch (IOException e) {
                    Debug.log(3, "Error: IO Exception" + e, new Object[0]);
                }
            }
        }
    }

    protected void securityResult() {
        try {
            int securityResult = this.dataIn.readInt();
            if (securityResult == 1) {
                Debug.log(3, "Error: Server reported an error, closing connection", new Object[0]);
                this.socket.close();
            }
        }
        catch (IOException e) {
            Debug.log(3, "Error: IO Exception" + e, new Object[0]);
        }
    }

    protected void clientInit(int share) throws IOException, InterruptedException {
        this.dataOut.writeByte(share);
        this.dataOut.flush();
    }

    protected synchronized int[] listenServerInit() throws IOException, InterruptedException {
        int[] data = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        data[0] = this.dataIn.readUnsignedShort();
        data[1] = this.dataIn.readUnsignedShort();
        data[2] = this.dataIn.readUnsignedByte();
        data[3] = this.dataIn.readUnsignedByte();
        data[4] = this.dataIn.readUnsignedByte();
        this.bef = data[4];
        data[5] = this.dataIn.readUnsignedByte();
        data[6] = this.dataIn.readUnsignedShort();
        data[7] = this.dataIn.readUnsignedShort();
        data[8] = this.dataIn.readUnsignedShort();
        data[9] = this.dataIn.readUnsignedByte();
        data[10] = this.dataIn.readUnsignedByte();
        data[11] = this.dataIn.readUnsignedByte();
        this.dataIn.readUnsignedByte();
        this.dataIn.readUnsignedByte();
        this.dataIn.readUnsignedByte();
        return data;
    }

    protected synchronized String readDesktopName() throws IOException {
        int nameLength = this.dataIn.readInt();
        byte[] stringBytes = new byte[nameLength];
        this.dataIn.read(stringBytes);
        return new String(stringBytes, "UTF-8");
    }

    protected void setPixelFormat(int bpp, int Depth, int be, int tcf, int rm, int gm, int bm, int rs, int gs, int bs) throws IOException {
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(bpp);
        this.dataOut.writeByte(Depth);
        this.dataOut.writeByte(be);
        this.dataOut.writeByte(tcf);
        this.dataOut.writeShort(rm);
        this.dataOut.writeShort(gm);
        this.dataOut.writeShort(bm);
        this.dataOut.writeByte(rs);
        this.dataOut.writeByte(gs);
        this.dataOut.writeByte(bs);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.bef = be;
        this.dataOut.flush();
    }

    protected void setEncodings(short numberOfEncodings, int ... encoding) throws IOException {
        this.dataOut.writeByte(2);
        this.dataOut.writeByte(0);
        this.dataOut.writeShort(numberOfEncodings);
        for (int index : encoding) {
            this.dataOut.writeInt(index);
        }
        this.dataOut.flush();
    }

    protected void framebufferUpdateRequest(boolean flag, int incremental, short x, short y, short w, short h) throws IOException {
        if (flag) {
            Debug.log(3, "Error: SetPixelFormat Required.", new Object[0]);
            return;
        }
        this.dataOut.writeByte(3);
        this.dataOut.writeByte(incremental);
        this.dataOut.writeShort(x);
        this.dataOut.writeShort(y);
        this.dataOut.writeShort(w);
        this.dataOut.writeShort(h);
        this.dataOut.flush();
    }

    protected void keyDown(int key) throws IOException {
        this.dataOut.writeByte(4);
        this.dataOut.writeByte(1);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeInt(key);
        this.dataOut.flush();
        Debug.log(3, "Writing key down-" + Integer.toHexString(key), new Object[0]);
    }

    protected void keyUp(int key) throws IOException {
        this.dataOut.writeByte(4);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeInt(key);
        this.dataOut.flush();
        Debug.log(3, "Writing key up-" + Integer.toHexString(key), new Object[0]);
    }

    protected void mouseEvent(int bOne, int bTwo, int bThree, int bFour, int bFive, int bSix, int bSeven, int bEight, int x, int y) throws IOException {
        int[] buttons = new int[]{bOne, bTwo, bThree, bFour, bFive, bSix, bSeven, bEight};
        byte flag = 0;
        for (int i = 0; i < 8; ++i) {
            flag = (byte)(flag + (buttons[i] << i));
        }
        this.dataOut.writeByte(5);
        this.dataOut.writeByte(flag);
        this.dataOut.writeShort(x);
        this.dataOut.writeShort(y);
        this.dataOut.flush();
        Debug.log(3, "MouseEvent-" + Byte.toString(flag), new Object[0]);
    }

    protected void clientPasteText(String text) throws IOException {
        byte[] b = text.getBytes("ISO-8859-1");
        this.dataOut.writeByte(6);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeByte(0);
        this.dataOut.writeInt(b.length);
        for (int i = 0; i < b.length; ++i) {
            this.dataOut.writeByte(b[i]);
        }
        this.dataOut.flush();
    }

    protected synchronized int readByte() throws IOException {
        return this.dataIn.readUnsignedByte();
    }

    protected synchronized int readShort() throws IOException {
        return this.dataIn.readUnsignedShort();
    }

    protected synchronized int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    protected synchronized int[] readTC32Data(int length) throws IOException, InterruptedException {
        int[] input = new int[length];
        if (this.bef > 0) {
            for (int j = 0; j < length; j += 3) {
                this.dataIn.readUnsignedByte();
                input[j] = this.dataIn.readUnsignedByte();
                input[j + 1] = this.dataIn.readUnsignedByte();
                input[j + 2] = this.dataIn.readUnsignedByte();
            }
        } else {
            for (int j = 0; j < length; j += 3) {
                input[j + 2] = this.dataIn.readUnsignedByte();
                input[j + 1] = this.dataIn.readUnsignedByte();
                input[j] = this.dataIn.readUnsignedByte();
                this.dataIn.readUnsignedByte();
            }
        }
        return input;
    }

    protected void close() throws IOException {
        this.socket.close();
    }

    protected boolean available() throws IOException {
        return this.dataIn.available() > 0;
    }

    public String toString() {
        return "VNCClient: Socket: " + this.socket.toString();
    }
}

