/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Extension;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.RunTime;

public class ExtensionManager {
    private static ExtensionManager _instance = null;
    private ArrayList<Extension> extensions = new ArrayList();

    private ExtensionManager() {
        File dir = new File(Settings.getUserExtPath());
        for (File d : dir.listFiles()) {
            String v;
            if (!d.getAbsolutePath().endsWith(".jar")) continue;
            String p = d.getAbsolutePath();
            String n = d.getName();
            if ((n = n.substring(0, n.length() - 4)).contains("-")) {
                v = n.substring(n.lastIndexOf("-") + 1);
                n = n.substring(0, n.lastIndexOf("-"));
            } else {
                v = "0.0";
            }
            Extension e = new Extension(n, p, v);
            this.extensions.add(e);
        }
    }

    public static ExtensionManager getInstance() {
        if (_instance == null) {
            _instance = new ExtensionManager();
        }
        return _instance;
    }

    public boolean install(String name, String url, String version) {
        if (url.startsWith("---extensions---")) {
            url = RunTime.get().SikuliRepo + name + "-" + version + ".jar";
        }
        String extPath = Settings.getUserExtPath();
        String tmpdir = RunTime.get().fpBaseTempPath;
        try {
            File localFile = new File(FileManager.downloadURL(new URL(url), tmpdir));
            String extName = localFile.getName();
            File targetFile = new File(extPath, extName);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            if (!localFile.renameTo(targetFile)) {
                Debug.error("ExtensionManager: Failed to install " + localFile.getName() + " to " + targetFile.getAbsolutePath(), new Object[0]);
                return false;
            }
            this.addExtension(name, localFile.getAbsolutePath(), version);
        }
        catch (IOException e) {
            Debug.error("ExtensionManager: Failed to download " + url, new Object[0]);
            return false;
        }
        return true;
    }

    private void addExtension(String name, String path, String version) {
        Extension e = this.find(name, version);
        if (e == null) {
            this.extensions.add(new Extension(name, path, version));
        } else {
            e.path = path;
        }
    }

    public boolean isInstalled(String name) {
        return this.find(name) != null;
    }

    public String getLoadPath(String name) {
        Extension e = this.find(name);
        if (e != null) {
            Debug.log(2, "ExtensionManager: found: " + name + " ( " + e.version + " )", new Object[0]);
            return e.path;
        }
        if (!name.endsWith(".jar")) {
            Debug.error("ExtensionManager: not found: " + name, new Object[0]);
        }
        return null;
    }

    public boolean isOutOfDate(String name, String version) {
        String s2;
        Extension e = this.find(name);
        if (e == null) {
            return false;
        }
        String s1 = ExtensionManager.normalisedVersion(e.version);
        int cmp = s1.compareTo(s2 = ExtensionManager.normalisedVersion(version));
        return cmp < 0;
    }

    public String getVersion(String name) {
        Extension e = this.find(name);
        if (e != null) {
            return e.version;
        }
        return null;
    }

    private Extension find(String name) {
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.contains("-")) {
            String v = name.substring(name.lastIndexOf("-") + 1);
            return this.find(name.substring(0, name.lastIndexOf("-")), v);
        }
        String v = ExtensionManager.normalisedVersion("0.0");
        Extension ext = null;
        for (Extension e : this.extensions) {
            if (!e.name.equals(name) || v.compareTo(ExtensionManager.normalisedVersion(e.version)) > 0) continue;
            ext = e;
            v = ExtensionManager.normalisedVersion(e.version);
        }
        return ext;
    }

    private Extension find(String name, String version) {
        String v = ExtensionManager.normalisedVersion(version);
        for (Extension e : this.extensions) {
            if (!e.name.equals(name) || !ExtensionManager.normalisedVersion(e.version).equals(v)) continue;
            return e;
        }
        return null;
    }

    private static String normalisedVersion(String version) {
        return ExtensionManager.normalisedVersion(version, ".", 4);
    }

    private static String normalisedVersion(String version, String sep, int maxWidth) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(String.format("%" + maxWidth + 's', s));
        }
        return sb.toString();
    }
}

