/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.HotkeyManager;
import org.sikuli.script.RunTime;

public class MacHotkeyManager
extends HotkeyManager {
    static final int CARBON_MASK_CMD = 256;
    static final int CARBON_MASK_SHIFT = 512;
    static final int CARBON_MASK_OPT = 2048;
    static final int CARBON_MASK_CTRL = 4096;

    @Override
    public boolean _addHotkey(int keyCode, int modifiers, HotkeyListener listener) {
        int ckey = this.convertToCarbonKey(keyCode);
        int cmod = this.convertToCarbonModifiers(modifiers);
        boolean ret = this.installGlobalHotkey(keyCode, modifiers, ckey, cmod, listener);
        return ret;
    }

    @Override
    public boolean _removeHotkey(int keyCode, int modifiers) {
        int ckey = this.convertToCarbonKey(keyCode);
        int cmod = this.convertToCarbonModifiers(modifiers);
        return this.uninstallGlobalHotkey(ckey, cmod);
    }

    private native boolean installGlobalHotkey(int var1, int var2, int var3, int var4, HotkeyListener var5);

    private native boolean uninstallGlobalHotkey(int var1, int var2);

    @Override
    public native void cleanUp();

    private int convertToCarbonModifiers(int mod) {
        int cmod = 0;
        if ((mod & 1) != 0) {
            cmod |= 0x200;
        }
        if ((mod & 4) != 0) {
            cmod |= 0x100;
        }
        if ((mod & 8) != 0) {
            cmod |= 0x800;
        }
        if ((mod & 2) != 0) {
            cmod |= 0x1000;
        }
        return cmod;
    }

    private int convertToCarbonKey(int keycode) {
        switch (keycode) {
            case 8: {
                return 51;
            }
            case 9: {
                return 48;
            }
            case 12: {
                return 71;
            }
            case 10: {
                return 36;
            }
            case 16: {
                return 240;
            }
            case 17: {
                return 241;
            }
            case 157: {
                return 242;
            }
            case 19: {
                return 113;
            }
            case 27: {
                return 53;
            }
            case 32: {
                return 49;
            }
            case 91: {
                return 33;
            }
            case 92: {
                return 42;
            }
            case 93: {
                return 30;
            }
            case 47: {
                return 44;
            }
            case 46: {
                return 47;
            }
            case 44: {
                return 43;
            }
            case 59: {
                return 41;
            }
            case 35: {
                return 119;
            }
            case 36: {
                return 115;
            }
            case 37: {
                return 123;
            }
            case 38: {
                return 126;
            }
            case 39: {
                return 124;
            }
            case 40: {
                return 125;
            }
            case 154: {
                return 105;
            }
            case 155: {
                return 114;
            }
            case 127: {
                return 117;
            }
            case 156: {
                return 114;
            }
            case 48: {
                return 29;
            }
            case 49: {
                return 18;
            }
            case 50: {
                return 19;
            }
            case 51: {
                return 20;
            }
            case 52: {
                return 21;
            }
            case 53: {
                return 23;
            }
            case 54: {
                return 22;
            }
            case 55: {
                return 26;
            }
            case 56: {
                return 28;
            }
            case 57: {
                return 25;
            }
            case 45: {
                return 27;
            }
            case 61: {
                return 24;
            }
            case 65: {
                return 0;
            }
            case 66: {
                return 11;
            }
            case 67: {
                return 8;
            }
            case 68: {
                return 2;
            }
            case 69: {
                return 14;
            }
            case 70: {
                return 3;
            }
            case 71: {
                return 5;
            }
            case 72: {
                return 4;
            }
            case 73: {
                return 34;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 40;
            }
            case 76: {
                return 37;
            }
            case 77: {
                return 46;
            }
            case 78: {
                return 45;
            }
            case 79: {
                return 31;
            }
            case 80: {
                return 35;
            }
            case 81: {
                return 12;
            }
            case 82: {
                return 15;
            }
            case 83: {
                return 1;
            }
            case 84: {
                return 17;
            }
            case 85: {
                return 32;
            }
            case 86: {
                return 9;
            }
            case 87: {
                return 13;
            }
            case 88: {
                return 7;
            }
            case 89: {
                return 16;
            }
            case 90: {
                return 6;
            }
            case 96: {
                return 82;
            }
            case 97: {
                return 83;
            }
            case 98: {
                return 84;
            }
            case 99: {
                return 85;
            }
            case 100: {
                return 86;
            }
            case 101: {
                return 87;
            }
            case 102: {
                return 88;
            }
            case 103: {
                return 89;
            }
            case 104: {
                return 91;
            }
            case 105: {
                return 92;
            }
            case 106: {
                return 67;
            }
            case 107: {
                return 69;
            }
            case 108: {
                return 255;
            }
            case 109: {
                return 78;
            }
            case 110: {
                return 65;
            }
            case 111: {
                return 75;
            }
            case 112: {
                return 122;
            }
            case 113: {
                return 123;
            }
            case 114: {
                return 99;
            }
            case 115: {
                return 118;
            }
            case 116: {
                return 96;
            }
            case 117: {
                return 97;
            }
            case 118: {
                return 98;
            }
            case 119: {
                return 100;
            }
            case 120: {
                return 101;
            }
            case 121: {
                return 109;
            }
            case 122: {
                return 103;
            }
            case 123: {
                return 111;
            }
            case 61440: {
                return 105;
            }
            case 61441: {
                return 107;
            }
            case 61442: {
                return 113;
            }
            case 144: {
                return 71;
            }
        }
        return 255;
    }

    static {
        RunTime.loadLibrary("MacHotkeyManager");
    }
}

