/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Sikulix;

public class PreferencesUser {
    public static final int yes = 1;
    public static final int no = 0;
    public static final int AUTO_NAMING_TIMESTAMP = 0;
    public static final int AUTO_NAMING_OCR = 1;
    public static final int AUTO_NAMING_OFF = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int UNKNOWN = -1;
    public static final int NEWBEE = 0;
    public static final int SCRIPTER = 1;
    public static final int SIKULI_USER = 2;
    public static final int THUMB_HEIGHT = 50;
    public static final String DEFAULT_CONSOLE_CSS = "body   { font-family:serif; font-size: 12px; }.normal{ color: black; }.debug { color:#505000; }.info  { color: blue; }.log   { color: #09806A; }.error { color: red; }";
    static PreferencesUser _instance = null;
    Preferences pref = Preferences.userNodeForPackage(Sikulix.class);

    public static PreferencesUser getInstance() {
        if (_instance == null) {
            _instance = new PreferencesUser();
        }
        return _instance;
    }

    private PreferencesUser() {
        Debug.log(2, "init user preferences", new Object[0]);
    }

    public boolean exportPrefs(String path) {
        try {
            FileOutputStream pout = new FileOutputStream(new File(path));
            this.pref.exportSubtree(pout);
            pout.close();
        }
        catch (Exception ex) {
            Debug.error("UserPrefs: export: did not work\n" + ex.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public boolean importPrefs(String path) {
        try {
            Preferences.importPreferences(new FileInputStream(new File(path)));
        }
        catch (Exception ex) {
            Debug.error("UserPrefs: import: did not work\n" + ex.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public void remove(String key) {
        this.pref.remove(key);
    }

    public void removeAll(String prefix) {
        try {
            for (String item : this.pref.keys()) {
                if (!item.startsWith(prefix)) continue;
                this.pref.remove(item);
            }
        }
        catch (Exception ex) {
            Debug.error("Prefs.removeAll: prefix (%s) did not work", prefix);
        }
    }

    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        this.pref.addPreferenceChangeListener(pcl);
    }

    public void setUserType(int typ) {
        this.pref.putInt("USER_TYPE", typ);
    }

    public int getUserType() {
        return this.pref.getInt("USER_TYPE", -1);
    }

    public void setCaptureHotkey(int hkey) {
        this.pref.putInt("CAPTURE_HOTKEY", hkey);
    }

    public int getCaptureHotkey() {
        return this.pref.getInt("CAPTURE_HOTKEY", 50);
    }

    public void setCaptureHotkeyModifiers(int mod) {
        if (mod < 0) {
            // empty if block
        }
        this.pref.putInt("CAPTURE_HOTKEY_MODIFIERS", mod);
    }

    public int getCaptureHotkeyModifiers() {
        return this.pref.getInt("CAPTURE_HOTKEY_MODIFIERS", this.defaultCaptureHotkeyModifiers());
    }

    private int defaultCaptureHotkeyModifiers() {
        int mod = 5;
        if (!Settings.isMac()) {
            mod = 3;
        }
        return mod;
    }

    public void setCaptureDelay(double v) {
        this.pref.putDouble("CAPTURE_DELAY", v);
    }

    public double getCaptureDelay() {
        return this.pref.getDouble("CAPTURE_DELAY", 1.0);
    }

    public void setStopHotkey(int hkey) {
        this.pref.putInt("STOP_HOTKEY", hkey);
    }

    public int getStopHotkey() {
        return this.pref.getInt("STOP_HOTKEY", 67);
    }

    public void setStopHotkeyModifiers(int mod) {
        this.pref.putInt("STOP_HOTKEY_MODIFIERS", mod);
    }

    public int getStopHotkeyModifiers() {
        return this.pref.getInt("GET_HOTKEY_MODIFIERS", this.defaultStopHotkeyModifiers());
    }

    private int defaultStopHotkeyModifiers() {
        int mod = 5;
        if (!Settings.isMac()) {
            mod = 9;
        }
        return mod;
    }

    public void setExpandTab(boolean flag) {
        this.pref.putBoolean("EXPAND_TAB", flag);
    }

    public boolean getExpandTab() {
        return this.pref.getBoolean("EXPAND_TAB", true);
    }

    public void setTabWidth(int width) {
        this.pref.putInt("TAB_WIDTH", width);
    }

    public int getTabWidth() {
        return this.pref.getInt("TAB_WIDTH", 4);
    }

    public String getTabWhitespace() {
        if (this.getExpandTab()) {
            char[] blanks = new char[this.getTabWidth()];
            Arrays.fill(blanks, ' ');
            return new String(blanks);
        }
        return "\t";
    }

    public void setFontSize(int size) {
        this.pref.putInt("FONT_SIZE", size);
    }

    public int getFontSize() {
        return this.pref.getInt("FONT_SIZE", 18);
    }

    public void setFontName(String font) {
        this.pref.put("FONT_NAME", font);
    }

    public String getFontName() {
        return this.pref.get("FONT_NAME", "Monospaced");
    }

    public void setLocale(Locale l) {
        this.pref.put("LOCALE", l.toString());
    }

    public Locale getLocale() {
        String locale = this.pref.get("LOCALE", Locale.getDefault().toString());
        String[] code = locale.split("_");
        if (code.length == 1) {
            return new Locale(code[0]);
        }
        if (code.length == 2) {
            return new Locale(code[0], code[1]);
        }
        return new Locale(code[0], code[1], code[2]);
    }

    public void setAutoNamingMethod(int m) {
        this.pref.putInt("AUTO_NAMING", m);
    }

    public int getAutoNamingMethod() {
        return this.pref.getInt("AUTO_NAMING", 1);
    }

    public void setDefaultThumbHeight(int h) {
        this.pref.putInt("DEFAULT_THUMB_HEIGHT", h);
    }

    public void resetDefaultThumbHeight() {
        this.pref.putInt("DEFAULT_THUMB_HEIGHT", 50);
    }

    public int getDefaultThumbHeight() {
        return this.pref.getInt("DEFAULT_THUMB_HEIGHT", 50);
    }

    public void setPrefMoreCommandBar(boolean flag) {
        this.pref.putInt("PREF_MORE_COMMAND_BAR", flag ? 1 : 0);
    }

    public boolean getPrefMoreCommandBar() {
        return this.pref.getInt("PREF_MORE_COMMAND_BAR", 1) != 0;
    }

    public void setAutoCaptureForCmdButtons(boolean flag) {
        this.pref.putInt("AUTO_CAPTURE_FOR_CMD_BUTTONS", flag ? 1 : 0);
    }

    public boolean getAutoCaptureForCmdButtons() {
        return this.pref.getInt("AUTO_CAPTURE_FOR_CMD_BUTTONS", 1) != 0;
    }

    public void setAtSaveMakeHTML(boolean flag) {
        this.pref.putBoolean("AT_SAVE_MAKE_HTML", flag);
    }

    public boolean getAtSaveMakeHTML() {
        return this.pref.getBoolean("AT_SAVE_MAKE_HTML", false);
    }

    public void setAtSaveCleanBundle(boolean flag) {
        this.pref.putBoolean("AT_SAVE_CLEAN_BUNDLE", flag);
    }

    public boolean getAtSaveCleanBundle() {
        return this.pref.getBoolean("AT_SAVE_CLEAN_BUNDLE", true);
    }

    public void setPrefMoreRunSave(boolean flag) {
        this.pref.putBoolean("PREF_MORE_RUN_SAVE", flag);
    }

    public boolean getPrefMoreRunSave() {
        return this.pref.getBoolean("PREF_MORE_RUN_SAVE", false);
    }

    public void setPrefMoreHighlight(boolean flag) {
        this.pref.putBoolean("PREF_MORE_HIGHLIGHT", flag);
    }

    public boolean getPrefMoreHighlight() {
        return this.pref.getBoolean("PREF_MORE_HIGHLIGHT", false);
    }

    public void setCheckUpdate(boolean flag) {
        this.pref.putBoolean("CHECK_UPDATE", flag);
    }

    public boolean getCheckUpdate() {
        return this.pref.getBoolean("CHECK_UPDATE", true);
    }

    public void setWantBeta(boolean flag) {
        this.pref.putBoolean("WANT_BETA", flag);
    }

    public boolean getWantBeta() {
        return this.pref.getBoolean("WANT_BETA", false);
    }

    public void setLastSeenUpdate(String ver) {
        this.pref.put("LAST_SEEN_UPDATE", ver);
    }

    public String getLastSeenUpdate() {
        return this.pref.get("LAST_SEEN_UPDATE", "0.0");
    }

    public void setCheckUpdateTime() {
        this.pref.putLong("LAST_CHECK_UPDATE", new Date().getTime());
    }

    public long getCheckUpdateTime() {
        return this.pref.getLong("LAST_CHECK_UPDATE", new Date().getTime());
    }

    public void setIdeSize(Dimension size) {
        String str = (int)size.getWidth() + "x" + (int)size.getHeight();
        this.pref.put("IDE_SIZE", str);
    }

    public Dimension getIdeSize() {
        String str = this.pref.get("IDE_SIZE", "1024x700");
        String[] w_h = str.split("x");
        return new Dimension(Integer.parseInt(w_h[0]), Integer.parseInt(w_h[1]));
    }

    public void setIdeLocation(Point p) {
        String str = p.x + "," + p.y;
        this.pref.put("IDE_LOCATION", str);
    }

    public Point getIdeLocation() {
        String str = this.pref.get("IDE_LOCATION", "0,0");
        String[] x_y = str.split(",");
        return new Point(Integer.parseInt(x_y[0]), Integer.parseInt(x_y[1]));
    }

    public void setPrefMoreImageThumbs(boolean flag) {
        this.pref.putBoolean("PREF_MORE_IMAGE_THUMBS", flag);
    }

    public boolean getPrefMoreImageThumbs() {
        return this.pref.getBoolean("PREF_MORE_IMAGE_THUMBS", true);
    }

    public void setPrefMorePlainText(boolean flag) {
        this.pref.putBoolean("PREF_MORE_PLAIN_TEXT", flag);
    }

    public boolean getPrefMorePlainText() {
        return this.pref.getBoolean("PREF_MORE_PLAIN_TEXT", false);
    }

    public void setIdeSession(String session_str) {
        this.pref.put("IDE_SESSION", session_str);
    }

    public String getIdeSession() {
        return this.pref.get("IDE_SESSION", null);
    }

    public void setPrefMoreImages(boolean flag) {
        this.pref.putBoolean("PREF_MORE_IMAGES", flag);
    }

    public boolean getPrefMoreImages() {
        return this.pref.getBoolean("PREF_MORE_IMAGES", false);
    }

    public void setPrefMoreImagesPath(String path) {
        this.pref.put("PREF_MORE_IMAGES_PATH", path);
    }

    public String getPrefMoreImagesPath() {
        return this.pref.get("PREF_MORE_IMAGES_PATH", null);
    }

    public void setPrefMoreMessage(int typ) {
        this.pref.putInt("PREF_MORE_MESSAGE", typ);
    }

    public int getPrefMoreMessage() {
        return this.pref.getInt("PREF_MORE_MESSAGE", 0);
    }

    public void setPrefMoreLogActions(boolean flag) {
        this.pref.putBoolean("PREF_MORE_LOG_ACTIONS", flag);
    }

    public boolean getPrefMoreLogActions() {
        return this.pref.getBoolean("PREF_MORE_LOG_ACTIONS", true);
    }

    public void setPrefMoreLogInfo(boolean flag) {
        this.pref.putBoolean("PREF_MORE_LOG_INFO", flag);
    }

    public boolean getPrefMoreLogInfo() {
        return this.pref.getBoolean("PREF_MORE_LOG_INFO", true);
    }

    public void setPrefMoreLogDebug(boolean flag) {
        this.pref.putBoolean("PREF_MORE_LOG_INFO", flag);
    }

    public boolean getPrefMoreLogDebug() {
        return this.pref.getBoolean("PREF_MORE_LOG_DEBUG", true);
    }

    public void setConsoleCSS(String css) {
        this.pref.put("CONSOLE_CSS", css);
    }

    public String getConsoleCSS() {
        return this.pref.get("CONSOLE_CSS", DEFAULT_CONSOLE_CSS);
    }

    public void setPrefMoreTextSearch(boolean flag) {
        this.pref.putBoolean("PREF_MORE_TEXT_SEARCH", flag);
    }

    public boolean getPrefMoreTextSearch() {
        return this.pref.getBoolean("PREF_MORE_TEXT_SEARCH", false);
    }

    public void setPrefMoreTextOCR(boolean flag) {
        this.pref.putBoolean("PREF_MORE_TEXT_OCR", flag);
    }

    public boolean getPrefMoreTextOCR() {
        return this.pref.getBoolean("PREF_MORE_TEXT_OCR", false);
    }

    public void put(String key, String val) {
        this.pref.put(key, val);
    }

    public String get(String key, String default_) {
        return this.pref.get(key, default_);
    }

    public void setDefaults(int typ) {
        if (0 == typ) {
            this.setCaptureHotkey(50);
            this.setCaptureHotkeyModifiers(this.defaultCaptureHotkeyModifiers());
            this.setCaptureDelay(1.0);
        }
        this.setStopHotkey(67);
        this.setStopHotkeyModifiers(this.defaultStopHotkeyModifiers());
        if (0 == typ) {
            this.setExpandTab(true);
            this.setTabWidth(4);
        }
        if (0 == typ) {
            this.setFontSize(14);
            this.setFontName("Monospaced");
        }
        if (0 == typ) {
            this.setLocale(Locale.getDefault());
        }
        if (0 == typ) {
            this.setAutoNamingMethod(0);
        }
        if (this.getPrefMoreImageThumbs()) {
            this.setDefaultThumbHeight(50);
        } else {
            this.setDefaultThumbHeight(0);
        }
        if (0 == typ) {
            this.setPrefMoreCommandBar(true);
            this.setAutoCaptureForCmdButtons(true);
        } else {
            this.setPrefMoreCommandBar(false);
        }
        if (0 == typ) {
            this.setAtSaveMakeHTML(true);
        } else {
            this.setAtSaveMakeHTML(false);
        }
        this.setAtSaveCleanBundle(true);
        this.setPrefMoreRunSave(false);
        this.setPrefMoreHighlight(false);
        this.setCheckUpdate(false);
        this.setLastSeenUpdate("0.0.0");
        this.setCheckUpdateTime();
        if (0 == typ) {
            this.setIdeSize(new Dimension(0, 0));
            this.setIdeLocation(new Point(0, 0));
        }
        this.setPrefMoreImages(false);
        this.setPrefMoreImagesPath("");
        if (0 == typ) {
            this.setPrefMoreMessage(0);
        } else {
            this.setPrefMoreMessage(1);
        }
        this.setPrefMoreLogActions(true);
        this.setPrefMoreLogInfo(true);
        this.setPrefMoreLogDebug(true);
        this.setConsoleCSS(DEFAULT_CONSOLE_CSS);
        this.setPrefMoreTextSearch(false);
        this.setPrefMoreTextOCR(false);
    }
}

