/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import org.sikuli.guide.Visual;

public class SxText
extends Visual {
    JLabel label;
    boolean initDone = false;

    public SxText(String text) {
        this.init(text);
    }

    private void init(String text) {
        this.text = text;
        this.label = new JLabel();
        this.add(this.label);
        this.fontSize = 12;
        this.label.setFont(new Font("SansSerif", 0, 36));
        this.updateComponent();
        this.initDone = true;
    }

    @Override
    public void updateComponent() {
        String htmltxt = "<html><div style='" + this.getStyleString() + "'>" + this.text + "</div></html>";
        this.label.setText(htmltxt);
        Dimension size = this.label.getPreferredSize();
        if (size.width > this.maxWidth) {
            htmltxt = "<html><div style='width:" + this.maxWidth + ";" + this.getStyleString() + "'>" + this.text + "</div></html>";
            this.label.setText(htmltxt);
            size = this.label.getPreferredSize();
        }
        this.label.setSize(size);
        this.setActualSize(size);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension originalSize = this.label.getPreferredSize();
        Dimension actualSize = this.getActualSize();
        float scalex = 1.0f * (float)actualSize.width / (float)originalSize.width;
        float scaley = 1.0f * (float)actualSize.height / (float)originalSize.height;
        ((Graphics2D)g).scale(scalex, scaley);
        super.paintComponent(g);
    }
}

