/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.Image;
import org.sikuli.script.Pattern;

class FindFailedDialog
extends JDialog
implements ActionListener {
    JButton retryButton;
    JButton skipButton;
    JButton abortButton;
    FindFailedResponse _response;
    boolean isCapture = false;

    public FindFailedDialog(Object target) {
        this.init(target, false);
    }

    public FindFailedDialog(Object target, boolean isCapture) {
        this.init(target, isCapture);
    }

    private void init(Object target, boolean isCapture) {
        this.isCapture = isCapture;
        this.setModal(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        Component targetComp = this.createTargetComponent(target);
        panel.add(targetComp, "North");
        JPanel buttons = new JPanel();
        String textRetry = "Retry";
        if (isCapture) {
            textRetry = "Capture";
        }
        this.retryButton = new JButton(textRetry);
        this.retryButton.addActionListener(this);
        this.skipButton = new JButton("Skip");
        this.skipButton.addActionListener(this);
        this.abortButton = new JButton("Abort");
        this.abortButton.addActionListener(this);
        buttons.add(this.retryButton);
        buttons.add(this.skipButton);
        buttons.add(this.abortButton);
        panel.add((Component)buttons, "South");
        this.add(panel);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindFailedDialog.this._response = FindFailedResponse.ABORT;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.retryButton == e.getSource()) {
            this._response = FindFailedResponse.RETRY;
        } else if (this.abortButton == e.getSource()) {
            this._response = FindFailedResponse.ABORT;
        } else if (this.skipButton == e.getSource()) {
            this._response = FindFailedResponse.SKIP;
        }
        this.dispose();
    }

    public FindFailedResponse getResponse() {
        return this._response;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <PatternString> Component createTargetComponent(PatternString target22) {
        void target22;
        Image image = null;
        JLabel c = null;
        String targetTyp = "";
        if (this.isCapture) return new JLabel("Request to capture: " + (String)target22);
        if (target22 instanceof Pattern) {
            Pattern pat = (Pattern)target22;
            targetTyp = "pattern";
            String target22 = pat.toString();
            image = pat.getImage();
        } else {
            Object target22;
            if (!(target22 instanceof String)) return null;
            image = Image.get((String)target22);
            if (image == null) return new JLabel("Sikuli cannot find text:" + (String)target22);
            targetTyp = "image";
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JLabel iconLabel = new JLabel();
        String rescale = "";
        java.awt.Image bimage = null;
        if (image != null) {
            int w = image.get().getWidth(this);
            int h = image.get().getHeight(this);
            if (w > 500) {
                w = 500;
                h = -h;
                rescale = " (rescaled to 500x...)";
            }
            if (h > 300) {
                h = 300;
                w = -w;
                rescale = " (rescaled to ...x300)";
            }
            if (h < 0 && w < 0) {
                w = 500;
                h = 300;
                rescale = " (rescaled to 500x300)";
            }
            bimage = image.get().getScaledInstance(w, h, 1);
        }
        iconLabel.setIcon(new ImageIcon(bimage));
        c = new JLabel("Sikuli cannot find " + targetTyp + rescale + ".");
        p.add((Component)c, "First");
        p.add(new JLabel((String)target22));
        p.add((Component)iconLabel, "Last");
        return p;
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            this.pack();
            this.setAlwaysOnTop(true);
            this.setResizable(false);
            this.setLocationRelativeTo(this);
            this.requestFocus();
        }
        super.setVisible(flag);
    }
}

