/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.sikuli.basics.Debug;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.HotkeyManager;
import org.sikuli.basics.Settings;

public class Key {
    static String[] keyVK = new String[]{"VK_0", "48", "VK_1", "49", "VK_2", "50", "VK_3", "51", "VK_4", "52", "VK_5", "53", "VK_6", "54", "VK_7", "55", "VK_8", "56", "VK_9", "57", "VK_A", "65", "VK_ACCEPT", "30", "VK_ADD", "107", "VK_AGAIN", "65481", "VK_ALL_CANDIDATES", "256", "VK_ALPHANUMERIC", "240", "VK_ALT", "18", "VK_ALT_GRAPH", "65406", "VK_AMPERSAND", "150", "VK_ASTERISK", "151", "VK_AT", "512", "VK_B", "66", "VK_BACK_QUOTE", "192", "VK_BACK_SLASH", "92", "VK_BACK_SPACE", "8", "VK_BEGIN", "65368", "VK_BRACELEFT", "161", "VK_BRACERIGHT", "162", "VK_C", "67", "VK_CANCEL", "3", "VK_CAPS_LOCK", "20", "VK_CIRCUMFLEX", "514", "VK_CLEAR", "12", "VK_CLOSE_BRACKET", "93", "VK_CODE_INPUT", "258", "VK_COLON", "513", "VK_COMMA", "44", "VK_COMPOSE", "65312", "VK_CONTEXT_MENU", "525", "VK_CONTROL", "17", "VK_CONVERT", "28", "VK_COPY", "65485", "VK_CUT", "65489", "VK_D", "68", "VK_DEAD_ABOVEDOT", "134", "VK_DEAD_ABOVERING", "136", "VK_DEAD_ACUTE", "129", "VK_DEAD_BREVE", "133", "VK_DEAD_CARON", "138", "VK_DEAD_CEDILLA", "139", "VK_DEAD_CIRCUMFLEX", "130", "VK_DEAD_DIAERESIS", "135", "VK_DEAD_DOUBLEACUTE", "137", "VK_DEAD_GRAVE", "128", "VK_DEAD_IOTA", "141", "VK_DEAD_MACRON", "132", "VK_DEAD_OGONEK", "140", "VK_DEAD_SEMIVOICED_SOUND", "143", "VK_DEAD_TILDE", "131", "VK_DEAD_VOICED_SOUND", "142", "VK_DECIMAL", "110", "VK_DELETE", "127", "VK_DIVIDE", "111", "VK_DOLLAR", "515", "VK_DOWN", "40", "VK_E", "69", "VK_END", "35", "VK_ENTER", "10", "VK_EQUALS", "61", "VK_ESCAPE", "27", "VK_EURO_SIGN", "516", "VK_EXCLAMATION_MARK", "517", "VK_F", "70", "VK_F1", "112", "VK_F10", "121", "VK_F11", "122", "VK_F12", "123", "VK_F13", "61440", "VK_F14", "61441", "VK_F15", "61442", "VK_F16", "61443", "VK_F17", "61444", "VK_F18", "61445", "VK_F19", "61446", "VK_F2", "113", "VK_F20", "61447", "VK_F21", "61448", "VK_F22", "61449", "VK_F23", "61450", "VK_F24", "61451", "VK_F3", "114", "VK_F4", "115", "VK_F5", "116", "VK_F6", "117", "VK_F7", "118", "VK_F8", "119", "VK_F9", "120", "VK_FINAL", "24", "VK_FIND", "65488", "VK_FULL_WIDTH", "243", "VK_G", "71", "VK_GREATER", "160", "VK_H", "72", "VK_HALF_WIDTH", "244", "VK_HELP", "156", "VK_HIRAGANA", "242", "VK_HOME", "36", "VK_I", "73", "VK_INPUT_METHOD_ON_OFF", "263", "VK_INSERT", "155", "VK_INVERTED_EXCLAMATION_MARK", "518", "VK_J", "74", "VK_JAPANESE_HIRAGANA", "260", "VK_JAPANESE_KATAKANA", "259", "VK_JAPANESE_ROMAN", "261", "VK_K", "75", "VK_KANA", "21", "VK_KANA_LOCK", "262", "VK_KANJI", "25", "VK_KATAKANA", "241", "VK_KP_DOWN", "225", "VK_KP_LEFT", "226", "VK_KP_RIGHT", "227", "VK_KP_UP", "224", "VK_L", "76", "VK_LEFT", "37", "VK_LEFT_PARENTHESIS", "519", "VK_LESS", "153", "VK_M", "77", "VK_META", "157", "VK_MINUS", "45", "VK_MODECHANGE", "31", "VK_MULTIPLY", "106", "VK_N", "78", "VK_NONCONVERT", "29", "VK_NUM_LOCK", "144", "VK_NUMBER_SIGN", "520", "VK_NUMPAD0", "96", "VK_NUMPAD1", "97", "VK_NUMPAD2", "98", "VK_NUMPAD3", "99", "VK_NUMPAD4", "100", "VK_NUMPAD5", "101", "VK_NUMPAD6", "102", "VK_NUMPAD7", "103", "VK_NUMPAD8", "104", "VK_NUMPAD9", "105", "VK_O", "79", "VK_OPEN_BRACKET", "91", "VK_P", "80", "VK_PAGE_DOWN", "34", "VK_PAGE_UP", "33", "VK_PASTE", "65487", "VK_PAUSE", "19", "VK_PERIOD", "46", "VK_PLUS", "521", "VK_PREVIOUS_CANDIDATE", "257", "VK_PRINTSCREEN", "154", "VK_PROPS", "65482", "VK_Q", "81", "VK_QUOTE", "222", "VK_QUOTEDBL", "152", "VK_R", "82", "VK_RIGHT", "39", "VK_RIGHT_PARENTHESIS", "522", "VK_ROMAN_CHARACTERS", "245", "VK_S", "83", "VK_SCROLL_LOCK", "145", "VK_SEMICOLON", "59", "VK_SEPARATER", "108", "VK_SEPARATOR", "108", "VK_SHIFT", "16", "VK_SLASH", "47", "VK_SPACE", "32", "VK_STOP", "65480", "VK_SUBTRACT", "109", "VK_T", "84", "VK_TAB", "9", "VK_U", "85", "VK_UNDEFINED", "0", "VK_UNDERSCORE", "523", "VK_UNDO", "65483", "VK_UP", "38", "VK_V", "86", "VK_W", "87", "VK_WINDOWS", "524", "VK_X", "88", "VK_Y", "89", "VK_Z", "90"};
    public static String keyboardUS = "1234567890-=qwertyuiop[]asdfghjkl;'\\`zxcvbnm,./";
    public static final String SPACE = " ";
    public static final String ENTER = "\n";
    public static final String BACKSPACE = "\b";
    public static final String TAB = "\t";
    public static final String ESC = "\u001b";
    public static final char C_ESC = '\u001b';
    public static final String UP = "\ue000";
    public static final char C_UP = '\ue000';
    public static final String RIGHT = "\ue001";
    public static final char C_RIGHT = '\ue001';
    public static final String DOWN = "\ue002";
    public static final char C_DOWN = '\ue002';
    public static final String LEFT = "\ue003";
    public static final char C_LEFT = '\ue003';
    public static final String PAGE_UP = "\ue004";
    public static final char C_PAGE_UP = '\ue004';
    public static final String PAGE_DOWN = "\ue005";
    public static final char C_PAGE_DOWN = '\ue005';
    public static final String DELETE = "\ue006";
    public static final char C_DELETE = '\ue006';
    public static final String END = "\ue007";
    public static final char C_END = '\ue007';
    public static final String HOME = "\ue008";
    public static final char C_HOME = '\ue008';
    public static final String INSERT = "\ue009";
    public static final char C_INSERT = '\ue009';
    public static final String F1 = "\ue011";
    public static final char C_F1 = '\ue011';
    public static final String F2 = "\ue012";
    public static final char C_F2 = '\ue012';
    public static final String F3 = "\ue013";
    public static final char C_F3 = '\ue013';
    public static final String F4 = "\ue014";
    public static final char C_F4 = '\ue014';
    public static final String F5 = "\ue015";
    public static final char C_F5 = '\ue015';
    public static final String F6 = "\ue016";
    public static final char C_F6 = '\ue016';
    public static final String F7 = "\ue017";
    public static final char C_F7 = '\ue017';
    public static final String F8 = "\ue018";
    public static final char C_F8 = '\ue018';
    public static final String F9 = "\ue019";
    public static final char C_F9 = '\ue019';
    public static final String F10 = "\ue01a";
    public static final char C_F10 = '\ue01a';
    public static final String F11 = "\ue01b";
    public static final char C_F11 = '\ue01b';
    public static final String F12 = "\ue01c";
    public static final char C_F12 = '\ue01c';
    public static final String F13 = "\ue01d";
    public static final char C_F13 = '\ue01d';
    public static final String F14 = "\ue01e";
    public static final char C_F14 = '\ue01e';
    public static final String F15 = "\ue01f";
    public static final char C_F15 = '\ue01f';
    public static final String SHIFT = "\ue020";
    public static final char C_SHIFT = '\ue020';
    public static final String CTRL = "\ue021";
    public static final char C_CTRL = '\ue021';
    public static final String ALT = "\ue022";
    public static final char C_ALT = '\ue022';
    public static final String ALTGR = "\ue043";
    public static final char C_ALTGR = '\ue043';
    public static final String META = "\ue023";
    public static final char C_META = '\ue023';
    public static final String CMD = "\ue023";
    public static final char C_CMD = '\ue023';
    public static final String WIN = "\ue042";
    public static final char C_WIN = '\ue042';
    public static final String PRINTSCREEN = "\ue024";
    public static final char C_PRINTSCREEN = '\ue024';
    public static final String SCROLL_LOCK = "\ue025";
    public static final char C_SCROLL_LOCK = '\ue025';
    public static final String PAUSE = "\ue026";
    public static final char C_PAUSE = '\ue026';
    public static final String CAPS_LOCK = "\ue027";
    public static final char C_CAPS_LOCK = '\ue027';
    public static final String NUM0 = "\ue030";
    public static final char C_NUM0 = '\ue030';
    public static final String NUM1 = "\ue031";
    public static final char C_NUM1 = '\ue031';
    public static final String NUM2 = "\ue032";
    public static final char C_NUM2 = '\ue032';
    public static final String NUM3 = "\ue033";
    public static final char C_NUM3 = '\ue033';
    public static final String NUM4 = "\ue034";
    public static final char C_NUM4 = '\ue034';
    public static final String NUM5 = "\ue035";
    public static final char C_NUM5 = '\ue035';
    public static final String NUM6 = "\ue036";
    public static final char C_NUM6 = '\ue036';
    public static final String NUM7 = "\ue037";
    public static final char C_NUM7 = '\ue037';
    public static final String NUM8 = "\ue038";
    public static final char C_NUM8 = '\ue038';
    public static final String NUM9 = "\ue039";
    public static final char C_NUM9 = '\ue039';
    public static final String SEPARATOR = "\ue03a";
    public static final char C_SEPARATOR = '\ue03a';
    public static final String NUM_LOCK = "\ue03b";
    public static final char C_NUM_LOCK = '\ue03b';
    public static final String ADD = "\ue03c";
    public static final char C_ADD = '\ue03c';
    public static final String MINUS = "\ue03d";
    public static final char C_MINUS = '\ue03d';
    public static final String MULTIPLY = "\ue03e";
    public static final char C_MULTIPLY = '\ue03e';
    public static final String DIVIDE = "\ue03f";
    public static final char C_DIVIDE = '\ue03f';
    public static final String DECIMAL = "\ue040";
    public static final char C_DECIMAL = '\ue040';
    public static final String CONTEXT = "\ue041";
    public static final char C_CONTEXT = '\ue041';
    public static final String NEXT = "\ue043";
    public static final char C_NEXT = '\ue043';
    public static final char cMax = '\ue050';
    public static final char cMin = '\ue000';
    public static int keyMaxLength;
    private static Map<String, Integer> keyTexts;
    private static Map<Integer, String> keys;
    static String[] result;

    public static boolean addHotkey(String key, int modifiers, HotkeyListener listener) {
        return HotkeyManager.getInstance().addHotkey(key, modifiers, listener);
    }

    public static boolean addHotkey(char key, int modifiers, HotkeyListener listener) {
        return HotkeyManager.getInstance().addHotkey(key, modifiers, listener);
    }

    public static boolean removeHotkey(String key, int modifiers) {
        return HotkeyManager.getInstance().removeHotkey(key, modifiers);
    }

    public static boolean removeHotkey(char key, int modifiers) {
        return HotkeyManager.getInstance().removeHotkey(key, modifiers);
    }

    public static String getTextFromKeycode(int key) {
        return keys.get(key);
    }

    public static boolean isRepeatable(String token) {
        int key = Key.toJavaKeyCodeFromText(token);
        switch (key) {
            case 38: {
                return true;
            }
            case 40: {
                return true;
            }
            case 39: {
                return true;
            }
            case 37: {
                return true;
            }
            case -9: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isModifier(String token) {
        return Key.toJavaKeyCodeFromText(token) == Key.toJavaKeyCodeFromText("#S.") || Key.toJavaKeyCodeFromText(token) == Key.toJavaKeyCodeFromText("#C.") || Key.toJavaKeyCodeFromText(token) == Key.toJavaKeyCodeFromText("#A.") || Key.toJavaKeyCodeFromText(token) == Key.toJavaKeyCodeFromText("#M.");
    }

    public static int toJavaKeyCodeFromText(String key) {
        if (null == keyTexts.get(key)) {
            return -1;
        }
        return keyTexts.get(key);
    }

    public static void dump() {
        HashMap<Integer, String> namesVK = new HashMap<Integer, String>();
        for (int i = 0; i < keyVK.length; i += 2) {
            namesVK.put(Integer.decode(keyVK[i + 1]), keyVK[i].substring(3));
        }
        TreeMap<String, Integer> sortedNames = new TreeMap<String, Integer>(keyTexts);
        System.out.println("[info] Key: dump keynames (tokens) used with Region write");
        System.out.println("[info] Token to use --- KeyEvent::keycode --- KeyEvent::keyname");
        for (String key : sortedNames.keySet()) {
            int keyN = (Integer)sortedNames.get(key);
            if (keyN < 1) continue;
            System.out.println(String.format("%s = %d (%s)", key, keyN, namesVK.get(keyN)));
        }
    }

    public static int[] toJavaKeyCode(String key) {
        if (key.length() > 0) {
            return Key.toJavaKeyCode(key.charAt(0));
        }
        return null;
    }

    public static int[] toJavaKeyCode(char key) {
        switch (key) {
            case 'a': {
                return new int[]{65};
            }
            case 'b': {
                return new int[]{66};
            }
            case 'c': {
                return new int[]{67};
            }
            case 'd': {
                return new int[]{68};
            }
            case 'e': {
                return new int[]{69};
            }
            case 'f': {
                return new int[]{70};
            }
            case 'g': {
                return new int[]{71};
            }
            case 'h': {
                return new int[]{72};
            }
            case 'i': {
                return new int[]{73};
            }
            case 'j': {
                return new int[]{74};
            }
            case 'k': {
                return new int[]{75};
            }
            case 'l': {
                return new int[]{76};
            }
            case 'm': {
                return new int[]{77};
            }
            case 'n': {
                return new int[]{78};
            }
            case 'o': {
                return new int[]{79};
            }
            case 'p': {
                return new int[]{80};
            }
            case 'q': {
                return new int[]{81};
            }
            case 'r': {
                return new int[]{82};
            }
            case 's': {
                return new int[]{83};
            }
            case 't': {
                return new int[]{84};
            }
            case 'u': {
                return new int[]{85};
            }
            case 'v': {
                return new int[]{86};
            }
            case 'w': {
                return new int[]{87};
            }
            case 'x': {
                return new int[]{88};
            }
            case 'y': {
                return new int[]{89};
            }
            case 'z': {
                return new int[]{90};
            }
            case 'A': {
                return new int[]{16, 65};
            }
            case 'B': {
                return new int[]{16, 66};
            }
            case 'C': {
                return new int[]{16, 67};
            }
            case 'D': {
                return new int[]{16, 68};
            }
            case 'E': {
                return new int[]{16, 69};
            }
            case 'F': {
                return new int[]{16, 70};
            }
            case 'G': {
                return new int[]{16, 71};
            }
            case 'H': {
                return new int[]{16, 72};
            }
            case 'I': {
                return new int[]{16, 73};
            }
            case 'J': {
                return new int[]{16, 74};
            }
            case 'K': {
                return new int[]{16, 75};
            }
            case 'L': {
                return new int[]{16, 76};
            }
            case 'M': {
                return new int[]{16, 77};
            }
            case 'N': {
                return new int[]{16, 78};
            }
            case 'O': {
                return new int[]{16, 79};
            }
            case 'P': {
                return new int[]{16, 80};
            }
            case 'Q': {
                return new int[]{16, 81};
            }
            case 'R': {
                return new int[]{16, 82};
            }
            case 'S': {
                return new int[]{16, 83};
            }
            case 'T': {
                return new int[]{16, 84};
            }
            case 'U': {
                return new int[]{16, 85};
            }
            case 'V': {
                return new int[]{16, 86};
            }
            case 'W': {
                return new int[]{16, 87};
            }
            case 'X': {
                return new int[]{16, 88};
            }
            case 'Y': {
                return new int[]{16, 89};
            }
            case 'Z': {
                return new int[]{16, 90};
            }
            case '1': {
                return new int[]{49};
            }
            case '!': {
                return new int[]{16, 49};
            }
            case '2': {
                return new int[]{50};
            }
            case '@': {
                return new int[]{16, 50};
            }
            case '3': {
                return new int[]{51};
            }
            case '#': {
                return new int[]{16, 51};
            }
            case '4': {
                return new int[]{52};
            }
            case '$': {
                return new int[]{16, 52};
            }
            case '5': {
                return new int[]{53};
            }
            case '%': {
                return new int[]{16, 53};
            }
            case '6': {
                return new int[]{54};
            }
            case '^': {
                return new int[]{16, 54};
            }
            case '7': {
                return new int[]{55};
            }
            case '&': {
                return new int[]{16, 55};
            }
            case '8': {
                return new int[]{56};
            }
            case '*': {
                return new int[]{16, 56};
            }
            case '9': {
                return new int[]{57};
            }
            case '(': {
                return new int[]{16, 57};
            }
            case '0': {
                return new int[]{48};
            }
            case ')': {
                return new int[]{16, 48};
            }
            case '-': {
                return new int[]{45};
            }
            case '_': {
                return new int[]{16, 45};
            }
            case '=': {
                return new int[]{61};
            }
            case '+': {
                return new int[]{16, 61};
            }
            case '[': {
                return new int[]{91};
            }
            case '{': {
                return new int[]{16, 91};
            }
            case ']': {
                return new int[]{93};
            }
            case '}': {
                return new int[]{16, 93};
            }
            case ';': {
                return new int[]{59};
            }
            case ':': {
                return new int[]{16, 59};
            }
            case '\'': {
                return new int[]{222};
            }
            case '\"': {
                return new int[]{16, 222};
            }
            case '\\': {
                return new int[]{92};
            }
            case '|': {
                return new int[]{16, 92};
            }
            case '\b': {
                return new int[]{8};
            }
            case '\t': {
                return new int[]{9};
            }
            case '\r': {
                return new int[]{10};
            }
            case '\n': {
                return new int[]{10};
            }
            case ' ': {
                return new int[]{32};
            }
            case '`': {
                return new int[]{192};
            }
            case '~': {
                return new int[]{16, 192};
            }
            case ',': {
                return new int[]{44};
            }
            case '<': {
                return new int[]{16, 44};
            }
            case '.': {
                return new int[]{46};
            }
            case '>': {
                return new int[]{16, 46};
            }
            case '/': {
                return new int[]{47};
            }
            case '?': {
                return new int[]{16, 47};
            }
            case '\ue020': {
                return new int[]{16};
            }
            case '\ue021': {
                return new int[]{17};
            }
            case '\ue022': {
                return new int[]{18};
            }
            case '\ue023': {
                return new int[]{157};
            }
            case '\ue000': {
                return new int[]{38};
            }
            case '\ue001': {
                return new int[]{39};
            }
            case '\ue002': {
                return new int[]{40};
            }
            case '\ue003': {
                return new int[]{37};
            }
            case '\ue004': {
                return new int[]{33};
            }
            case '\ue005': {
                return new int[]{34};
            }
            case '\ue007': {
                return new int[]{35};
            }
            case '\ue008': {
                return new int[]{36};
            }
            case '\ue006': {
                return new int[]{127};
            }
            case '\u001b': {
                return new int[]{27};
            }
            case '\ue011': {
                return new int[]{112};
            }
            case '\ue012': {
                return new int[]{113};
            }
            case '\ue013': {
                return new int[]{114};
            }
            case '\ue014': {
                return new int[]{115};
            }
            case '\ue015': {
                return new int[]{116};
            }
            case '\ue016': {
                return new int[]{117};
            }
            case '\ue017': {
                return new int[]{118};
            }
            case '\ue018': {
                return new int[]{119};
            }
            case '\ue019': {
                return new int[]{120};
            }
            case '\ue01a': {
                return new int[]{121};
            }
            case '\ue01b': {
                return new int[]{122};
            }
            case '\ue01c': {
                return new int[]{123};
            }
            case '\ue01d': {
                return new int[]{61440};
            }
            case '\ue01e': {
                return new int[]{61441};
            }
            case '\ue01f': {
                return new int[]{61442};
            }
            case '\ue025': {
                return new int[]{145};
            }
            case '\ue03b': {
                return new int[]{144};
            }
            case '\ue027': {
                return new int[]{20};
            }
            case '\ue009': {
                return new int[]{155};
            }
            case '\ue026': {
                return new int[]{19};
            }
            case '\ue024': {
                return new int[]{154};
            }
            case '\ue030': {
                return new int[]{96};
            }
            case '\ue031': {
                return new int[]{97};
            }
            case '\ue032': {
                return new int[]{98};
            }
            case '\ue033': {
                return new int[]{99};
            }
            case '\ue034': {
                return new int[]{100};
            }
            case '\ue035': {
                return new int[]{101};
            }
            case '\ue036': {
                return new int[]{102};
            }
            case '\ue037': {
                return new int[]{103};
            }
            case '\ue038': {
                return new int[]{104};
            }
            case '\ue039': {
                return new int[]{105};
            }
            case '\ue03a': {
                return new int[]{108};
            }
            case '\ue03c': {
                return new int[]{107};
            }
            case '\ue03d': {
                return new int[]{109};
            }
            case '\ue03e': {
                return new int[]{106};
            }
            case '\ue03f': {
                return new int[]{111};
            }
            case '\ue040': {
                return new int[]{110};
            }
            case '\ue041': {
                return new int[]{525};
            }
            case '\ue042': {
                return new int[]{524};
            }
            case '\ue043': {
                return new int[]{-9};
            }
        }
        throw new IllegalArgumentException("Cannot convert character " + key);
    }

    public static String toJavaKeyCodeText(char key) {
        switch (key) {
            case '\b': {
                return "#BACK.";
            }
            case '\t': {
                return "#TAB.";
            }
            case '\ue043': {
                return "#TAB.";
            }
            case '\r': {
                return "#ENTER.";
            }
            case '\n': {
                return "#ENTER.";
            }
            case '\ue000': {
                return "#UP.";
            }
            case '\ue001': {
                return "#RIGHT.";
            }
            case '\ue002': {
                return "#DOWN.";
            }
            case '\ue003': {
                return "#LEFT.";
            }
            case '\ue004': {
                return "#PUP.";
            }
            case '\ue005': {
                return "#PDOWN.";
            }
            case '\ue007': {
                return "#END.";
            }
            case '\ue008': {
                return "#HOME.";
            }
            case '\ue006': {
                return "#DEL.";
            }
            case '\u001b': {
                return "#ESC.";
            }
            case '\ue011': {
                return "#F1.";
            }
            case '\ue012': {
                return "#F2.";
            }
            case '\ue013': {
                return "#F3.";
            }
            case '\ue014': {
                return "#F4.";
            }
            case '\ue015': {
                return "#F5.";
            }
            case '\ue016': {
                return "#F6.";
            }
            case '\ue017': {
                return "#F7.";
            }
            case '\ue018': {
                return "#F8.";
            }
            case '\ue019': {
                return "#F9.";
            }
            case '\ue01a': {
                return "#F10.";
            }
            case '\ue01b': {
                return "#F11.";
            }
            case '\ue01c': {
                return "#F12.";
            }
            case '\ue01d': {
                return "#F13.";
            }
            case '\ue01e': {
                return "#F14.";
            }
            case '\ue01f': {
                return "#F15.";
            }
            case '\ue025': {
                return "#SCROLL_LOCK.";
            }
            case '\ue03b': {
                return "#NUM_LOCK.";
            }
            case '\ue027': {
                return "#CAPS_LOCK.";
            }
            case '\ue009': {
                return "#INS.";
            }
            case '\ue026': {
                return "#PAUSE.";
            }
            case '\ue024': {
                return "#PRINTSCREEN.";
            }
            case '\ue042': {
                return "#WIN.";
            }
            case '\ue030': {
                return "#NUM0.";
            }
            case '\ue031': {
                return "#NUM1.";
            }
            case '\ue032': {
                return "#NUM2.";
            }
            case '\ue033': {
                return "#NUM3.";
            }
            case '\ue034': {
                return "#NUM4.";
            }
            case '\ue035': {
                return "#NUM5.";
            }
            case '\ue036': {
                return "#NUM6.";
            }
            case '\ue037': {
                return "#NUM7.";
            }
            case '\ue038': {
                return "#NUM8.";
            }
            case '\ue039': {
                return "#NUM9.";
            }
            case '\ue03a': {
                return "#NSEP.";
            }
            case '\ue03c': {
                return "#NADD.";
            }
            case '\ue03d': {
                return "#NSUB.";
            }
            case '\ue03e': {
                return "#NMUL";
            }
            case '\ue03f': {
                return "#NDIV.";
            }
            case '\ue040': {
                return "#NDEC.";
            }
            case '\ue041': {
                return "#NCON.";
            }
            case '\ue020': {
                return "#SHIFT.";
            }
            case '\ue021': {
                return "#CTRL.";
            }
            case '\ue022': {
                return "#ALT.";
            }
            case '\ue023': {
                return "#META.";
            }
        }
        return "" + key;
    }

    protected static int convertModifiers(String mod) {
        int modNew = 0;
        for (int i = 0; i < mod.length(); ++i) {
            char key = mod.charAt(i);
            if ('\ue021' == key) {
                modNew |= 2;
                continue;
            }
            if ('\ue022' == key) {
                modNew |= 8;
                continue;
            }
            if ('\ue020' == key) {
                modNew |= 1;
                continue;
            }
            if ('\ue023' == key) {
                modNew |= 4;
                continue;
            }
            if ('\ue023' == key) {
                modNew |= 4;
                continue;
            }
            if ('\ue043' == key) {
                modNew |= 0x20;
                continue;
            }
            if ('\ue042' != key) continue;
            modNew |= 0x40;
        }
        return modNew;
    }

    public static boolean isLockOn(char key) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        switch (key) {
            case '\ue025': {
                return tk.getLockingKeyState(145);
            }
            case '\ue027': {
                return tk.getLockingKeyState(20);
            }
            case '\ue03b': {
                return tk.getLockingKeyState(144);
            }
        }
        return false;
    }

    public static int getHotkeyModifier() {
        if (Settings.isMac()) {
            return 157;
        }
        return 17;
    }

    public static String convertKeyToText(int code, int mod) {
        String txtMod = KeyEvent.getKeyModifiersText(mod);
        String txtCode = KeyEvent.getKeyText(code);
        String ret = code == 18 || code == 17 || code == 16 ? txtMod : txtMod + SPACE + txtCode;
        return ret;
    }

    public static void createKeyTable() {
        HashMap<String, String> namesVK = new HashMap<String, String>();
        for (int i = 0; i < keyVK.length; i += 2) {
            namesVK.put(keyVK[i + 1], keyVK[i].substring(3));
        }
        int upper = 66000;
        String form = "%05d: %-25s %-20s %-15s %15s %s";
        for (int key = 0; key < upper; ++key) {
            char ckey = (char)key;
            String k1 = "...";
            String k2 = "...";
            try {
                if (Key.toJavaKeyCode(ckey).length > 1) {
                    k1 = (String)namesVK.get(new Integer(Key.toJavaKeyCode(ckey)[0]).toString());
                    k2 = (String)namesVK.get(new Integer(Key.toJavaKeyCode(ckey)[1]).toString());
                } else if (key > 32) {
                    k2 = (String)namesVK.get(new Integer(Key.toJavaKeyCode(ckey)[0]).toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String keyText = KeyEvent.getKeyText(key);
            if (keyText.startsWith("Unknown") && ("...".equals(k2) || key > 255)) continue;
            if (keyText.startsWith("Unknown")) {
                keyText = "???";
            }
            if (keyText.length() == 1) {
                if (key >= 256) continue;
                if (key < 32) {
                    key = 32;
                }
                Debug.log(3, form, key, keyText, "...", "...", k2, k1);
                continue;
            }
            keyText = keyText.replaceAll(SPACE, "_");
            String vkey = (String)namesVK.get(new Integer(key).toString());
            if (vkey == null || vkey.equals(keyText.toUpperCase())) {
                vkey = "...";
            }
            if (null == Key.getTextFromKeycode(key)) {
                Debug.log(3, form, key, keyText.toUpperCase(), vkey, "...", k2, k1);
                continue;
            }
            Debug.log(3, form, key, keyText.toUpperCase(), vkey, Key.getTextFromKeycode(key), k2, k1);
        }
    }

    static {
        keyTexts = new HashMap<String, Integer>();
        keys = new HashMap<Integer, String>();
        keyMaxLength = 0;
        for (char c = '\ue000'; c < '\ue050'; c = (char)(c + '\u0001')) {
            String sKey = Key.toJavaKeyCodeText(c);
            if (sKey.equals("" + c)) continue;
            keyTexts.put(sKey, Key.toJavaKeyCode(c)[0]);
            keyMaxLength = sKey.length() > keyMaxLength ? sKey.length() : keyMaxLength;
        }
        keyTexts.put("#ENTER.", Key.toJavaKeyCode('\n')[0]);
        keyTexts.put("#N.", Key.toJavaKeyCode('\n')[0]);
        keyTexts.put("#BACK.", Key.toJavaKeyCode('\b')[0]);
        keyTexts.put("#B.", Key.toJavaKeyCode('\b')[0]);
        keyTexts.put("#TAB.", Key.toJavaKeyCode('\t')[0]);
        keyTexts.put("#T.", Key.toJavaKeyCode('\t')[0]);
        keyTexts.put("#X.", Key.toJavaKeyCode('\ue043')[0]);
        keyTexts.put("#ESC.", Key.toJavaKeyCode('\u001b')[0]);
        keyTexts.put("#U.", Key.toJavaKeyCode('\ue000')[0]);
        keyTexts.put("#D.", Key.toJavaKeyCode('\ue002')[0]);
        keyTexts.put("#L.", Key.toJavaKeyCode('\ue003')[0]);
        keyTexts.put("#R.", Key.toJavaKeyCode('\ue001')[0]);
        keyTexts.put("#S.", Key.toJavaKeyCode('\ue020')[0]);
        keyTexts.put("#S+", Key.toJavaKeyCode('\ue020')[0]);
        keyTexts.put("#S-", Key.toJavaKeyCode('\ue020')[0]);
        keyTexts.put("#A.", Key.toJavaKeyCode('\ue022')[0]);
        keyTexts.put("#A+", Key.toJavaKeyCode('\ue022')[0]);
        keyTexts.put("#A-", Key.toJavaKeyCode('\ue022')[0]);
        keyTexts.put("#C.", Key.toJavaKeyCode('\ue021')[0]);
        keyTexts.put("#C+", Key.toJavaKeyCode('\ue021')[0]);
        keyTexts.put("#C-", Key.toJavaKeyCode('\ue021')[0]);
        keyTexts.put("#M.", Key.toJavaKeyCode('\ue023')[0]);
        keyTexts.put("#M+", Key.toJavaKeyCode('\ue023')[0]);
        keyTexts.put("#M-", Key.toJavaKeyCode('\ue023')[0]);
        for (String k : keyTexts.keySet()) {
            if (Debug.getDebugLevel() > 3) {
                Debug.log(4, "Key: %s is: %s", new Object[]{k, KeyEvent.getKeyText(keyTexts.get(k))});
            }
            if (k.length() < 4) continue;
            keys.put(keyTexts.get(k), k);
        }
        result = new String[]{""};
    }
}

