/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.event.KeyEvent;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Device;
import org.sikuli.script.IRobot;
import org.sikuli.script.Location;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.ObserverCallBack;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;

public class Mouse {
    private static String me = "Mouse: ";
    private static final int lvl = 3;
    private static Mouse mouse = null;
    private Device device = null;
    protected Location mousePos;
    protected boolean clickDouble;
    protected int buttons;
    protected int beforeWait;
    protected int innerWait;
    protected int afterWait;
    public static final int LEFT = 16;
    public static final int MIDDLE = 8;
    public static final int RIGHT = 4;
    public static final int WHEEL_UP = -1;
    public static int WHEEL_DOWN = 1;
    public static final int WHEEL_STEP_DELAY = 50;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private Mouse() {
    }

    public static void init() {
        if (mouse == null) {
            mouse = new Mouse();
            Mouse.mouse.device = new Device(mouse);
            Mouse.mouse.device.isMouse = true;
            Mouse.move(Mouse.at());
            Mouse.mouse.device.lastPos = null;
            Mouse.log(3, "init", new Object[0]);
        }
    }

    private static Mouse get() {
        if (mouse == null) {
            Mouse.init();
        }
        return mouse;
    }

    protected static boolean use() {
        return Mouse.get().device.use(null);
    }

    protected static boolean use(Object owner) {
        return Mouse.get().device.use(owner);
    }

    protected static boolean keep(Object owner) {
        return Mouse.get().device.keep(owner);
    }

    protected static boolean let() {
        return Mouse.get().device.let(null);
    }

    protected static boolean let(Object owner) {
        Mouse.get();
        return Mouse.get().device.let(owner);
    }

    public static Location at() {
        return Mouse.get().device.getLocation();
    }

    public static void reset() {
        if (mouse == null) {
            return;
        }
        Mouse.get().device.unblock(Mouse.get().device.owner);
        Mouse.mouse.get().device.let(Mouse.get().device.owner);
        Mouse.get().device.let(Mouse.get().device.owner);
        Mouse.up();
        Mouse.get().device.mouseMovedResponse = Mouse.get().device.MouseMovedIgnore;
        Mouse.get().device.mouseMovedCallback = null;
        Mouse.get().device.callback = null;
        Mouse.get().device.lastPos = null;
    }

    public static int getMouseMovedResponse() {
        return Mouse.get().device.mouseMovedResponse;
    }

    public static void setMouseMovedAction(int movedAction) {
        if (movedAction > -1 && movedAction < 3) {
            Mouse.get().device.mouseMovedResponse = movedAction;
            Mouse.get().device.mouseMovedCallback = null;
            Mouse.log(3, "setMouseMovedAction: %d", Mouse.get().device.mouseMovedResponse);
        }
    }

    public static void setMouseMovedCallback(Object callBack) {
        if (callBack != null) {
            Mouse.get().device.mouseMovedResponse = 3;
            Mouse.get().device.mouseMovedCallback = new ObserverCallBack(callBack, ObserveEvent.Type.GENERIC);
        }
    }

    public static void setMouseMovedHighlight(boolean state) {
        Mouse.get().device.MouseMovedHighlight = state;
    }

    public static boolean hasMoved() {
        Location pos = Mouse.get().device.getLocation();
        return Mouse.get().device.lastPos.x != pos.x || Mouse.get().device.lastPos.y != pos.y;
    }

    public static Location click(Location loc, String action, Integer ... args) {
        if (Mouse.get().device.isSuspended() || loc.isOtherScreen()) {
            return null;
        }
        Mouse.getArgsClick(loc, action, args);
        Mouse.get().device.use();
        Device.delay(Mouse.mouse.beforeWait);
        Settings.ClickDelay = Mouse.mouse.innerWait / 1000;
        Mouse.click(loc, Mouse.mouse.buttons, (Integer)0, Mouse.get().clickDouble, null);
        Device.delay(Mouse.mouse.afterWait);
        Mouse.get().device.let();
        return loc;
    }

    private static void getArgsClick(Location loc, String action, Integer ... args) {
        Mouse.mouse.mousePos = loc;
        Mouse.mouse.clickDouble = false;
        if ((action = action.toUpperCase()).contains("D")) {
            Mouse.mouse.clickDouble = true;
        }
        Mouse.mouse.buttons = 0;
        if (action.contains("L")) {
            Mouse.mouse.buttons += 16;
        }
        if (action.contains("M")) {
            Mouse.mouse.buttons += 8;
        }
        if (action.contains("R")) {
            Mouse.mouse.buttons += 4;
        }
        if (Mouse.mouse.buttons == 0) {
            Mouse.mouse.buttons = 16;
        }
        Mouse.mouse.beforeWait = 0;
        Mouse.mouse.innerWait = 0;
        Mouse.mouse.afterWait = 0;
        if (args.length > 0) {
            if (args.length == 1) {
                if (args[0] < 0) {
                    Mouse.mouse.beforeWait = -args[0].intValue();
                } else {
                    Mouse.mouse.afterWait = args[0];
                }
            }
            Mouse.mouse.beforeWait = args[0];
            if (args.length > 1) {
                Mouse.mouse.afterWait = args[1];
                if (args.length > 2) {
                    Mouse.mouse.innerWait = args[2];
                }
            }
        }
    }

    protected static int click(Location loc, int buttons, Integer modifiers, boolean dblClick, Region region) {
        if (modifiers == null) {
            modifiers = 0;
        }
        Debug profiler = Debug.startTimer("Mouse.click", new Object[0]);
        boolean shouldMove = true;
        if (loc == null) {
            shouldMove = false;
            loc = Mouse.at();
        }
        IRobot r = null;
        r = Screen.getMouseRobot();
        if (r == null) {
            profiler.end();
            return 0;
        }
        Mouse.get().device.use(region);
        profiler.lap("after use");
        Debug.action(Mouse.getClickMsg(loc, buttons, modifiers, dblClick), new Object[0]);
        if (shouldMove) {
            r.smoothMove(loc);
            profiler.lap("after move");
        }
        r.clickStarts();
        r.pressModifiers(modifiers);
        int pause = Settings.ClickDelay > 1.0 ? 1 : (int)(Settings.ClickDelay * 1000.0);
        Settings.ClickDelay = 0.0;
        if (dblClick) {
            r.mouseDown(buttons);
            r.mouseUp(buttons);
            r.mouseDown(buttons);
            r.mouseUp(buttons);
        } else {
            r.mouseDown(buttons);
            r.delay(pause);
            r.mouseUp(buttons);
        }
        r.releaseModifiers(modifiers);
        r.clickEnds();
        r.waitForIdle();
        profiler.lap("before let");
        Mouse.get().device.let(region);
        profiler.end();
        return 1;
    }

    private static String getClickMsg(Location loc, int buttons, int modifiers, boolean dblClick) {
        String msg = "";
        if (modifiers != 0) {
            msg = msg + KeyEvent.getKeyModifiersText(modifiers) + "+";
        }
        if (buttons == 16 && !dblClick) {
            msg = msg + "CLICK";
        }
        if (buttons == 16 && dblClick) {
            msg = msg + "DOUBLE CLICK";
        }
        if (buttons == 4) {
            msg = msg + "RIGHT CLICK";
        } else if (buttons == 8) {
            msg = msg + "MID CLICK";
        }
        msg = msg + " on " + loc;
        return msg;
    }

    public static int move(Location loc) {
        return Mouse.move(loc, null);
    }

    public static int move(int xoff, int yoff) {
        return Mouse.move(Mouse.at().offset(xoff, yoff));
    }

    protected static int move(Location loc, Region region) {
        if (Mouse.get().device.isSuspended()) {
            return 0;
        }
        if (loc != null) {
            IRobot r = null;
            r = Screen.getMouseRobot();
            if (r == null) {
                return 0;
            }
            if (!r.isRemote()) {
                Mouse.get().device.use(region);
            }
            r.smoothMove(loc);
            r.waitForIdle();
            if (!r.isRemote()) {
                Mouse.get().device.let(region);
            }
            return 1;
        }
        return 0;
    }

    public static void down(int buttons) {
        Mouse.down(buttons, null);
    }

    protected static void down(int buttons, Region region) {
        if (Mouse.get().device.isSuspended()) {
            return;
        }
        Mouse.get().device.use(region);
        Screen.getMouseRobot().mouseDown(buttons);
    }

    public static void up() {
        Mouse.up(0, null);
    }

    public static void up(int buttons) {
        Mouse.up(buttons, null);
    }

    protected static void up(int buttons, Region region) {
        if (Mouse.get().device.isSuspended()) {
            return;
        }
        Screen.getMouseRobot().mouseUp(buttons);
        if (region != null) {
            Mouse.get().device.let(region);
        }
    }

    public static void wheel(int direction, int steps) {
        Mouse.wheel(direction, steps, null);
    }

    protected static void wheel(int direction, int steps, Region region) {
        Mouse.wheel(direction, steps, region, 50);
    }

    protected static void wheel(int direction, int steps, Region region, int stepDelay) {
        if (Mouse.get().device.isSuspended()) {
            return;
        }
        IRobot r = Screen.getMouseRobot();
        Mouse.get().device.use(region);
        Debug.log(3, "Region: wheel: %s steps: %d", new Object[]{direction == -1 ? "WHEEL_UP" : "WHEEL_DOWN", steps});
        for (int i = 0; i < steps; ++i) {
            r.mouseWheel(direction);
            r.delay(stepDelay);
        }
        Mouse.get().device.let(region);
    }
}

