/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import edu.unh.iol.dlc.VNCScreen;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.App;
import org.sikuli.script.FindFailed;
import org.sikuli.script.FindFailedDialog;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.Finder;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Image;
import org.sikuli.script.ImageFinder;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Key;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Mouse;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.Observer;
import org.sikuli.script.ObserverCallBack;
import org.sikuli.script.Observing;
import org.sikuli.script.Pattern;
import org.sikuli.script.RunTime;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Sikulix;
import org.sikuli.script.TextRecognizer;
import org.sikuli.util.ScreenHighlighter;

public class Region {
    static RunTime runTime = RunTime.get();
    private static String me = "Region: ";
    private static int lvl = 3;
    private IScreen scr;
    protected boolean otherScreen = false;
    private ScreenHighlighter overlay = null;
    public int x;
    public int y;
    public int w;
    public int h;
    private FindFailedResponse findFailedResponse = FindFailed.defaultFindFailedResponse;
    private boolean throwException = Settings.ThrowException;
    private double autoWaitTimeout = Settings.AutoWaitTimeout;
    private float waitScanRate = Settings.WaitScanRate;
    private boolean observing = false;
    private float observeScanRate = Settings.ObserveScanRate;
    private int repeatWaitTime = Settings.RepeatWaitTime;
    private Observer regionObserver = null;
    private Match lastMatch = null;
    private Iterator<Match> lastMatches = null;
    private long lastSearchTime = -1L;
    private long lastFindTime = -1L;
    private boolean isScreenUnion = false;
    private boolean isVirtual = false;
    private long lastSearchTimeRepeat = -1L;
    public static final int NW = 300;
    public static final int NORTH_WEST = 300;
    public static final int TL = 300;
    public static final int NM = 301;
    public static final int NORTH_MID = 301;
    public static final int TM = 301;
    public static final int NE = 302;
    public static final int NORTH_EAST = 302;
    public static final int TR = 302;
    public static final int EM = 312;
    public static final int EAST_MID = 312;
    public static final int RM = 312;
    public static final int SE = 322;
    public static final int SOUTH_EAST = 322;
    public static final int BR = 322;
    public static final int SM = 321;
    public static final int SOUTH_MID = 321;
    public static final int BM = 321;
    public static final int SW = 320;
    public static final int SOUTH_WEST = 320;
    public static final int BL = 320;
    public static final int WM = 310;
    public static final int WEST_MID = 310;
    public static final int LM = 310;
    public static final int MM = 311;
    public static final int MIDDLE = 311;
    public static final int M3 = 311;
    public static final int TT = 200;
    public static final int RR = 201;
    public static final int BB = 211;
    public static final int LL = 210;
    public static final int NH = 202;
    public static final int NORTH = 202;
    public static final int TH = 202;
    public static final int EH = 221;
    public static final int EAST = 221;
    public static final int RH = 221;
    public static final int SH = 212;
    public static final int SOUTH = 212;
    public static final int BH = 212;
    public static final int WH = 220;
    public static final int WEST = 220;
    public static final int LH = 220;
    public static final int MV = 441;
    public static final int MID_VERTICAL = 441;
    public static final int CV = 441;
    public static final int MH = 414;
    public static final int MID_HORIZONTAL = 414;
    public static final int CH = 414;
    public static final int M2 = 444;
    public static final int MIDDLE_BIG = 444;
    public static final int C2 = 444;
    public static final int EN = 302;
    public static final int EAST_NORTH = 302;
    public static final int RT = 302;
    public static final int ES = 322;
    public static final int EAST_SOUTH = 322;
    public static final int RB = 322;
    public static final int WN = 300;
    public static final int WEST_NORTH = 300;
    public static final int LT = 300;
    public static final int WS = 320;
    public static final int WEST_SOUTH = 320;
    public static final int LB = 320;
    private int rows;
    private int cols = 0;
    private int rowH = 0;
    private int colW = 0;
    private int rowHd = 0;
    private int colWd = 0;
    public static final int CREATE_X_DIRECTION_LEFT = 0;
    public static final int CREATE_X_DIRECTION_RIGHT = 1;
    public static final int CREATE_Y_DIRECTION_TOP = 0;
    public static final int CREATE_Y_DIRECTION_BOTTOM = 1;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public long getLastTime() {
        return this.lastFindTime;
    }

    public String toString() {
        return String.format("R[%d,%d %dx%d]@%s E:%s, T:%.1f", this.x, this.y, this.w, this.h, this.getScreen() == null ? "Screen null" : this.getScreen().toStringShort(), this.throwException ? "Y" : "N", this.autoWaitTimeout);
    }

    public String toStringShort() {
        return String.format("R[%d,%d %dx%d]@S(%s)", this.x, this.y, this.w, this.h, this.getScreen() == null ? "?" : Integer.valueOf(this.getScreen().getID()));
    }

    public String toJSON() {
        return String.format("[\"R\", %d, %d, %d, %d]", this.x, this.y, this.w, this.h);
    }

    public void initScreen(IScreen iscr) {
        Rectangle rect;
        if (iscr != null) {
            if (iscr.isOtherScreen()) {
                if (this.x < 0) {
                    this.w += this.x;
                    this.x = 0;
                }
                if (this.y < 0) {
                    this.h += this.y;
                    this.y = 0;
                }
                this.scr = iscr;
                this.otherScreen = true;
                return;
            }
            if (iscr.getID() > -1) {
                rect = this.regionOnScreen(iscr);
                if (rect != null) {
                    this.x = rect.x;
                    this.y = rect.y;
                    this.w = rect.width;
                    this.h = rect.height;
                    this.scr = iscr;
                    return;
                }
            } else {
                return;
            }
        }
        Rectangle screenRect = new Rectangle(0, 0, 0, 0);
        Region screenOn = null;
        boolean isVNC = iscr == null ? this.scr instanceof VNCScreen : iscr instanceof VNCScreen;
        if (!isVNC) {
            for (int i = 0; i < Screen.getNumberScreens(); ++i) {
                Screen screen = Screen.getScreen(i);
                rect = this.regionOnScreen(screen);
                if (rect == null || rect.width * rect.height <= screenRect.width * screenRect.height) continue;
                screenRect = rect;
                screenOn = screen;
            }
        } else {
            for (int i = 0; i < VNCScreen.getNumberScreens(); ++i) {
                VNCScreen screen = VNCScreen.getScreen(i);
                rect = this.regionOnScreen(screen);
                if (rect == null || rect.width * rect.height <= screenRect.width * screenRect.height) continue;
                screenRect = rect;
                screenOn = screen;
            }
        }
        if (screenOn != null) {
            this.x = screenRect.x;
            this.y = screenRect.y;
            this.w = screenRect.width;
            this.h = screenRect.height;
            this.scr = screenOn;
        } else {
            this.scr = null;
            Debug.error("Region(%d,%d,%d,%d) outside any screen - subsequent actions might not work as expected", this.x, this.y, this.w, this.h);
        }
    }

    private Location checkAndSetRemote(Location loc) {
        if (!this.isOtherScreen()) {
            return loc;
        }
        return loc.setOtherScreen(this.scr);
    }

    public static Region virtual(Rectangle rect) {
        Region reg = new Region();
        reg.x = rect.x;
        reg.y = rect.y;
        reg.w = rect.width;
        reg.h = rect.height;
        reg.setVirtual(true);
        reg.scr = Screen.getPrimaryScreen();
        return reg;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean state) {
        this.isVirtual = state;
    }

    public boolean isOtherScreen() {
        return this.otherScreen;
    }

    public void setOtherScreen() {
        this.otherScreen = true;
    }

    protected Rectangle regionOnScreen(IScreen screen) {
        if (screen == null) {
            return null;
        }
        Rectangle rect = screen.getRect().intersection(this.getRect());
        if (rect.isEmpty()) {
            return null;
        }
        return rect;
    }

    public boolean isValid() {
        return this.scr != null && this.w != 0 && this.h != 0;
    }

    public Region(int X, int Y, int W, int H, int screenNumber) {
        this(X, Y, W, H, Screen.getScreen(screenNumber));
        this.rows = 0;
    }

    public Region(int X, int Y, int W, int H, IScreen parentScreen) {
        this.rows = 0;
        this.x = X;
        this.y = Y;
        this.w = W > 1 ? W : 1;
        this.h = H > 1 ? H : 1;
        this.initScreen(parentScreen);
    }

    public Region(int X, int Y, int W, int H) {
        this(X, Y, W, H, null);
        this.rows = 0;
        Region.log(lvl, "init: (%d, %d, %d, %d)", X, Y, W, H);
    }

    public Region(Rectangle r) {
        this(r.x, r.y, r.width, r.height, null);
        this.rows = 0;
    }

    public Region(Region r) {
        this.init(r);
    }

    public void init(Region r) {
        if (!r.isValid()) {
            return;
        }
        this.x = r.x;
        this.y = r.y;
        this.w = r.w;
        this.h = r.h;
        this.scr = r.getScreen();
        this.otherScreen = r.isOtherScreen();
        this.rows = 0;
        this.autoWaitTimeout = r.autoWaitTimeout;
        this.findFailedResponse = r.findFailedResponse;
        this.throwException = r.throwException;
        this.waitScanRate = r.waitScanRate;
        this.observeScanRate = r.observeScanRate;
        this.repeatWaitTime = r.repeatWaitTime;
    }

    protected Region() {
        this.rows = 0;
    }

    protected Region(boolean isScreenUnion) {
        this.isScreenUnion = isScreenUnion;
        this.rows = 0;
    }

    public static Region create(int X, int Y, int W, int H) {
        return Region.create(X, Y, W, H, null);
    }

    private static Region create(int X, int Y, int W, int H, IScreen scr) {
        return new Region(X, Y, W, H, scr);
    }

    public static Region create(Location loc, int w, int h) {
        return Region.create(loc.x, loc.y, w, h, loc.getScreen());
    }

    public static Region create(Location loc, int create_x_direction, int create_y_direction, int w, int h) {
        int Y;
        int X;
        int W = w;
        int H = h;
        if (create_x_direction == 0) {
            if (create_y_direction == 0) {
                X = loc.x;
                Y = loc.y;
            } else {
                X = loc.x;
                Y = loc.y - h;
            }
        } else if (create_y_direction == 0) {
            X = loc.x - w;
            Y = loc.y;
        } else {
            X = loc.x - w;
            Y = loc.y - h;
        }
        return Region.create(X, Y, W, H, loc.getScreen());
    }

    public static Region grow(Location loc, int x, int y, int w, int h) {
        return Region.create(loc, x, y, w, h);
    }

    public static Region create(Rectangle r) {
        return Region.create(r.x, r.y, r.width, r.height, null);
    }

    protected static Region create(Rectangle r, IScreen parentScreen) {
        return Region.create(r.x, r.y, r.width, r.height, parentScreen);
    }

    public static Region create(Region r) {
        Region reg = Region.create(r.x, r.y, r.w, r.h, r.getScreen());
        reg.autoWaitTimeout = r.autoWaitTimeout;
        reg.findFailedResponse = r.findFailedResponse;
        reg.throwException = r.throwException;
        return reg;
    }

    public static Region grow(Location loc, int w, int h) {
        int X = loc.x - w / 2;
        int Y = loc.y - h / 2;
        return Region.create(X, Y, w, h, loc.getScreen());
    }

    public static Region grow(Location loc) {
        return Region.create(loc.x, loc.y, 1, 1, loc.getScreen());
    }

    public boolean contains(Location point) {
        return this.getRect().contains(point.x, point.y);
    }

    public boolean containsMouse() {
        return this.contains(Mouse.at());
    }

    public Region copyTo(int scrID) {
        return this.copyTo(Screen.getScreen(scrID));
    }

    public Region copyTo(IScreen screen) {
        Location o = new Location(this.getScreen().getBounds().getLocation());
        Location n = new Location(screen.getBounds().getLocation());
        return Region.create(n.x + this.x - o.x, n.y + this.y - o.y, this.w, this.h, screen);
    }

    protected Match toGlobalCoord(Match m) {
        m.x += this.x;
        m.y += this.y;
        return m;
    }

    public void setThrowException(boolean flag) {
        this.throwException = flag;
        this.findFailedResponse = this.throwException ? FindFailedResponse.ABORT : FindFailedResponse.SKIP;
    }

    public boolean getThrowException() {
        return this.throwException;
    }

    public void setAutoWaitTimeout(double sec) {
        this.autoWaitTimeout = sec;
    }

    public double getAutoWaitTimeout() {
        return this.autoWaitTimeout;
    }

    public void setFindFailedResponse(FindFailedResponse response) {
        this.findFailedResponse = response;
    }

    public FindFailedResponse getFindFailedResponse() {
        return this.findFailedResponse;
    }

    public float getWaitScanRate() {
        return this.waitScanRate;
    }

    public void setWaitScanRate(float waitScanRate) {
        this.waitScanRate = waitScanRate;
    }

    public float getObserveScanRate() {
        return this.observeScanRate;
    }

    public void setObserveScanRate(float observeScanRate) {
        this.observeScanRate = observeScanRate;
    }

    public int getRepeatWaitTime() {
        return this.repeatWaitTime;
    }

    public void setRepeatWaitTime(int time) {
        this.repeatWaitTime = time;
    }

    public IScreen getScreen() {
        return this.scr;
    }

    private IRobot getRobotForRegion() {
        if (this.getScreen() == null || this.isScreenUnion) {
            return Screen.getPrimaryScreen().getRobot();
        }
        return this.getScreen().getRobot();
    }

    @Deprecated
    public IScreen getScreenContaining() {
        return this.getScreen();
    }

    protected Region setScreen(IScreen scr) {
        this.initScreen(scr);
        return this;
    }

    protected Region setScreen(int id) {
        return this.setScreen(Screen.getScreen(id));
    }

    public void showScreens() {
        Screen.showMonitors();
    }

    public void resetScreens() {
        Screen.resetMonitors();
    }

    public Location getCenter() {
        return this.checkAndSetRemote(new Location(this.getX() + this.getW() / 2, this.getY() + this.getH() / 2));
    }

    public Location getTarget() {
        return this.getCenter();
    }

    public Region setCenter(Location loc) {
        Location c = this.getCenter();
        this.x = this.x - c.x + loc.x;
        this.y = this.y - c.y + loc.y;
        this.initScreen(null);
        return this;
    }

    public Location getTopLeft() {
        return this.checkAndSetRemote(new Location(this.x, this.y));
    }

    public Region setTopLeft(Location loc) {
        return this.setLocation(loc);
    }

    public Location getTopRight() {
        return this.checkAndSetRemote(new Location(this.x + this.w - 1, this.y));
    }

    public Region setTopRight(Location loc) {
        Location c = this.getTopRight();
        this.x = this.x - c.x + loc.x;
        this.y = this.y - c.y + loc.y;
        this.initScreen(null);
        return this;
    }

    public Location getBottomLeft() {
        return this.checkAndSetRemote(new Location(this.x, this.y + this.h - 1));
    }

    public Region setBottomLeft(Location loc) {
        Location c = this.getBottomLeft();
        this.x = this.x - c.x + loc.x;
        this.y = this.y - c.y + loc.y;
        this.initScreen(null);
        return this;
    }

    public Location getBottomRight() {
        return this.checkAndSetRemote(new Location(this.x + this.w - 1, this.y + this.h - 1));
    }

    public Region setBottomRight(Location loc) {
        Location c = this.getBottomRight();
        this.x = this.x - c.x + loc.x;
        this.y = this.y - c.y + loc.y;
        this.initScreen(null);
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public void setX(int X) {
        this.x = X;
        this.initScreen(null);
    }

    public void setY(int Y) {
        this.y = Y;
        this.initScreen(null);
    }

    public void setW(int W) {
        this.w = W > 1 ? W : 1;
        this.initScreen(null);
    }

    public void setH(int H) {
        this.h = H > 1 ? H : 1;
        this.initScreen(null);
    }

    public Region setSize(int W, int H) {
        this.w = W > 1 ? W : 1;
        this.h = H > 1 ? H : 1;
        this.initScreen(null);
        return this;
    }

    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public Region setRect(Rectangle r) {
        return this.setRect(r.x, r.y, r.width, r.height);
    }

    public Region setRect(int X, int Y, int W, int H) {
        this.x = X;
        this.y = Y;
        this.w = W > 1 ? W : 1;
        this.h = H > 1 ? H : 1;
        this.initScreen(null);
        return this;
    }

    public Region setRect(Region r) {
        return this.setRect(r.x, r.y, r.w, r.h);
    }

    public void setROI() {
        this.setROI(this.getScreen().getBounds());
    }

    public void setROI(int X, int Y, int W, int H) {
        this.x = X;
        this.y = Y;
        this.w = W > 1 ? W : 1;
        this.h = H > 1 ? H : 1;
        this.initScreen(null);
    }

    public void setROI(Rectangle r) {
        this.setROI(r.x, r.y, r.width, r.height);
    }

    public void setROI(Region reg) {
        this.setROI(reg.getX(), reg.getY(), reg.getW(), reg.getH());
    }

    public Region getROI() {
        return new Region(this.getScreen().getRect());
    }

    @Deprecated
    public Region inside() {
        return this;
    }

    @Deprecated
    public Region moveTo(Location loc) {
        return this.setLocation(loc);
    }

    public Region setLocation(Location loc) {
        this.x = loc.x;
        this.y = loc.y;
        this.initScreen(null);
        return this;
    }

    @Deprecated
    public Region morphTo(Region r) {
        return this.setRect(r);
    }

    public Region add(int l, int r, int t, int b) {
        this.x -= l;
        this.y -= t;
        this.w = this.w + l + r;
        if (this.w < 1) {
            this.w = 1;
        }
        this.h = this.h + t + b;
        if (this.h < 1) {
            this.h = 1;
        }
        this.initScreen(null);
        return this;
    }

    public Region add(Region r) {
        Rectangle rect = this.getRect();
        rect.add(r.getRect());
        this.setRect(rect);
        this.initScreen(null);
        return this;
    }

    public Region add(Location loc) {
        Rectangle rect = this.getRect();
        rect.add(loc.x, loc.y);
        this.setRect(rect);
        this.initScreen(null);
        return this;
    }

    public Match getLastMatch() {
        return this.lastMatch;
    }

    public Iterator<Match> getLastMatches() {
        return this.lastMatches;
    }

    public ScreenImage getLastScreenImage() {
        return this.getScreen().getLastScreenImageFromScreen();
    }

    public String getLastScreenImageFile() throws IOException {
        return this.getScreen().getLastScreenImageFile(ImagePath.getBundlePath(), null);
    }

    public String getLastScreenImageFile(String name) throws IOException {
        return this.getScreen().getLastScreenImageFromScreen().getFile(ImagePath.getBundlePath(), name);
    }

    public String getLastScreenImageFile(String path, String name) throws IOException {
        return this.getScreen().getLastScreenImageFromScreen().getFile(path, name);
    }

    public boolean contains(Region region) {
        return this.getRect().contains(region.getRect());
    }

    public Location asOffset() {
        return new Location(this.w, this.h);
    }

    public Region offset(Location loc) {
        return Region.create(this.x + loc.x, this.y + loc.y, this.w, this.h, this.scr);
    }

    public Region offset(int x, int y) {
        return Region.create(this.x + x, this.y + y, this.w, this.h, this.scr);
    }

    @Deprecated
    public Region nearby() {
        return this.grow(50, 50);
    }

    @Deprecated
    public Region nearby(int range) {
        return this.grow(range, range);
    }

    public Region grow() {
        return this.grow(50, 50);
    }

    public Region grow(int range) {
        return this.grow(range, range);
    }

    public Region grow(int w, int h) {
        Rectangle r = this.getRect();
        r.grow(w, h);
        return Region.create(r.x, r.y, r.width, r.height, this.scr);
    }

    public Region grow(int l, int r, int t, int b) {
        return Region.create(this.x - l, this.y - t, this.w + l + r, this.h + t + b, this.scr);
    }

    public Location rightAt() {
        return this.rightAt(0);
    }

    public Location rightAt(int offset) {
        return this.checkAndSetRemote(new Location(this.x + this.w + offset, this.y + this.h / 2));
    }

    public Region right() {
        int distToRightScreenBorder = this.getScreen().getX() + this.getScreen().getW() - (this.getX() + this.getW());
        return this.right(distToRightScreenBorder);
    }

    public Region right(int width) {
        int _x = width < 0 ? this.x + this.w + width : this.x + this.w;
        return Region.create(_x, this.y, Math.abs(width), this.h, this.scr);
    }

    public Location leftAt() {
        return this.leftAt(0);
    }

    public Location leftAt(int offset) {
        return this.checkAndSetRemote(new Location(this.x + offset, this.y + this.h / 2));
    }

    public Region left() {
        int distToLeftScreenBorder = this.getX() - this.getScreen().getX();
        return this.left(distToLeftScreenBorder);
    }

    public Region left(int width) {
        int _x = width < 0 ? this.x : this.x - width;
        return Region.create(this.getScreen().getBounds().intersection(new Rectangle(_x, this.y, Math.abs(width), this.h)), this.scr);
    }

    public Location aboveAt() {
        return this.aboveAt(0);
    }

    public Location aboveAt(int offset) {
        return this.checkAndSetRemote(new Location(this.x + this.w / 2, this.y + offset));
    }

    public Region above() {
        int distToAboveScreenBorder = this.getY() - this.getScreen().getY();
        return this.above(distToAboveScreenBorder);
    }

    public Region above(int height) {
        int _y = height < 0 ? this.y : this.y - height;
        return Region.create(this.getScreen().getBounds().intersection(new Rectangle(this.x, _y, this.w, Math.abs(height))), this.scr);
    }

    public Location belowAt() {
        return this.belowAt(0);
    }

    public Location belowAt(int offset) {
        return this.checkAndSetRemote(new Location(this.x + this.w / 2, this.y + this.h - offset));
    }

    public Region below() {
        int distToBelowScreenBorder = this.getScreen().getY() + this.getScreen().getH() - (this.getY() + this.getH());
        return this.below(distToBelowScreenBorder);
    }

    public Region below(int height) {
        int _y = height < 0 ? this.y + this.h + height : this.y + this.h;
        return Region.create(this.x, _y, this.w, Math.abs(height), this.scr);
    }

    public Region union(Region ur) {
        Rectangle r = this.getRect().union(ur.getRect());
        return Region.create(r.x, r.y, r.width, r.height, this.scr);
    }

    public Region intersection(Region ir) {
        Rectangle r = this.getRect().intersection(ir.getRect());
        return Region.create(r.x, r.y, r.width, r.height, this.scr);
    }

    public Region get(int part) {
        return Region.create(Region.getRectangle(this.getRect(), part));
    }

    protected static Rectangle getRectangle(Rectangle rect, int part) {
        if (part < 200 || part > 999) {
            return rect;
        }
        Region r = Region.create(rect);
        int pTyp = part / 100;
        int pPos = part - pTyp * 100;
        int pRow = pPos / 10;
        int pCol = pPos - pRow * 10;
        r.setRaster(pTyp, pTyp);
        if (pTyp == 3) {
            return r.getCell(pRow, pCol).getRect();
        }
        if (pTyp == 2) {
            if (pRow > 1) {
                return r.getCol(pCol).getRect();
            }
            if (pCol > 1) {
                return r.getRow(pRow).getRect();
            }
            return r.getCell(pRow, pCol).getRect();
        }
        if (pTyp == 4) {
            if (pRow > 3) {
                if (pCol > 3) {
                    return r.getCell(1, 1).union(r.getCell(2, 2)).getRect();
                }
                return r.getCell(0, 1).union(r.getCell(3, 2)).getRect();
            }
            if (pCol > 3) {
                return r.getCell(1, 0).union(r.getCell(2, 3)).getRect();
            }
            return r.getCell(pRow, pCol).getRect();
        }
        return rect;
    }

    public Region setRows(int n) {
        return this.setRaster(n, 0);
    }

    public Region setCols(int n) {
        return this.setRaster(0, n);
    }

    public int getRows() {
        return this.rows;
    }

    public int getRowH() {
        return this.rowH;
    }

    public int getCols() {
        return this.cols;
    }

    public int getColW() {
        return this.colW;
    }

    public boolean isRasterValid() {
        return this.rows > 0 || this.cols > 0;
    }

    public Region setRaster(int r, int c) {
        this.rows = Math.max(r, this.h);
        this.cols = Math.max(c, this.w);
        if (r > 0) {
            this.rowH = this.h / r;
            this.rowHd = this.h - r * this.rowH;
        }
        if (c > 0) {
            this.colW = this.w / c;
            this.colWd = this.w - c * this.colW;
        }
        return this.getCell(0, 0);
    }

    public Region getRow(int r) {
        if (this.rows == 0) {
            return this;
        }
        if (r < 0) {
            r = this.rows + r;
        }
        r = Math.max(0, r);
        r = Math.min(r, this.rows - 1);
        return Region.create(this.x, this.y + r * this.rowH, this.w, this.rowH);
    }

    public Region getRow(int r, int n) {
        return this;
    }

    public Region getCol(int c) {
        if (this.cols == 0) {
            return this;
        }
        if (c < 0) {
            c = this.cols + c;
        }
        c = Math.max(0, c);
        c = Math.min(c, this.cols - 1);
        return Region.create(this.x + c * this.colW, this.y, this.colW, this.h);
    }

    public Region getCol(int c, int n) {
        Region r = new Region(this);
        r.setCols(n);
        return r.getCol(c);
    }

    public Region getCell(int r, int c) {
        if (this.rows == 0) {
            return this.getCol(c);
        }
        if (this.cols == 0) {
            return this.getRow(r);
        }
        if (this.rows == 0 && this.cols == 0) {
            return this;
        }
        if (r < 0) {
            r = this.rows - r;
        }
        if (c < 0) {
            c = this.cols - c;
        }
        r = Math.max(0, r);
        r = Math.min(r, this.rows - 1);
        c = Math.max(0, c);
        c = Math.min(c, this.cols - 1);
        return Region.create(this.x + c * this.colW, this.y + r * this.rowH, this.colW, this.rowH);
    }

    protected void updateSelf() {
        if (this.overlay != null) {
            this.highlight(false, null);
            this.highlight(true, null);
        }
    }

    protected Region silentHighlight(boolean onOff) {
        if (onOff && this.overlay == null) {
            return this.doHighlight(true, null, true);
        }
        if (!onOff && this.overlay != null) {
            return this.doHighlight(true, null, true);
        }
        return this;
    }

    public Region highlight() {
        this.highlight(this.overlay == null, null);
        return this;
    }

    public Region highlight(String color) {
        this.highlight(this.overlay == null, color);
        return this;
    }

    private Region highlight(boolean toEnable, String color) {
        return this.doHighlight(toEnable, color, false);
    }

    private Region doHighlight(boolean toEnable, String color, boolean silent) {
        if (this.isOtherScreen()) {
            return this;
        }
        if (!silent) {
            Debug.action("toggle highlight " + this.toString() + ": " + toEnable + (color != null ? " color: " + color : ""), new Object[0]);
        }
        if (toEnable) {
            this.overlay = new ScreenHighlighter(this.getScreen(), color);
            this.overlay.highlight(this);
        } else if (this.overlay != null) {
            this.overlay.close();
            this.overlay = null;
        }
        return this;
    }

    public Region highlight(float secs) {
        return this.highlight(secs, null);
    }

    public Region highlight(float secs, String color) {
        if (this.isOtherScreen()) {
            return this;
        }
        if ((double)secs < 0.1) {
            return this.highlight((int)secs, color);
        }
        Debug.action("highlight " + this.toString() + " for " + secs + " secs" + (color != null ? " color: " + color : ""), new Object[0]);
        ScreenHighlighter _overlay = new ScreenHighlighter(this.getScreen(), color);
        _overlay.highlight(this, secs);
        return this;
    }

    public Region highlight(int secs) {
        return this.highlight(secs, (String)null);
    }

    public Region highlight(int secs, String color) {
        if (this.isOtherScreen()) {
            return this;
        }
        if (secs > 0) {
            return this.highlight((float)secs, color);
        }
        if (this.lastMatch != null) {
            if (secs < 0) {
                return this.lastMatch.highlight((float)(-secs), color);
            }
            return this.lastMatch.highlight(Settings.DefaultHighlightTime, color);
        }
        return this;
    }

    public void wait(double timeout) {
        try {
            Thread.sleep((long)(timeout * 1000.0));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private <PSI> Image getImage(PSI target) {
        if (target instanceof Pattern) {
            return ((Pattern)target).getImage();
        }
        if (target instanceof String) {
            return Image.get((String)target);
        }
        if (target instanceof Image) {
            return (Image)target;
        }
        return null;
    }

    private <PSI> boolean handleFindFailed(PSI target) throws FindFailed {
        return this.handleFindFailedShowDialog(target, false);
    }

    private <PSI> boolean handleFindFailedQuietly(PSI target) {
        try {
            return this.handleFindFailedShowDialog(target, false);
        }
        catch (FindFailed findFailed) {
            return false;
        }
    }

    private <PSI> boolean handleFindFailedImageMissing(PSI target) {
        boolean shouldHandle = false;
        try {
            shouldHandle = this.handleFindFailedShowDialog(target, true);
        }
        catch (FindFailed ex) {
            return false;
        }
        if (!shouldHandle) {
            return false;
        }
        this.getRobotForRegion().delay(500);
        ScreenImage img = this.getScreen().userCapture("capture missing image");
        if (img != null) {
            String path = ImagePath.getBundlePath();
            if (path == null) {
                return false;
            }
            String imgName = (String)target;
            img.getFile(path, imgName);
            return true;
        }
        return false;
    }

    private boolean handleFindFailedShowDialog(Object target, boolean shouldCapture) throws FindFailed {
        FindFailedResponse response;
        if (this.findFailedResponse == FindFailedResponse.PROMPT) {
            FindFailedDialog fd = new FindFailedDialog(target, shouldCapture);
            fd.setVisible(true);
            response = fd.getResponse();
            fd.dispose();
            this.wait(0.5);
        } else {
            response = this.findFailedResponse;
        }
        if (response == FindFailedResponse.SKIP) {
            return false;
        }
        if (response == FindFailedResponse.RETRY) {
            return true;
        }
        if (response == FindFailedResponse.ABORT) {
            String targetStr = target.toString();
            if (target instanceof String) {
                targetStr = targetStr.trim();
            }
            throw new FindFailed(String.format("can not find %s in %s", targetStr, this.toStringShort()));
        }
        return false;
    }

    public <PSI> Match find(PSI target) throws FindFailed {
        if (this.autoWaitTimeout > 0.0) {
            return this.wait(target, this.autoWaitTimeout);
        }
        this.lastMatch = null;
        String targetStr = target.toString();
        if (target instanceof String) {
            targetStr = targetStr.trim();
        }
        while (true) {
            try {
                Region.log(3, "find: waiting 0 secs for %s to appear in %s", targetStr, this.toStringShort());
                this.lastMatch = this.doFind(target, null);
            }
            catch (IOException ex) {
                if (ex instanceof IOException && this.handleFindFailedImageMissing(target)) continue;
                throw new FindFailed(ex.getMessage());
            }
            if (this.lastMatch != null) {
                Image img = this.getImage(target);
                this.lastMatch.setImage(img);
                if (img != null) {
                    img.setLastSeen(this.lastMatch.getRect(), this.lastMatch.getScore());
                }
                Region.log(lvl, "find: %s has appeared \nat %s", targetStr, this.lastMatch);
                return this.lastMatch;
            }
            Region.log(3, "find: %s has not appeared [%d msec]", targetStr, this.lastFindTime);
            if (!this.handleFindFailed(target)) break;
        }
        return null;
    }

    public <PSI> Iterator<Match> findAll(PSI target) throws FindFailed {
        this.lastMatches = null;
        String targetStr = target.toString();
        if (target instanceof String) {
            targetStr = targetStr.trim();
        }
        while (true) {
            try {
                if (this.autoWaitTimeout > 0.0) {
                    RepeatableFindAll rf = new RepeatableFindAll(target);
                    rf.repeat(this.autoWaitTimeout);
                    this.lastMatches = rf.getMatches();
                } else {
                    this.lastMatches = this.doFindAll(target, null);
                }
            }
            catch (Exception ex) {
                if (ex instanceof IOException && this.handleFindFailedImageMissing(target)) continue;
                throw new FindFailed(ex.getMessage());
            }
            if (this.lastMatches != null) {
                return this.lastMatches;
            }
            if (!this.handleFindFailed(target)) break;
        }
        return null;
    }

    public <PSI> Match[] findAllByRow(PSI target) {
        Match[] matches = new Match[]{};
        List<Match> mList = this.findAllCollect(target);
        if (mList.isEmpty()) {
            return null;
        }
        Collections.sort(mList, new Comparator<Match>(){

            @Override
            public int compare(Match m1, Match m2) {
                if (m1.y == m2.y) {
                    return m1.x - m2.x;
                }
                return m1.y - m2.y;
            }
        });
        return mList.toArray(matches);
    }

    public <PSI> Match[] findAllByColumn(PSI target) {
        Match[] matches = new Match[]{};
        List<Match> mList = this.findAllCollect(target);
        if (mList.isEmpty()) {
            return null;
        }
        Collections.sort(mList, new Comparator<Match>(){

            @Override
            public int compare(Match m1, Match m2) {
                if (m1.x == m2.x) {
                    return m1.y - m2.y;
                }
                return m1.x - m2.x;
            }
        });
        return mList.toArray(matches);
    }

    private <PSI> List<Match> findAllCollect(PSI target) {
        Iterator<Match> mIter = null;
        try {
            mIter = this.findAll(target);
        }
        catch (Exception ex) {
            Debug.error("findAllByRow: %s", ex.getMessage());
            return null;
        }
        ArrayList<Match> mList = new ArrayList<Match>();
        while (mIter.hasNext()) {
            mList.add(mIter.next());
        }
        return mList;
    }

    public <PSI> Match findBest(Object ... args) {
        Debug.log(lvl, "findBest: enter", new Object[0]);
        Match mResult = null;
        List<Match> mList = this.findAnyCollect(args);
        if (mList != null) {
            Collections.sort(mList, new Comparator<Match>(){

                @Override
                public int compare(Match m1, Match m2) {
                    double ms = m2.getScore() - m1.getScore();
                    if (ms < 0.0) {
                        return -1;
                    }
                    if (ms > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            });
            mResult = mList.get(0);
        }
        return mResult;
    }

    private List<Match> findAnyCollect(Object ... args) {
        if (args == null) {
            return null;
        }
        ArrayList<Match> mList = new ArrayList<Match>();
        Match[] mArray = new Match[args.length];
        SubFindRun[] theSubs = new SubFindRun[args.length];
        int nobj = 0;
        ScreenImage base = this.getScreen().capture(this);
        for (Object obj : args) {
            mArray[nobj] = null;
            if (obj instanceof Pattern || obj instanceof String || obj instanceof Image) {
                theSubs[nobj] = new SubFindRun(mArray, nobj, base, obj, this);
                new Thread(theSubs[nobj]).start();
            }
            ++nobj;
        }
        Debug.log(lvl, "findAnyCollect: waiting for SubFindRuns", new Object[0]);
        nobj = 0;
        boolean all = false;
        while (!all) {
            all = true;
            for (SubFindRun sub : theSubs) {
                all &= sub.hasFinished();
            }
        }
        Debug.log(lvl, "findAnyCollect: SubFindRuns finished", new Object[0]);
        nobj = 0;
        for (Match match : mArray) {
            if (match != null) {
                match.setIndex(nobj);
                mList.add(match);
            }
            ++nobj;
        }
        return mList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Match findInImage(ScreenImage base, Object target) throws IOException {
        Finder finder = null;
        Match match = null;
        boolean findingText = false;
        Image img = null;
        if (target instanceof String) {
            if (((String)target).startsWith("\t") && ((String)target).endsWith("\t")) {
                findingText = true;
            } else {
                img = Image.create((String)target);
                if (img.isValid()) {
                    finder = this.doCheckLastSeenAndCreateFinder(base, img, 0.0, null);
                    if (!finder.hasNext()) {
                        this.runFinder(finder, img);
                    }
                } else {
                    if (!img.isText()) throw new IOException("Region: findInImage: Image not loadable: " + target.toString());
                    findingText = true;
                }
            }
            if (findingText && TextRecognizer.getInstance() != null) {
                Region.log(lvl, "findInImage: Switching to TextSearch", new Object[0]);
                finder = new Finder(this.getScreen().capture(this.x, this.y, this.w, this.h), this);
                finder.findText((String)target);
            }
        } else if (target instanceof Pattern) {
            if (!((Pattern)target).isValid()) throw new IOException("Region: findInImage: Image not loadable: " + target.toString());
            img = ((Pattern)target).getImage();
            finder = this.doCheckLastSeenAndCreateFinder(base, img, 0.0, (Pattern)target);
            if (!finder.hasNext()) {
                this.runFinder(finder, target);
            }
        } else if (target instanceof Image) {
            if (!((Image)target).isValid()) throw new IOException("Region: findInImage: Image not loadable: " + target.toString());
            img = (Image)target;
            finder = this.doCheckLastSeenAndCreateFinder(base, img, 0.0, null);
            if (!finder.hasNext()) {
                this.runFinder(finder, img);
            }
        } else {
            Region.log(-1, "findInImage: invalid parameter: %s", target);
            return null;
        }
        if (!finder.hasNext()) return match;
        match = finder.next();
        match.setImage(img);
        img.setLastSeen(match.getRect(), match.getScore());
        return match;
    }

    public <PSI> Match wait(PSI target) throws FindFailed {
        if (target instanceof Float || target instanceof Double) {
            this.wait(0.0 + (Double)target);
            return null;
        }
        return this.wait(target, this.autoWaitTimeout);
    }

    public <PSI> Match wait(PSI target, double timeout) throws FindFailed {
        String targetStr;
        block6: {
            this.lastMatch = null;
            targetStr = target.toString();
            if (target instanceof String) {
                targetStr = targetStr.trim();
            }
            while (true) {
                RepeatableFind rf;
                try {
                    Region.log(3, "find: waiting %.1f secs for %s to appear in %s", timeout, targetStr, this.toStringShort());
                    rf = new RepeatableFind(target);
                    rf.repeat(timeout);
                    this.lastMatch = rf.getMatch();
                }
                catch (Exception ex) {
                    if (ex instanceof IOException && this.handleFindFailedImageMissing(target)) continue;
                    throw new FindFailed(ex.getMessage());
                }
                if (this.lastMatch != null) {
                    this.lastMatch.setImage(rf._image);
                    if (rf._image != null) {
                        rf._image.setLastSeen(this.lastMatch.getRect(), this.lastMatch.getScore());
                    }
                    break block6;
                }
                Region.log(3, "find: %s has not appeared [%d msec]", targetStr, this.lastFindTime);
                if (!this.handleFindFailed(target)) break;
            }
            return null;
        }
        Region.log(lvl, "find: %s has appeared \nat %s", targetStr, this.lastMatch);
        return this.lastMatch;
    }

    public Match compare(String img) {
        return this.compare(Image.create(img));
    }

    public Match compare(Image img) {
        return this.exists(img, 0.0);
    }

    public <PSI> Match exists(PSI target) {
        return this.exists(target, this.autoWaitTimeout);
    }

    public <PSI> Match exists(PSI target, double timeout) {
        this.lastMatch = null;
        String targetStr = target.toString();
        if (target instanceof String) {
            targetStr = targetStr.trim();
        }
        while (true) {
            try {
                do {
                    Region.log(3, "exists: waiting %.1f secs for %s to appear in %s", timeout, targetStr, this.toStringShort());
                    RepeatableFind rf = new RepeatableFind(target);
                    if (!rf.repeat(timeout)) continue;
                    this.lastMatch = rf.getMatch();
                    Image img = rf._image;
                    this.lastMatch.setImage(img);
                    if (img != null) {
                        img.setLastSeen(this.lastMatch.getRect(), this.lastMatch.getScore());
                    }
                    Region.log(lvl, "exists: %s has appeared \nat %s", targetStr, this.lastMatch);
                    return this.lastMatch;
                } while (this.handleFindFailedQuietly(target));
            }
            catch (Exception ex) {
                if (!(ex instanceof IOException) || this.handleFindFailedImageMissing(target)) continue;
            }
            break;
        }
        Region.log(3, "exists: %s has not appeared [%d msec]", targetStr, this.lastFindTime);
        return null;
    }

    public Match findText(String text, double timeout) throws FindFailed {
        return this.wait("\t" + text + "\t", timeout);
    }

    public Match findText(String text) throws FindFailed {
        return this.findText(text, this.autoWaitTimeout);
    }

    public Iterator<Match> findAllText(String text) throws FindFailed {
        return this.findAll("\t" + text + "\t");
    }

    public <PSI> boolean waitVanish(PSI target) {
        return this.waitVanish(target, this.autoWaitTimeout);
    }

    public <PSI> boolean waitVanish(PSI target, double timeout) {
        while (true) {
            try {
                Region.log(lvl, "waiting for " + target + " to vanish", new Object[0]);
                RepeatableVanish r = new RepeatableVanish(target);
                if (r.repeat(timeout)) {
                    Region.log(lvl, "" + target + " has vanished", new Object[0]);
                    return true;
                }
                Region.log(lvl, "" + target + " has not vanished before timeout", new Object[0]);
                return false;
            }
            catch (Exception ex) {
                if (ex instanceof IOException && this.handleFindFailedImageMissing(target)) continue;
                return false;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <PSI> Match doFind(PSI ptn, RepeatableFind repeating) throws IOException {
        Finder f = null;
        Match m = null;
        IScreen s = null;
        boolean findingText = false;
        this.lastFindTime = new Date().getTime();
        double findTimeout = this.autoWaitTimeout;
        if (repeating != null) {
            findTimeout = repeating.getFindTimeOut();
        }
        if (repeating != null && repeating._finder != null) {
            ScreenImage simg = this.getScreen().capture(this);
            f = repeating._finder;
            f.setScreenImage(simg);
            f.setRepeating();
            if (Settings.FindProfiling) {
                Debug.logp("[FindProfiling] Region.doFind repeat: %d msec", new Date().getTime() - this.lastSearchTimeRepeat);
            }
            this.lastSearchTime = new Date().getTime();
            f.findRepeat();
        } else {
            s = this.getScreen();
            Image img = null;
            if (ptn instanceof String) {
                if (((String)ptn).startsWith("\t") && ((String)ptn).endsWith("\t")) {
                    findingText = true;
                } else {
                    img = Image.create((String)ptn);
                    if (img.isValid()) {
                        this.lastSearchTime = new Date().getTime();
                        f = this.checkLastSeenAndCreateFinder(img, findTimeout, null);
                        if (!f.hasNext()) {
                            this.runFinder(f, img);
                        }
                    } else {
                        if (!img.isText()) throw new IOException("Region: doFind: Image not loadable: " + ptn.toString());
                        findingText = true;
                    }
                }
                if (findingText && TextRecognizer.getInstance() != null) {
                    Region.log(lvl, "doFind: Switching to TextSearch", new Object[0]);
                    f = new Finder(this.getScreen().capture(this.x, this.y, this.w, this.h), this);
                    this.lastSearchTime = new Date().getTime();
                    f.findText((String)ptn);
                }
            } else if (ptn instanceof Pattern) {
                if (!((Pattern)ptn).isValid()) throw new IOException("Region: doFind: Image not loadable: " + ptn.toString());
                img = ((Pattern)ptn).getImage();
                this.lastSearchTime = new Date().getTime();
                f = this.checkLastSeenAndCreateFinder(img, findTimeout, (Pattern)ptn);
                if (!f.hasNext()) {
                    this.runFinder(f, ptn);
                }
            } else if (ptn instanceof Image) {
                if (!((Image)ptn).isValid()) throw new IOException("Region: doFind: Image not loadable: " + ptn.toString());
                img = (Image)ptn;
                this.lastSearchTime = new Date().getTime();
                f = this.checkLastSeenAndCreateFinder(img, findTimeout, null);
                if (!f.hasNext()) {
                    this.runFinder(f, img);
                }
            } else {
                Region.log(-1, "doFind: invalid parameter: %s", ptn);
                Sikulix.terminate(999);
            }
            if (repeating != null) {
                repeating._finder = f;
                repeating._image = img;
            }
        }
        this.lastSearchTimeRepeat = this.lastSearchTime;
        this.lastSearchTime = new Date().getTime() - this.lastSearchTime;
        this.lastFindTime = new Date().getTime() - this.lastFindTime;
        if (!f.hasNext()) return m;
        m = f.next();
        m.setTimes(this.lastFindTime, this.lastSearchTime);
        if (!Settings.FindProfiling) return m;
        Debug.logp("[FindProfiling] Region.doFind final: %d msec", this.lastSearchTime);
        return m;
    }

    private void runFinder(Finder f, Object target) {
        if (Debug.shouldHighlight() && this.scr.getW() > this.w + 20 && this.scr.getH() > this.h + 20) {
            this.highlight(2, "#000255000");
        }
        if (target instanceof Image) {
            f.find((Image)target);
        } else if (target instanceof Pattern) {
            f.find((Pattern)target);
        }
    }

    private Finder checkLastSeenAndCreateFinder(Image img, double findTimeout, Pattern ptn) {
        return this.doCheckLastSeenAndCreateFinder(null, img, findTimeout, ptn);
    }

    private Finder doCheckLastSeenAndCreateFinder(ScreenImage base, Image img, double findTimeout, Pattern ptn) {
        if (base == null) {
            base = this.getScreen().capture(this);
        }
        if (!Settings.UseImageFinder && Settings.CheckLastSeen && null != img.getLastSeen()) {
            Region r = Region.create(img.getLastSeen());
            float score = (float)(img.getLastSeenScore() - 0.01);
            if (this.contains(r)) {
                Finder f = null;
                if (this.scr instanceof VNCScreen) {
                    f = new Finder(new VNCScreen().capture(r), r);
                } else {
                    f = new Finder(base.getSub(r.getRect()), r);
                    if (Debug.shouldHighlight() && this.scr.getW() > this.w + 10 && this.scr.getH() > this.h + 10) {
                        this.highlight(2, "#000255000");
                    }
                }
                if (ptn == null) {
                    f.find(new Pattern(img).similar(score));
                } else {
                    f.find(new Pattern(ptn).similar(score));
                }
                if (f.hasNext()) {
                    Region.log(lvl, "checkLastSeen: still there", new Object[0]);
                    return f;
                }
                Region.log(lvl, "checkLastSeen: not there", new Object[0]);
            }
        }
        if (Settings.UseImageFinder) {
            ImageFinder f = new ImageFinder(this);
            f.setFindTimeout(findTimeout);
            return f;
        }
        return new Finder(base, this);
    }

    public void saveLastScreenImage() {
        ScreenImage simg = this.getScreen().getLastScreenImageFromScreen();
        if (simg != null) {
            simg.saveLastScreenImage(Region.runTime.fSikulixStore);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <PSI> Iterator<Match> doFindAll(PSI ptn, RepeatableFindAll repeating) throws IOException {
        Finder f;
        boolean findingText = false;
        ScreenImage simg = this.getScreen().capture(this.x, this.y, this.w, this.h);
        if (repeating != null && repeating._finder != null) {
            f = repeating._finder;
            f.setScreenImage(simg);
            f.setRepeating();
            f.findAllRepeat();
        } else {
            f = new Finder(simg, this);
            Image img = null;
            if (ptn instanceof String) {
                if (((String)ptn).startsWith("\t") && ((String)ptn).endsWith("\t")) {
                    findingText = true;
                } else {
                    img = Image.create((String)ptn);
                    if (img.isValid()) {
                        f.findAll(img);
                    } else {
                        if (!img.isText()) throw new IOException("Region: doFind: Image not loadable: " + (String)ptn);
                        findingText = true;
                    }
                }
                if (findingText && TextRecognizer.getInstance() != null) {
                    Region.log(lvl, "doFindAll: Switching to TextSearch", new Object[0]);
                    f.findAllText((String)ptn);
                }
            } else if (ptn instanceof Pattern) {
                if (!((Pattern)ptn).isValid()) throw new IOException("Region: doFind: Image not loadable: " + (String)ptn);
                img = ((Pattern)ptn).getImage();
                f.findAll((Pattern)ptn);
            } else if (ptn instanceof Image) {
                if (!((Image)ptn).isValid()) throw new IOException("Region: doFind: Image not loadable: " + (String)ptn);
                img = (Image)ptn;
                f.findAll((Image)ptn);
            } else {
                Region.log(-1, "doFind: invalid parameter: %s", ptn);
                Sikulix.terminate(999);
            }
            if (repeating != null) {
                repeating._finder = f;
                repeating._image = img;
            }
        }
        if (!f.hasNext()) return null;
        return f;
    }

    private <PSIMRL> Location getLocationFromTarget(PSIMRL target) throws FindFailed {
        if (target instanceof Pattern || target instanceof String || target instanceof Image) {
            Match m = this.find(target);
            if (m != null) {
                if (this.isOtherScreen()) {
                    return m.getTarget().setOtherScreen(this.scr);
                }
                return m.getTarget();
            }
            return null;
        }
        if (target instanceof Match) {
            return ((Match)target).getTarget();
        }
        if (target instanceof Region) {
            return ((Region)target).getCenter();
        }
        if (target instanceof Location) {
            return new Location((Location)target);
        }
        return null;
    }

    protected Observer getObserver() {
        if (this.regionObserver == null) {
            this.regionObserver = new Observer(this);
        }
        return this.regionObserver;
    }

    public boolean hasObserver() {
        if (this.regionObserver != null) {
            return this.regionObserver.hasObservers();
        }
        return false;
    }

    public boolean isObserving() {
        return this.observing;
    }

    public boolean hasEvents() {
        return Observing.hasEvents(this);
    }

    public ObserveEvent[] getEvents() {
        return Observing.getEvents(this);
    }

    public ObserveEvent getEvent(String name) {
        return Observing.getEvent(name);
    }

    public void setInactive(String name) {
        if (!this.hasObserver()) {
            return;
        }
        Observing.setActive(name, false);
    }

    public void setActive(String name) {
        if (!this.hasObserver()) {
            return;
        }
        Observing.setActive(name, true);
    }

    public <PSI> String onAppear(PSI target, Object observer) {
        return this.onEvent(target, observer, ObserveEvent.Type.APPEAR);
    }

    public <PSI> String onAppear(PSI target) {
        return this.onEvent(target, null, ObserveEvent.Type.APPEAR);
    }

    private <PSIC> String onEvent(PSIC targetThreshhold, Object observer, ObserveEvent.Type obsType) {
        if (observer != null && (observer.getClass().getName().contains("org.python") || observer.getClass().getName().contains("org.jruby"))) {
            observer = new ObserverCallBack(observer, obsType);
        }
        String name = Observing.add(this, (ObserverCallBack)observer, obsType, targetThreshhold);
        Region.log(lvl, "%s: observer %s %s: %s with: %s", new Object[]{this.toStringShort(), obsType, observer == null ? "" : " with callback", name, targetThreshhold});
        return name;
    }

    public <PSI> String onVanish(PSI target, Object observer) {
        return this.onEvent(target, observer, ObserveEvent.Type.VANISH);
    }

    public <PSI> String onVanish(PSI target) {
        return this.onEvent(target, null, ObserveEvent.Type.VANISH);
    }

    public String onChange(int threshold, Object observer) {
        return this.onEvent(threshold > 0 ? threshold : Settings.ObserveMinChangedPixels, observer, ObserveEvent.Type.CHANGE);
    }

    public String onChange(int threshold) {
        return this.onEvent(threshold > 0 ? threshold : Settings.ObserveMinChangedPixels, null, ObserveEvent.Type.CHANGE);
    }

    public String onChange(Object observer) {
        return this.onEvent(Settings.ObserveMinChangedPixels, observer, ObserveEvent.Type.CHANGE);
    }

    public String onChange() {
        return this.onEvent(Settings.ObserveMinChangedPixels, null, ObserveEvent.Type.CHANGE);
    }

    public String onChangeDo(int threshold, Object observer) {
        String name = Observing.add(this, (ObserverCallBack)observer, ObserveEvent.Type.CHANGE, threshold);
        Region.log(lvl, "%s: onChange%s: %s minSize: %d", this.toStringShort(), observer == null ? "" : " with callback", name, threshold);
        return name;
    }

    public boolean observe() {
        return this.observe(Double.POSITIVE_INFINITY);
    }

    public boolean observe(double secs) {
        return this.observeDo(secs);
    }

    public boolean observeJ(double secs, boolean bg) {
        if (bg) {
            return this.observeInBackground(secs);
        }
        return this.observeDo(secs);
    }

    private boolean observeDo(double secs) {
        if (this.regionObserver == null) {
            Debug.error("Region: observe: Nothing to observe (Region might be invalid): " + this.toStringShort(), new Object[0]);
            return false;
        }
        if (this.observing) {
            Debug.error("Region: observe: already running for this region. Only one allowed!", new Object[0]);
            return false;
        }
        Region.log(lvl, "observe: starting in " + this.toStringShort() + " for " + secs + " seconds", new Object[0]);
        int MaxTimePerScan = (int)(1000.0 / (double)this.observeScanRate);
        long begin_t = new Date().getTime();
        long stop_t = secs > 9.223372036854776E18 ? Long.MAX_VALUE : begin_t + (long)(secs * 1000.0);
        this.regionObserver.initialize();
        this.observing = true;
        Observing.addRunningObserver(this);
        while (this.observing && stop_t > new Date().getTime()) {
            long before_find = new Date().getTime();
            ScreenImage simg = this.getScreen().capture(this.x, this.y, this.w, this.h);
            if (!this.regionObserver.update(simg)) {
                this.observing = false;
                break;
            }
            if (!this.observing) break;
            long after_find = new Date().getTime();
            try {
                if (after_find - before_find >= (long)MaxTimePerScan) continue;
                Thread.sleep((int)((long)MaxTimePerScan - (after_find - before_find)));
            }
            catch (Exception e) {}
        }
        boolean observeSuccess = false;
        if (this.observing) {
            this.observing = false;
            Region.log(lvl, "observe: stopped due to timeout in " + this.toStringShort() + " for " + secs + " seconds", new Object[0]);
        } else {
            Region.log(lvl, "observe: ended successfully: " + this.toStringShort(), new Object[0]);
            observeSuccess = Observing.hasEvents(this);
        }
        return observeSuccess;
    }

    public boolean observeInBackground(double secs) {
        if (this.observing) {
            Debug.error("Region: observeInBackground: already running for this region. Only one allowed!", new Object[0]);
            return false;
        }
        Region.log(lvl, "entering observeInBackground for %f secs", secs);
        Thread observeThread = new Thread(new ObserverThread(secs));
        observeThread.start();
        Region.log(lvl, "observeInBackground now running", new Object[0]);
        return true;
    }

    public void stopObserver() {
        Region.log(lvl, "observe: request to stop observer for " + this.toStringShort(), new Object[0]);
        this.observing = false;
    }

    public void stopObserver(String message) {
        Debug.info(message, new Object[0]);
        this.stopObserver();
    }

    public Location checkMatch() {
        if (this.lastMatch != null) {
            return this.lastMatch.getTarget();
        }
        return this.getTarget();
    }

    public int hover() {
        try {
            return this.hover(this.checkMatch());
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public <PFRML> int hover(PFRML target) throws FindFailed {
        Region.log(lvl, "hover: " + target, new Object[0]);
        return this.mouseMove(target);
    }

    public int click() {
        try {
            return this.click(this.checkMatch(), 0);
        }
        catch (FindFailed ex) {
            return 0;
        }
    }

    public <PFRML> int click(PFRML target) throws FindFailed {
        return this.click(target, 0);
    }

    public <PFRML> int click(PFRML target, Integer modifiers) throws FindFailed {
        Location loc = this.getLocationFromTarget(target);
        int ret = Mouse.click(loc, 16, modifiers, false, this);
        return ret;
    }

    public int doubleClick() {
        try {
            return this.doubleClick(this.checkMatch(), 0);
        }
        catch (FindFailed ex) {
            return 0;
        }
    }

    public <PFRML> int doubleClick(PFRML target) throws FindFailed {
        return this.doubleClick(target, 0);
    }

    public <PFRML> int doubleClick(PFRML target, Integer modifiers) throws FindFailed {
        Location loc = this.getLocationFromTarget(target);
        int ret = Mouse.click(loc, 16, modifiers, true, this);
        return ret;
    }

    public int rightClick() {
        try {
            return this.rightClick(this.checkMatch(), 0);
        }
        catch (FindFailed ex) {
            return 0;
        }
    }

    public <PFRML> int rightClick(PFRML target) throws FindFailed {
        return this.rightClick(target, 0);
    }

    public <PFRML> int rightClick(PFRML target, Integer modifiers) throws FindFailed {
        Location loc = this.getLocationFromTarget(target);
        int ret = Mouse.click(loc, 4, modifiers, false, this);
        return ret;
    }

    public void delayClick(int millisecs) {
        Settings.ClickDelay = millisecs;
    }

    public <PFRML> int dragDrop(PFRML target) throws FindFailed {
        return this.dragDrop(this.lastMatch, target);
    }

    public <PFRML> int dragDrop(PFRML t1, PFRML t2) throws FindFailed {
        Location loc1 = this.getLocationFromTarget(t1);
        Location loc2 = this.getLocationFromTarget(t2);
        int retVal = 0;
        if (loc1 != null && loc2 != null) {
            IRobot r1 = loc1.getRobotForPoint("drag");
            IRobot r2 = loc2.getRobotForPoint("drop");
            if (r1 != null && r2 != null) {
                Mouse.use(this);
                r1.smoothMove(loc1);
                r1.delay((int)(Settings.DelayBeforeMouseDown * 1000.0));
                r1.mouseDown(16);
                double DelayBeforeDrag = Settings.DelayBeforeDrag;
                if (DelayBeforeDrag < 0.0) {
                    DelayBeforeDrag = Settings.DelayAfterDrag;
                }
                r1.delay((int)(DelayBeforeDrag * 1000.0));
                r2.smoothMove(loc2);
                r2.delay((int)(Settings.DelayBeforeDrop * 1000.0));
                r2.mouseUp(16);
                Mouse.let(this);
                retVal = 1;
            }
        }
        Settings.DelayBeforeMouseDown = Settings.DelayValue;
        Settings.DelayAfterDrag = Settings.DelayValue;
        Settings.DelayBeforeDrag = -Settings.DelayValue;
        Settings.DelayBeforeDrop = Settings.DelayValue;
        return retVal;
    }

    public <PFRML> int drag(PFRML target) throws FindFailed {
        IRobot r;
        Location loc = this.getLocationFromTarget(target);
        int retVal = 0;
        if (loc != null && (r = loc.getRobotForPoint("drag")) != null) {
            Mouse.use(this);
            r.smoothMove(loc);
            r.delay((int)(Settings.DelayBeforeMouseDown * 1000.0));
            r.mouseDown(16);
            double DelayBeforeDrag = Settings.DelayBeforeDrag;
            if (DelayBeforeDrag < 0.0) {
                DelayBeforeDrag = Settings.DelayAfterDrag;
            }
            r.delay((int)(DelayBeforeDrag * 1000.0));
            r.waitForIdle();
            Mouse.let(this);
            retVal = 1;
        }
        Settings.DelayBeforeMouseDown = Settings.DelayValue;
        Settings.DelayAfterDrag = Settings.DelayValue;
        Settings.DelayBeforeDrag = -Settings.DelayValue;
        Settings.DelayBeforeDrop = Settings.DelayValue;
        return retVal;
    }

    public <PFRML> int dropAt(PFRML target) throws FindFailed {
        IRobot r;
        Location loc = this.getLocationFromTarget(target);
        int retVal = 0;
        if (loc != null && (r = loc.getRobotForPoint("drag")) != null) {
            Mouse.use(this);
            r.smoothMove(loc);
            r.delay((int)(Settings.DelayBeforeDrop * 1000.0));
            r.mouseUp(16);
            r.waitForIdle();
            Mouse.let(this);
            retVal = 1;
        }
        Settings.DelayBeforeMouseDown = Settings.DelayValue;
        Settings.DelayAfterDrag = Settings.DelayValue;
        Settings.DelayBeforeDrag = -Settings.DelayValue;
        Settings.DelayBeforeDrop = Settings.DelayValue;
        return retVal;
    }

    public void mouseDown(int buttons) {
        Mouse.down(buttons, this);
    }

    public void mouseUp() {
        Mouse.up(0, this);
    }

    public void mouseUp(int buttons) {
        Mouse.up(buttons, this);
    }

    public int mouseMove() {
        if (this.lastMatch != null) {
            try {
                return this.mouseMove(this.lastMatch);
            }
            catch (FindFailed ex) {
                return 0;
            }
        }
        return 0;
    }

    public <PFRML> int mouseMove(PFRML target) throws FindFailed {
        Location loc = this.getLocationFromTarget(target);
        return Mouse.move(loc, this);
    }

    public int mouseMove(int xoff, int yoff) {
        try {
            return this.mouseMove(Mouse.at().offset(xoff, yoff));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int wheel(int direction, int steps) {
        Mouse.wheel(direction, steps, this);
        return 1;
    }

    public <PFRML> int wheel(PFRML target, int direction, int steps) throws FindFailed {
        return this.wheel(target, direction, steps, 50);
    }

    public <PFRML> int wheel(PFRML target, int direction, int steps, int stepDelay) throws FindFailed {
        Location loc = this.getLocationFromTarget(target);
        if (loc != null) {
            Mouse.use(this);
            Mouse.keep(this);
            Mouse.move(loc, this);
            Mouse.wheel(direction, steps, this, stepDelay);
            Mouse.let(this);
            return 1;
        }
        return 0;
    }

    @Deprecated
    public static Location atMouse() {
        return Mouse.at();
    }

    public void keyDown(int keycode) {
        this.getRobotForRegion().keyDown(keycode);
    }

    public void keyDown(String keys) {
        this.getRobotForRegion().keyDown(keys);
    }

    public void keyUp() {
        this.getRobotForRegion().keyUp();
    }

    public void keyUp(int keycode) {
        this.getRobotForRegion().keyUp(keycode);
    }

    public void keyUp(String keys) {
        this.getRobotForRegion().keyUp(keys);
    }

    public int write(String text) {
        Debug.info("Write: " + text, new Object[0]);
        String modifier = "";
        IRobot robot = this.getRobotForRegion();
        int pause = 20 + (Settings.TypeDelay > 1.0 ? 1000 : (int)(Settings.TypeDelay * 1000.0));
        Settings.TypeDelay = 0.0;
        robot.typeStarts();
        for (int i = 0; i < text.length(); ++i) {
            int n;
            Region.log(lvl + 1, "write: (%d) %s", i, text.substring(i));
            char c = text.charAt(i);
            String token = null;
            boolean isModifier = false;
            if (c == '#') {
                if (text.charAt(i + 1) == '#') {
                    Region.log(3, "write at: %d: %s", i, Character.valueOf(c));
                    ++i;
                    continue;
                }
                if (text.charAt(i + 2) == '+' || text.charAt(i + 2) == '-') {
                    token = text.substring(i, i + 3);
                    isModifier = true;
                } else {
                    int k = text.indexOf(46, i);
                    if (-1 < k && k > -1 && ((token = text.substring(i, k + 1)).length() > Key.keyMaxLength || token.substring(1).contains("#"))) {
                        token = null;
                    }
                }
            }
            Integer key = -1;
            if (token == null) {
                Region.log(lvl + 1, "write: %d: %s", i, Character.valueOf(c));
            } else {
                Region.log(lvl + 1, "write: token at %d: %s", i, token);
                int repeat = 0;
                if (token.toUpperCase().startsWith("#W") && token.length() > 3) {
                    i += token.length() - 1;
                    int t = 0;
                    try {
                        t = Integer.parseInt(token.substring(2, token.length() - 1));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    if (token.startsWith("#w") && t > 60) {
                        pause = 20 + (t > 1000 ? 1000 : t);
                        Region.log(lvl + 1, "write: type delay: " + t, new Object[0]);
                        continue;
                    }
                    Region.log(lvl + 1, "write: wait: " + t, new Object[0]);
                    robot.delay(t < 60 ? t * 1000 : t);
                    continue;
                }
                String tokenSave = token;
                if (Key.isRepeatable(token = token.substring(0, 2).toUpperCase() + ".")) {
                    try {
                        repeat = Integer.parseInt(tokenSave.substring(2, tokenSave.length() - 1));
                    }
                    catch (NumberFormatException ex) {
                        token = tokenSave;
                    }
                } else {
                    if (tokenSave.length() == 3 && Key.isModifier(tokenSave.toUpperCase())) {
                        i += tokenSave.length() - 1;
                        modifier = modifier + tokenSave.substring(1, 2).toUpperCase();
                        continue;
                    }
                    token = tokenSave;
                }
                if (-1 < (key = Integer.valueOf(Key.toJavaKeyCodeFromText(token)))) {
                    if (repeat > 0) {
                        Region.log(lvl + 1, "write: %s Repeating: %d", token, repeat);
                    } else {
                        Region.log(lvl + 1, "write: %s", tokenSave);
                        repeat = 1;
                    }
                    i += tokenSave.length() - 1;
                    if (isModifier) {
                        if (tokenSave.endsWith("+")) {
                            robot.keyDown(key);
                            continue;
                        }
                        robot.keyUp(key);
                        continue;
                    }
                    if (repeat > 1) {
                        for (int n2 = 0; n2 < repeat; ++n2) {
                            robot.typeKey(key);
                        }
                        continue;
                    }
                }
            }
            if (!modifier.isEmpty()) {
                Region.log(lvl + 1, "write: modifier + " + modifier, new Object[0]);
                for (n = 0; n < modifier.length(); ++n) {
                    robot.keyDown(Key.toJavaKeyCodeFromText(String.format("#%s.", modifier.substring(n, n + 1))));
                }
            }
            if (key > -1) {
                robot.typeKey(key);
            } else {
                robot.typeChar(c, IRobot.KeyMode.PRESS_RELEASE);
            }
            if (!modifier.isEmpty()) {
                Region.log(lvl + 1, "write: modifier - " + modifier, new Object[0]);
                for (n = 0; n < modifier.length(); ++n) {
                    robot.keyUp(Key.toJavaKeyCodeFromText(String.format("#%s.", modifier.substring(n, n + 1))));
                }
            }
            robot.delay(pause);
            modifier = "";
        }
        robot.typeEnds();
        robot.waitForIdle();
        return 0;
    }

    public int type(String text) {
        try {
            return this.keyin(null, text, 0);
        }
        catch (FindFailed ex) {
            return 0;
        }
    }

    public int type(String text, int modifiers) {
        try {
            return this.keyin(null, text, modifiers);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public int type(String text, String modifiers) {
        String target = null;
        int modifiersNew = Key.convertModifiers(modifiers);
        if (modifiersNew == 0) {
            target = text;
            text = modifiers;
        }
        try {
            return this.keyin(target, text, modifiersNew);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public <PFRML> int type(PFRML target, String text) throws FindFailed {
        return this.keyin(target, text, 0);
    }

    public <PFRML> int type(PFRML target, String text, int modifiers) throws FindFailed {
        return this.keyin(target, text, modifiers);
    }

    public <PFRML> int type(PFRML target, String text, String modifiers) throws FindFailed {
        int modifiersNew = Key.convertModifiers(modifiers);
        return this.keyin(target, text, modifiersNew);
    }

    private <PFRML> int keyin(PFRML target, String text, int modifiers) throws FindFailed {
        if (target != null && 0 == this.click(target, 0)) {
            return 0;
        }
        Debug profiler = Debug.startTimer("Region.type", new Object[0]);
        if (text != null && !"".equals(text)) {
            String showText = "";
            for (int i = 0; i < text.length(); ++i) {
                showText = showText + Key.toJavaKeyCodeText(text.charAt(i));
            }
            String modText = "";
            String modWindows = null;
            if ((modifiers & 0x40) != 0) {
                modifiers -= 64;
                modifiers |= 4;
                Region.log(lvl, "Key.WIN as modifier", new Object[0]);
                modWindows = "Windows";
            }
            if (modifiers != 0) {
                modText = String.format("( %s ) ", KeyEvent.getKeyModifiersText(modifiers));
                if (modWindows != null) {
                    modText = modText.replace("Meta", modWindows);
                }
            }
            Debug.action("%s TYPE \"%s\"", modText, showText);
            Region.log(lvl, "%s TYPE \"%s\"", modText, showText);
            profiler.lap("before getting Robot");
            IRobot r = this.getRobotForRegion();
            int pause = 20 + (Settings.TypeDelay > 1.0 ? 1000 : (int)(Settings.TypeDelay * 1000.0));
            Settings.TypeDelay = 0.0;
            profiler.lap("before typing");
            r.typeStarts();
            for (int i = 0; i < text.length(); ++i) {
                r.pressModifiers(modifiers);
                r.typeChar(text.charAt(i), IRobot.KeyMode.PRESS_RELEASE);
                r.releaseModifiers(modifiers);
                r.delay(pause);
            }
            r.typeEnds();
            profiler.lap("after typing, before waitForIdle");
            r.waitForIdle();
            profiler.end();
            return 1;
        }
        return 0;
    }

    public void delayType(int millisecs) {
        Settings.TypeDelay = millisecs;
    }

    public int paste(String text) {
        try {
            return this.paste(null, text);
        }
        catch (FindFailed ex) {
            return 1;
        }
    }

    public <PFRML> int paste(PFRML target, String text) throws FindFailed {
        if (target != null) {
            this.click(target, 0);
        }
        if (text != null) {
            App.setClipboard(text);
            int mod = Key.getHotkeyModifier();
            IRobot r = this.getRobotForRegion();
            r.keyDown(mod);
            r.keyDown(86);
            r.keyUp(86);
            r.keyUp(mod);
            return 1;
        }
        return 0;
    }

    public String text() {
        if (Settings.OcrTextRead) {
            ScreenImage simg = this.getScreen().capture(this.x, this.y, this.w, this.h);
            TextRecognizer tr = TextRecognizer.getInstance();
            if (tr == null) {
                Debug.error("text: text recognition is now switched off", new Object[0]);
                return "--- no text ---";
            }
            String textRead = tr.recognize(simg);
            Region.log(lvl, "text: #(" + textRead + ")#", new Object[0]);
            return textRead;
        }
        Debug.error("text: text recognition is currently switched off", new Object[0]);
        return "--- no text ---";
    }

    public List<Match> listText() {
        if (Settings.OcrTextRead) {
            ScreenImage simg = this.getScreen().capture(this.x, this.y, this.w, this.h);
            TextRecognizer tr = TextRecognizer.getInstance();
            if (tr == null) {
                Debug.error("text: text recognition is now switched off", new Object[0]);
                return null;
            }
            Region.log(lvl, "listText: scanning %s", this);
            return tr.listText(simg, this);
        }
        Debug.error("text: text recognition is currently switched off", new Object[0]);
        return null;
    }

    public String saveScreenCapture() {
        return this.getScreen().capture(this).save();
    }

    public String saveScreenCapture(String path) {
        return this.getScreen().capture(this).save(path);
    }

    public String saveScreenCapture(String path, String name) {
        return this.getScreen().capture(this).save(path, name);
    }

    private class ObserverThread
    implements Runnable {
        private double time;

        ObserverThread(double time) {
            this.time = time;
        }

        @Override
        public void run() {
            Region.this.observe(this.time);
        }
    }

    private class RepeatableFindAll
    extends Repeatable {
        Object _target;
        Iterator<Match> _matches;
        Finder _finder;
        Image _image;

        public <PSI> RepeatableFindAll(PSI target) {
            this._matches = null;
            this._finder = null;
            this._image = null;
            this._target = target;
        }

        public Iterator<Match> getMatches() {
            return this._matches;
        }

        @Override
        public void run() throws IOException {
            this._matches = Region.this.doFindAll(this._target, this);
        }

        @Override
        boolean ifSuccessful() {
            return this._matches != null;
        }
    }

    private class RepeatableVanish
    extends RepeatableFind {
        public <PSI> RepeatableVanish(PSI target) {
            super(target);
        }

        @Override
        boolean ifSuccessful() {
            return this._match == null;
        }
    }

    private class RepeatableFind
    extends Repeatable {
        Object _target;
        Match _match;
        Finder _finder;
        Image _image;

        public <PSI> RepeatableFind(PSI target) {
            this._match = null;
            this._finder = null;
            this._image = null;
            this._target = target;
        }

        public Match getMatch() {
            if (this._finder != null) {
                this._finder.destroy();
            }
            return this._match == null ? this._match : new Match(this._match);
        }

        @Override
        public void run() throws IOException {
            this._match = Region.this.doFind(this._target, this);
        }

        @Override
        boolean ifSuccessful() {
            return this._match != null;
        }
    }

    private abstract class Repeatable {
        private double findTimeout;

        private Repeatable() {
        }

        abstract void run() throws Exception;

        abstract boolean ifSuccessful();

        double getFindTimeOut() {
            return this.findTimeout;
        }

        boolean repeat(double timeout) throws Exception {
            this.findTimeout = timeout;
            int MaxTimePerScan = (int)(1000.0 / (double)Region.this.waitScanRate);
            int timeoutMilli = (int)(timeout * 1000.0);
            long begin_t = new Date().getTime();
            do {
                long before_find = new Date().getTime();
                this.run();
                if (this.ifSuccessful()) {
                    return true;
                }
                if (timeoutMilli < MaxTimePerScan || Settings.UseImageFinder) {
                    return false;
                }
                long after_find = new Date().getTime();
                if (after_find - before_find < (long)MaxTimePerScan) {
                    Region.this.getRobotForRegion().delay((int)((long)MaxTimePerScan - (after_find - before_find)));
                    continue;
                }
                Region.this.getRobotForRegion().delay(10);
            } while ((double)begin_t + timeout * 1000.0 > (double)new Date().getTime());
            return false;
        }
    }

    private class SubFindRun
    implements Runnable {
        Match[] mArray;
        ScreenImage base;
        Object target;
        Region reg;
        boolean finished = false;
        int subN;

        public SubFindRun(Match[] pMArray, int pSubN, ScreenImage pBase, Object pTarget, Region pReg) {
            this.subN = pSubN;
            this.base = pBase;
            this.target = pTarget;
            this.reg = pReg;
            this.mArray = pMArray;
        }

        @Override
        public void run() {
            try {
                this.mArray[this.subN] = this.reg.findInImage(this.base, this.target);
            }
            catch (Exception ex) {
                Region.log(-1, "findAnyCollect: image file not found:\n", new Object[]{this.target});
            }
            this.hasFinished(true);
        }

        public boolean hasFinished() {
            return this.hasFinished(false);
        }

        public synchronized boolean hasFinished(boolean state) {
            if (state) {
                this.finished = true;
            }
            return this.finished;
        }
    }
}

