/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Key;
import org.sikuli.script.Location;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenRemote;

public class RobotRemote
implements IRobot {
    private static int heldButtons = 0;
    private static String heldKeys = "";
    private static ArrayList<Integer> heldKeyCodes = new ArrayList();
    private ScreenRemote scr = null;
    private static final String key = "KEY";
    private static final String mouse = "MOUSE";
    private static final String capture = "CAPTURE";
    private static final String kType = "TYPE";
    private static final String mClick = "CLICK";
    private static final String mMove = "MOVE";
    private static final String cSystem = "SYSTEM";
    private static final String cBounds = "BOUNDS";
    private String clickCommand = null;
    private String typeCommand = null;
    private String result;
    private String system = "";
    private int numberScreens = 0;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "RobotRemote: " + message, args);
    }

    private static void log(String message, Object ... args) {
        RobotRemote.log(3, message, args);
    }

    public RobotRemote(ScreenRemote sr) {
        this.init(sr);
    }

    public RobotRemote() {
        this.init(null);
    }

    private void init(ScreenRemote sr) {
        if (sr == null || !sr.isValid()) {
            RobotRemote.log(-1, "RobotRemote: must be created with valid ScreenRemote - not useable", new Object[0]);
        }
        this.scr = sr;
        String sys = (String)this.send(cSystem);
        if (sys == null || !sys.contains(" ")) {
            RobotRemote.log(-1, "could not get remote system - robot might not be useable: " + sys, new Object[0]);
        } else {
            this.system = sys.substring(0, sys.indexOf(" "));
            try {
                this.numberScreens = Integer.parseInt(sys.substring(sys.indexOf(" ") + 1));
            }
            catch (Exception ex) {
                RobotRemote.log(-1, "could not get remote numberScreens - robot might not be useable: " + sys, new Object[0]);
            }
        }
    }

    public boolean isValid() {
        return this.scr != null;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    public String getSystem() {
        return this.system;
    }

    public int getNumberScreens() {
        return this.numberScreens;
    }

    public Rectangle getBounds() {
        return this.getBounds(0);
    }

    public Rectangle getBounds(int screenID) {
        return (Rectangle)this.send("BOUNDS " + screenID);
    }

    @Override
    public void keyDown(String keys) {
        if (keys != null && !"".equals(keys)) {
            for (int i = 0; i < keys.length(); ++i) {
                if (heldKeys.indexOf(keys.charAt(i)) != -1) continue;
                Debug.log(5, "press: " + keys.charAt(i), new Object[0]);
                this.typeChar(keys.charAt(i), IRobot.KeyMode.PRESS_ONLY);
                heldKeys = heldKeys + keys.charAt(i);
            }
            this.waitForIdle();
        }
    }

    @Override
    public void keyUp(String keys) {
        if (keys != null && !"".equals(keys)) {
            for (int i = 0; i < keys.length(); ++i) {
                int pos = heldKeys.indexOf(keys.charAt(i));
                if (pos == -1) continue;
                Debug.log(5, "release: " + keys.charAt(i), new Object[0]);
                this.typeChar(keys.charAt(i), IRobot.KeyMode.RELEASE_ONLY);
                heldKeys = heldKeys.substring(0, pos) + heldKeys.substring(pos + 1);
            }
            this.waitForIdle();
        }
    }

    @Override
    public void keyDown(int code) {
        if (!heldKeyCodes.contains(code)) {
            this.keyPress(code);
            heldKeyCodes.add(code);
        }
        this.waitForIdle();
    }

    @Override
    public void keyUp(int code) {
        if (heldKeyCodes.contains(code)) {
            this.keyRelease(code);
            heldKeyCodes.remove((Object)code);
        }
        this.waitForIdle();
    }

    @Override
    public void keyUp() {
        this.keyUp(heldKeys);
        for (int code : heldKeyCodes) {
            this.keyUp(code);
        }
    }

    @Override
    public void pressModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.keyPress(16);
        }
        if ((modifiers & 2) != 0) {
            this.keyPress(17);
        }
        if ((modifiers & 8) != 0) {
            this.keyPress(18);
        }
        if ((modifiers & 4) != 0) {
            if (Settings.isWindows()) {
                this.keyPress(524);
            } else {
                this.keyPress(157);
            }
        }
    }

    @Override
    public void releaseModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.keyRelease(16);
        }
        if ((modifiers & 2) != 0) {
            this.keyRelease(17);
        }
        if ((modifiers & 8) != 0) {
            this.keyRelease(18);
        }
        if ((modifiers & 4) != 0) {
            if ("WINDOWS".equals(this.system)) {
                this.keyRelease(524);
            } else {
                this.keyRelease(157);
            }
        }
    }

    @Override
    public void typeChar(char character, IRobot.KeyMode mode) {
        RobotRemote.log(3, "doType: %s ( %d )", KeyEvent.getKeyText(Key.toJavaKeyCode(character)[0]).toString(), Key.toJavaKeyCode(character)[0]);
        this.doType(mode, Key.toJavaKeyCode(character));
    }

    @Override
    public void typeKey(int key) {
        if ("MAC".equals(this.system)) {
            if (key == Key.toJavaKeyCodeFromText("#N.")) {
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#C."));
                this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#C."));
            } else if (key == Key.toJavaKeyCodeFromText("#T.")) {
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#C."));
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#A."));
                this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#A."));
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#C."));
            } else if (key == Key.toJavaKeyCodeFromText("#X.")) {
                key = Key.toJavaKeyCodeFromText("#T.");
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#A."));
                this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#A."));
            }
        } else {
            this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
        }
        RobotRemote.log(3, "doType: %s ( %d )", KeyEvent.getKeyText(key), key);
    }

    private void doType(IRobot.KeyMode mode, int ... keyCodes) {
        if (mode == IRobot.KeyMode.PRESS_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.keyPress(keyCodes[i]);
            }
        } else if (mode == IRobot.KeyMode.RELEASE_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.keyRelease(keyCodes[i]);
            }
        } else {
            int i;
            for (i = 0; i < keyCodes.length; ++i) {
                this.keyPress(keyCodes[i]);
            }
            for (i = 0; i < keyCodes.length; ++i) {
                this.keyRelease(keyCodes[i]);
            }
        }
    }

    @Override
    public void typeStarts() {
        this.typeCommand = kType;
    }

    @Override
    public void typeEnds() {
        this.result = (String)this.send(this.typeCommand);
        this.typeCommand = null;
    }

    private void keyPress(int key) {
        if (this.typeCommand == null && this.clickCommand == null) {
            this.result = (String)this.send(String.format("%s %d ", key, key));
        } else if (this.typeCommand != null) {
            this.typeCommand = this.typeCommand + " P" + key;
        } else {
            this.clickCommand = this.clickCommand + " P" + key;
        }
    }

    private void keyRelease(int k) {
        if (this.typeCommand == null && this.clickCommand == null) {
            this.result = (String)this.send(String.format("%s %d ", key, k));
        } else if (this.typeCommand != null) {
            this.typeCommand = this.typeCommand + " R" + k;
        } else {
            this.clickCommand = this.clickCommand + " R" + k;
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        this.result = (String)this.send(String.format("%s %d %d", mMove, x, y));
    }

    @Override
    public void clickStarts() {
        this.typeCommand = null;
        this.clickCommand = mClick;
    }

    @Override
    public void clickEnds() {
        this.result = (String)this.send(this.clickCommand);
        this.clickCommand = null;
    }

    public Location mousePointer() {
        return new Location((Point)this.send(mouse));
    }

    @Override
    public void mouseDown(int buttons) {
        heldButtons = heldButtons != 0 ? (heldButtons |= buttons) : buttons;
        if (this.clickCommand == null) {
            this.result = (String)this.send(String.format("%s D%d", mouse, heldButtons));
        } else {
            this.clickCommand = this.clickCommand + " D" + heldButtons;
        }
    }

    @Override
    public int mouseUp(int buttons) {
        int bAfter;
        if (buttons == 0) {
            buttons = heldButtons;
            bAfter = 0;
        } else {
            bAfter = heldButtons & ~buttons;
        }
        if (this.clickCommand == null) {
            this.result = (String)this.send(String.format("%s U%d", mouse, buttons));
        } else {
            this.clickCommand = this.clickCommand + " U" + buttons;
        }
        heldButtons = bAfter;
        return heldButtons;
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ScreenImage captureScreen(Rectangle r) {
        ImageIcon img = (ImageIcon)this.send(String.format("CAPTURE %d %d %d %d", r.x, r.y, r.width, r.height));
        ScreenImage simg = null;
        if (img != null) {
            BufferedImage bimg = new BufferedImage(img.getIconWidth(), img.getIconHeight(), 6);
            bimg.getGraphics().drawImage(img.getImage(), 0, 0, null);
            simg = new ScreenImage(new Rectangle(r.x, r.y, img.getIconWidth(), img.getIconHeight()), bimg);
        }
        return simg;
    }

    @Override
    public void smoothMove(Location dest) {
        this.mouseMove(dest.x, dest.y);
    }

    @Override
    public void smoothMove(Location src, Location dest, long ms) {
        this.mouseMove(src.x, src.y);
        this.delay((int)ms);
        this.mouseMove(dest.x, dest.y);
    }

    @Override
    public void delay(int ms) {
        if (this.clickCommand != null) {
            this.clickCommand = this.clickCommand + " W" + ms;
        } else if (this.typeCommand != null) {
            this.typeCommand = this.typeCommand + " W" + ms;
        }
    }

    @Override
    public void setAutoDelay(int ms) {
    }

    @Override
    public Color getColorAt(int x, int y) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cleanup() {
        this.mouseUp(0);
        this.keyUp();
    }

    @Override
    public IScreen getScreen() {
        return this.scr;
    }

    public Object send(String command) {
        if (!this.scr.isValid()) {
            RobotRemote.log(-1, "ScreenRemote not valid - send not possible", new Object[0]);
            return null;
        }
        Object res = null;
        try {
            this.scr.getOut().write(command + "\n");
            this.scr.getOut().flush();
            RobotRemote.log("send: " + command, new Object[0]);
            res = this.scr.getIn().readObject();
            if (res == null) {
                RobotRemote.log(-1, "command not successful: " + command, new Object[0]);
                return null;
            }
            if (command.startsWith(capture)) {
                if (!res.getClass().equals(ImageIcon.class)) {
                    RobotRemote.log(-1, "CAPTURE: received: " + res, new Object[0]);
                    res = null;
                }
            } else if (command.startsWith(cBounds)) {
                if (!res.getClass().equals(Rectangle.class)) {
                    RobotRemote.log(-1, "BOUNDS: received: " + res, new Object[0]);
                    res = null;
                }
            } else if (command.equals(mouse)) {
                if (!res.getClass().equals(Point.class)) {
                    RobotRemote.log(-1, "MOUSE: received: " + res, new Object[0]);
                    res = null;
                }
            } else if (!res.getClass().equals(String.class)) {
                RobotRemote.log(-1, "OTHER: received: " + res, new Object[0]);
                res = null;
            }
        }
        catch (Exception ex) {
            if (command.startsWith("EXIT")) {
                return "ok";
            }
            RobotRemote.log(-1, "fatal: while processing:\n" + ex.getMessage(), new Object[0]);
        }
        return res;
    }

    @Override
    public void waitForIdle() {
    }
}

