/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.ImagePath;
import org.sikuli.script.RunTime;

public class ScreenImage {
    public int x;
    public int y;
    public int w;
    public int h;
    protected Rectangle _roi;
    protected BufferedImage _img;
    protected String _filename = null;

    public ScreenImage(Rectangle roi, BufferedImage img) {
        this._img = img;
        this._roi = roi;
        this.x = (int)roi.getX();
        this.y = (int)roi.getY();
        this.w = (int)roi.getWidth();
        this.h = (int)roi.getHeight();
    }

    public ScreenImage getSub(Rectangle sub) {
        if (!this._roi.contains(sub)) {
            return this;
        }
        BufferedImage img = this._img.getSubimage(sub.x - this.x, sub.y - this.y, sub.width, sub.height);
        return new ScreenImage(sub, img);
    }

    @Deprecated
    public String getFilename() throws IOException {
        return this.getFile();
    }

    public String getFile() {
        if (this._filename == null) {
            this._filename = this.save();
        }
        return this._filename;
    }

    public String save() {
        return FileManager.saveTimedImage(this._img, RunTime.get().fpBaseTempPath, "sikuliximage");
    }

    public String getFile(String path) {
        return this.save(path);
    }

    public String save(String path) {
        return FileManager.saveTimedImage(this._img, path, "sikuliximage");
    }

    public String save(String path, String name) {
        return FileManager.saveTimedImage(this._img, path, name);
    }

    public String getFile(String path, String name) {
        if (name == null) {
            name = Settings.getTimestamp() + ".png";
        } else if (!name.endsWith(".png")) {
            name = name + ".png";
        }
        try {
            File tmp = new File(path, name);
            this.createFile(tmp);
            Debug.log(3, "ScreenImage.getFile:\n%s", tmp);
        }
        catch (IOException iOException) {
            Debug.error("ScreenImage.getFile: IOException", iOException);
            return null;
        }
        return this._filename;
    }

    public String saveInBundle(String name) {
        if (!name.endsWith(".png")) {
            name = name + ".png";
        }
        if (!name.startsWith("_")) {
            name = "_" + name;
        }
        File fImage = new File(name);
        try {
            fImage = new File(ImagePath.getBundlePath(), name);
            this.createFile(fImage);
            Debug.log(3, "ScreenImage.saveInBundle:\n%s", fImage);
        }
        catch (IOException iOException) {
            Debug.error("ScreenImage.saveInBundle: IOException", iOException);
            return null;
        }
        return fImage.getAbsolutePath();
    }

    private void createFile(File tmp) throws IOException {
        String filename = tmp.getAbsolutePath();
        if (this._filename == null || !filename.equals(this._filename) || tmp.getName().startsWith("_")) {
            ImageIO.write((RenderedImage)this._img, "png", tmp);
            this._filename = filename;
        }
    }

    public BufferedImage getImage() {
        return this._img;
    }

    public Rectangle getROI() {
        return this._roi;
    }

    public void saveLastScreenImage(File fPath) {
        try {
            ImageIO.write((RenderedImage)this._img, "png", new File(fPath, "LastScreenImage.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

