/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RescaleOp;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.natives.SysUtil;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.RunTime;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenUnion;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;
import org.sikuli.util.OverlayTransparentWindow;

public class OverlayCapturePrompt
extends OverlayTransparentWindow
implements EventSubject {
    static final float MIN_DARKER_FACTOR = 0.6f;
    static final long MSG_DISPLAY_TIME = 2000L;
    static final long WIN_FADE_IN_TIME = 200L;
    static final Font fontMsg = new Font("Arial", 0, 60);
    static final Color selFrameColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    static final Color selCrossColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    static final Color screenFrameColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    private Rectangle screenFrame = null;
    static final BasicStroke strokeScreenFrame = new BasicStroke(5.0f);
    static final BasicStroke _StrokeCross = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    static final BasicStroke bs = new BasicStroke(1.0f);
    private EventObserver obs;
    private IScreen scrOCP;
    private BufferedImage scr_img = null;
    private BufferedImage scr_img_darker = null;
    private BufferedImage bi = null;
    private float darker_factor;
    private Rectangle rectSelection;
    private int srcScreenId = 0;
    private Location srcScreenLocation = null;
    private Location destScreenLocation = null;
    private int srcx;
    private int srcy;
    private int destx;
    private int desty;
    private boolean canceled = false;
    private String promptMsg;
    private boolean didPurgeMessage = false;
    private boolean dragging = false;

    public OverlayCapturePrompt(IScreen scr, EventObserver ob) {
        this.init(scr, ob);
    }

    private void init(IScreen scr, EventObserver ob) {
        this.addObserver(ob);
        this.scrOCP = RunTime.get().isOSX10() ? scr : (Screen.getNumberScreens() > 1 ? new ScreenUnion() : Screen.getPrimaryScreen());
        this.canceled = false;
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.rectSelection = new Rectangle();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (OverlayCapturePrompt.this.promptMsg == null) {
                    return;
                }
                OverlayCapturePrompt.this.promptMsg = null;
                OverlayCapturePrompt.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (OverlayCapturePrompt.this.scr_img == null) {
                    return;
                }
                if (OverlayCapturePrompt.this.promptMsg != null) {
                    OverlayCapturePrompt.this.promptMsg = null;
                    OverlayCapturePrompt.this.didPurgeMessage = true;
                }
                OverlayCapturePrompt.this.destx = (OverlayCapturePrompt.this.srcx = e.getX());
                OverlayCapturePrompt.this.desty = (OverlayCapturePrompt.this.srcy = e.getY());
                OverlayCapturePrompt.this.srcScreenId = OverlayCapturePrompt.this.scrOCP.getIdFromPoint(OverlayCapturePrompt.this.srcx, OverlayCapturePrompt.this.srcy);
                OverlayCapturePrompt.this.srcScreenLocation = new Location(OverlayCapturePrompt.this.srcx + OverlayCapturePrompt.this.scrOCP.getX(), OverlayCapturePrompt.this.srcy + OverlayCapturePrompt.this.scrOCP.getY());
                Debug.log(4, "CapturePrompt: started at (%d,%d) as %s on %d", OverlayCapturePrompt.this.srcx, OverlayCapturePrompt.this.srcy, OverlayCapturePrompt.this.srcScreenLocation.toStringShort(), OverlayCapturePrompt.this.srcScreenId);
                OverlayCapturePrompt.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (OverlayCapturePrompt.this.scr_img == null) {
                    return;
                }
                if (!OverlayCapturePrompt.this.dragging && OverlayCapturePrompt.this.didPurgeMessage) {
                    OverlayCapturePrompt.this.didPurgeMessage = false;
                    return;
                }
                if (e.getButton() == 3) {
                    OverlayCapturePrompt.this.canceled = true;
                    Debug.log(3, "CapturePrompt: aborted using right mouse button", new Object[0]);
                } else {
                    OverlayCapturePrompt.this.destScreenLocation = new Location(OverlayCapturePrompt.this.destx + OverlayCapturePrompt.this.scrOCP.getX(), OverlayCapturePrompt.this.desty + OverlayCapturePrompt.this.scrOCP.getY());
                    Debug.log(4, "CapturePrompt: finished at (%d,%d) as %s on %d", OverlayCapturePrompt.this.destx, OverlayCapturePrompt.this.desty, OverlayCapturePrompt.this.destScreenLocation.toStringShort(), OverlayCapturePrompt.this.srcScreenId);
                }
                OverlayCapturePrompt.this.setVisible(false);
                OverlayCapturePrompt.this.notifyObserver();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (OverlayCapturePrompt.this.scr_img == null) {
                    return;
                }
                OverlayCapturePrompt.this.dragging = true;
                OverlayCapturePrompt.this.destx = e.getX();
                OverlayCapturePrompt.this.desty = e.getY();
                OverlayCapturePrompt.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    if (OverlayCapturePrompt.this.promptMsg != null) {
                        OverlayCapturePrompt.this.promptMsg = null;
                        OverlayCapturePrompt.this.repaint();
                        return;
                    }
                    OverlayCapturePrompt.this.canceled = true;
                    Debug.log(3, "CapturePrompt: aborted using key ESC", new Object[0]);
                    OverlayCapturePrompt.this.setVisible(false);
                    OverlayCapturePrompt.this.notifyObserver();
                }
            }
        });
    }

    @Override
    public void close() {
        Debug.log(4, "CapturePrompt.close: freeing resources", new Object[0]);
        this.setVisible(false);
        this.dispose();
        this.scr_img = null;
        this.scr_img_darker = null;
        this.bi = null;
    }

    @Override
    public void addObserver(EventObserver o) {
        this.obs = o;
    }

    @Override
    public void notifyObserver() {
        this.obs.update(this);
    }

    public void prompt(String msg, int delayMS) {
        try {
            Thread.sleep(delayMS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.prompt(msg);
    }

    public void prompt(int delayMS) {
        this.prompt(null, delayMS);
    }

    public void prompt() {
        this.prompt(null);
    }

    public void prompt(String msg) {
        this.captureScreen(this.scrOCP);
        Rectangle rect = new Rectangle(this.scrOCP.getBounds());
        this.setBounds(rect);
        this.promptMsg = msg;
        Debug.log(4, "CapturePrompt: [%d,%d (%d, %d)] %s", rect.x, rect.y, rect.width, rect.height, this.promptMsg);
        this.setVisible(true);
        if (!Settings.isJava7() && Settings.isMac()) {
            SysUtil.getOSUtil().bringWindowToFront(this, false);
        }
        this.requestFocus();
    }

    private void captureScreen(IScreen scr) {
        ScreenImage simg = scr.capture();
        this.scr_img = simg.getImage();
        this.darker_factor = 0.6f;
        RescaleOp op = new RescaleOp(this.darker_factor, 0.0f, null);
        this.scr_img_darker = op.filter(this.scr_img, null);
    }

    public ScreenImage getSelection() {
        if (this.canceled) {
            return null;
        }
        BufferedImage cropImg = this.cropSelection();
        if (cropImg == null) {
            return null;
        }
        this.rectSelection.x += this.scrOCP.getX();
        this.rectSelection.y += this.scrOCP.getY();
        ScreenImage ret = new ScreenImage(this.rectSelection, cropImg);
        return ret;
    }

    private BufferedImage cropSelection() {
        int w = this.rectSelection.width;
        int h = this.rectSelection.height;
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage crop = new BufferedImage(w, h, 1);
        Graphics2D crop_g2d = crop.createGraphics();
        try {
            crop_g2d.drawImage(this.scr_img.getSubimage(this.rectSelection.x, this.rectSelection.y, w, h), null, 0, 0);
        }
        catch (RasterFormatException e) {
            Debug.error(e.getMessage(), new Object[0]);
        }
        crop_g2d.dispose();
        return crop;
    }

    void drawMessage(Graphics2D g2d) {
        if (this.promptMsg == null) {
            return;
        }
        g2d.setFont(fontMsg);
        g2d.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        int sw = g2d.getFontMetrics().stringWidth(this.promptMsg);
        int sh = g2d.getFontMetrics().getMaxAscent();
        Rectangle ubound = new ScreenUnion().getBounds();
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            Rectangle bound = Screen.getBounds(i);
            int cx = bound.x + (bound.width - sw) / 2 - ubound.x;
            int cy = bound.y + (bound.height - sh) / 2 - ubound.y;
            g2d.drawString(this.promptMsg, cx, cy);
        }
    }

    private void drawSelection(Graphics2D g2d) {
        if (this.srcx != this.destx || this.srcy != this.desty) {
            int x1 = this.srcx < this.destx ? this.srcx : this.destx;
            int y1 = this.srcy < this.desty ? this.srcy : this.desty;
            int x2 = this.srcx > this.destx ? this.srcx : this.destx;
            int y2 = this.srcy > this.desty ? this.srcy : this.desty;
            this.rectSelection.x = x1;
            this.rectSelection.y = y1;
            this.rectSelection.width = x2 - x1 + 1;
            this.rectSelection.height = y2 - y1 + 1;
            if (this.rectSelection.width > 0 && this.rectSelection.height > 0) {
                g2d.drawImage(this.scr_img.getSubimage(x1, y1, x2 - x1 + 1, y2 - y1 + 1), null, x1, y1);
            }
            g2d.setColor(selFrameColor);
            g2d.setStroke(bs);
            g2d.draw(this.rectSelection);
            int cx = (x1 + x2) / 2;
            int cy = (y1 + y2) / 2;
            g2d.setColor(selCrossColor);
            g2d.setStroke(_StrokeCross);
            g2d.drawLine(cx, y1, cx, y2);
            g2d.drawLine(x1, cy, x2, cy);
            if (Screen.getNumberScreens() > 1) {
                this.drawScreenFrame(g2d, this.srcScreenId);
            }
        }
    }

    private void drawScreenFrame(Graphics2D g2d, int scrId) {
        g2d.setColor(screenFrameColor);
        g2d.setStroke(strokeScreenFrame);
        if (this.screenFrame == null) {
            this.screenFrame = Screen.getBounds(scrId);
            Rectangle ubound = this.scrOCP.getBounds();
            this.screenFrame.x -= ubound.x;
            this.screenFrame.y -= ubound.y;
            int sw = (int)(strokeScreenFrame.getLineWidth() / 2.0f);
            this.screenFrame.x += sw;
            this.screenFrame.y += sw;
            this.screenFrame.width -= sw * 2;
            this.screenFrame.height -= sw * 2;
        }
        g2d.draw(this.screenFrame);
    }

    @Override
    public void paint(Graphics g) {
        if (this.scr_img != null) {
            Graphics2D g2dWin = (Graphics2D)g;
            if (this.bi == null) {
                this.bi = new BufferedImage(this.scrOCP.getW(), this.scrOCP.getH(), 1);
            }
            Graphics2D bfG2 = this.bi.createGraphics();
            bfG2.drawImage((Image)this.scr_img_darker, 0, 0, this);
            this.drawMessage(bfG2);
            this.drawSelection(bfG2);
            g2dWin.drawImage((Image)this.bi, 0, 0, this);
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }
}

