/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfRect;
import org.opencv.core.Size;

public class HOGDescriptor {
    protected final long nativeObj;
    public static final int L2Hys = 0;
    public static final int DEFAULT_NLEVELS = 64;

    protected HOGDescriptor(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static HOGDescriptor __fromPtr__(long addr) {
        return new HOGDescriptor(addr);
    }

    public HOGDescriptor(Size _winSize, Size _blockSize, Size _blockStride, Size _cellSize, int _nbins, int _derivAperture, double _winSigma, int _histogramNormType, double _L2HysThreshold, boolean _gammaCorrection, int _nlevels, boolean _signedGradient) {
        this.nativeObj = HOGDescriptor.HOGDescriptor_0(_winSize.width, _winSize.height, _blockSize.width, _blockSize.height, _blockStride.width, _blockStride.height, _cellSize.width, _cellSize.height, _nbins, _derivAperture, _winSigma, _histogramNormType, _L2HysThreshold, _gammaCorrection, _nlevels, _signedGradient);
    }

    public HOGDescriptor(Size _winSize, Size _blockSize, Size _blockStride, Size _cellSize, int _nbins) {
        this.nativeObj = HOGDescriptor.HOGDescriptor_1(_winSize.width, _winSize.height, _blockSize.width, _blockSize.height, _blockStride.width, _blockStride.height, _cellSize.width, _cellSize.height, _nbins);
    }

    public HOGDescriptor(String filename) {
        this.nativeObj = HOGDescriptor.HOGDescriptor_2(filename);
    }

    public HOGDescriptor() {
        this.nativeObj = HOGDescriptor.HOGDescriptor_3();
    }

    public boolean checkDetectorSize() {
        boolean retVal = HOGDescriptor.checkDetectorSize_0(this.nativeObj);
        return retVal;
    }

    public boolean load(String filename, String objname) {
        boolean retVal = HOGDescriptor.load_0(this.nativeObj, filename, objname);
        return retVal;
    }

    public boolean load(String filename) {
        boolean retVal = HOGDescriptor.load_1(this.nativeObj, filename);
        return retVal;
    }

    public double getWinSigma() {
        double retVal = HOGDescriptor.getWinSigma_0(this.nativeObj);
        return retVal;
    }

    public long getDescriptorSize() {
        long retVal = HOGDescriptor.getDescriptorSize_0(this.nativeObj);
        return retVal;
    }

    public static MatOfFloat getDaimlerPeopleDetector() {
        MatOfFloat retVal = MatOfFloat.fromNativeAddr(HOGDescriptor.getDaimlerPeopleDetector_0());
        return retVal;
    }

    public static MatOfFloat getDefaultPeopleDetector() {
        MatOfFloat retVal = MatOfFloat.fromNativeAddr(HOGDescriptor.getDefaultPeopleDetector_0());
        return retVal;
    }

    public void compute(Mat img, MatOfFloat descriptors, Size winStride, Size padding, MatOfPoint locations) {
        MatOfFloat descriptors_mat = descriptors;
        MatOfPoint locations_mat = locations;
        HOGDescriptor.compute_0(this.nativeObj, img.nativeObj, descriptors_mat.nativeObj, winStride.width, winStride.height, padding.width, padding.height, locations_mat.nativeObj);
    }

    public void compute(Mat img, MatOfFloat descriptors) {
        MatOfFloat descriptors_mat = descriptors;
        HOGDescriptor.compute_1(this.nativeObj, img.nativeObj, descriptors_mat.nativeObj);
    }

    public void computeGradient(Mat img, Mat grad, Mat angleOfs, Size paddingTL, Size paddingBR) {
        HOGDescriptor.computeGradient_0(this.nativeObj, img.nativeObj, grad.nativeObj, angleOfs.nativeObj, paddingTL.width, paddingTL.height, paddingBR.width, paddingBR.height);
    }

    public void computeGradient(Mat img, Mat grad, Mat angleOfs) {
        HOGDescriptor.computeGradient_1(this.nativeObj, img.nativeObj, grad.nativeObj, angleOfs.nativeObj);
    }

    public void detect(Mat img, MatOfPoint foundLocations, MatOfDouble weights, double hitThreshold, Size winStride, Size padding, MatOfPoint searchLocations) {
        MatOfPoint foundLocations_mat = foundLocations;
        MatOfDouble weights_mat = weights;
        MatOfPoint searchLocations_mat = searchLocations;
        HOGDescriptor.detect_0(this.nativeObj, img.nativeObj, foundLocations_mat.nativeObj, weights_mat.nativeObj, hitThreshold, winStride.width, winStride.height, padding.width, padding.height, searchLocations_mat.nativeObj);
    }

    public void detect(Mat img, MatOfPoint foundLocations, MatOfDouble weights) {
        MatOfPoint foundLocations_mat = foundLocations;
        MatOfDouble weights_mat = weights;
        HOGDescriptor.detect_1(this.nativeObj, img.nativeObj, foundLocations_mat.nativeObj, weights_mat.nativeObj);
    }

    public void detectMultiScale(Mat img, MatOfRect foundLocations, MatOfDouble foundWeights, double hitThreshold, Size winStride, Size padding, double scale, double finalThreshold, boolean useMeanshiftGrouping) {
        MatOfRect foundLocations_mat = foundLocations;
        MatOfDouble foundWeights_mat = foundWeights;
        HOGDescriptor.detectMultiScale_0(this.nativeObj, img.nativeObj, foundLocations_mat.nativeObj, foundWeights_mat.nativeObj, hitThreshold, winStride.width, winStride.height, padding.width, padding.height, scale, finalThreshold, useMeanshiftGrouping);
    }

    public void detectMultiScale(Mat img, MatOfRect foundLocations, MatOfDouble foundWeights) {
        MatOfRect foundLocations_mat = foundLocations;
        MatOfDouble foundWeights_mat = foundWeights;
        HOGDescriptor.detectMultiScale_1(this.nativeObj, img.nativeObj, foundLocations_mat.nativeObj, foundWeights_mat.nativeObj);
    }

    public void save(String filename, String objname) {
        HOGDescriptor.save_0(this.nativeObj, filename, objname);
    }

    public void save(String filename) {
        HOGDescriptor.save_1(this.nativeObj, filename);
    }

    public void setSVMDetector(Mat _svmdetector) {
        HOGDescriptor.setSVMDetector_0(this.nativeObj, _svmdetector.nativeObj);
    }

    public Size get_winSize() {
        Size retVal = new Size(HOGDescriptor.get_winSize_0(this.nativeObj));
        return retVal;
    }

    public Size get_blockSize() {
        Size retVal = new Size(HOGDescriptor.get_blockSize_0(this.nativeObj));
        return retVal;
    }

    public Size get_blockStride() {
        Size retVal = new Size(HOGDescriptor.get_blockStride_0(this.nativeObj));
        return retVal;
    }

    public Size get_cellSize() {
        Size retVal = new Size(HOGDescriptor.get_cellSize_0(this.nativeObj));
        return retVal;
    }

    public int get_nbins() {
        int retVal = HOGDescriptor.get_nbins_0(this.nativeObj);
        return retVal;
    }

    public int get_derivAperture() {
        int retVal = HOGDescriptor.get_derivAperture_0(this.nativeObj);
        return retVal;
    }

    public double get_winSigma() {
        double retVal = HOGDescriptor.get_winSigma_0(this.nativeObj);
        return retVal;
    }

    public int get_histogramNormType() {
        int retVal = HOGDescriptor.get_histogramNormType_0(this.nativeObj);
        return retVal;
    }

    public double get_L2HysThreshold() {
        double retVal = HOGDescriptor.get_L2HysThreshold_0(this.nativeObj);
        return retVal;
    }

    public boolean get_gammaCorrection() {
        boolean retVal = HOGDescriptor.get_gammaCorrection_0(this.nativeObj);
        return retVal;
    }

    public MatOfFloat get_svmDetector() {
        MatOfFloat retVal = MatOfFloat.fromNativeAddr(HOGDescriptor.get_svmDetector_0(this.nativeObj));
        return retVal;
    }

    public int get_nlevels() {
        int retVal = HOGDescriptor.get_nlevels_0(this.nativeObj);
        return retVal;
    }

    public boolean get_signedGradient() {
        boolean retVal = HOGDescriptor.get_signedGradient_0(this.nativeObj);
        return retVal;
    }

    protected void finalize() throws Throwable {
        HOGDescriptor.delete(this.nativeObj);
    }

    private static native long HOGDescriptor_0(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, int var16, int var17, double var18, int var20, double var21, boolean var23, int var24, boolean var25);

    private static native long HOGDescriptor_1(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, int var16);

    private static native long HOGDescriptor_2(String var0);

    private static native long HOGDescriptor_3();

    private static native boolean checkDetectorSize_0(long var0);

    private static native boolean load_0(long var0, String var2, String var3);

    private static native boolean load_1(long var0, String var2);

    private static native double getWinSigma_0(long var0);

    private static native long getDescriptorSize_0(long var0);

    private static native long getDaimlerPeopleDetector_0();

    private static native long getDefaultPeopleDetector_0();

    private static native void compute_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12, long var14);

    private static native void compute_1(long var0, long var2, long var4);

    private static native void computeGradient_0(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14);

    private static native void computeGradient_1(long var0, long var2, long var4, long var6);

    private static native void detect_0(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, double var16, long var18);

    private static native void detect_1(long var0, long var2, long var4, long var6);

    private static native void detectMultiScale_0(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, boolean var22);

    private static native void detectMultiScale_1(long var0, long var2, long var4, long var6);

    private static native void save_0(long var0, String var2, String var3);

    private static native void save_1(long var0, String var2);

    private static native void setSVMDetector_0(long var0, long var2);

    private static native double[] get_winSize_0(long var0);

    private static native double[] get_blockSize_0(long var0);

    private static native double[] get_blockStride_0(long var0);

    private static native double[] get_cellSize_0(long var0);

    private static native int get_nbins_0(long var0);

    private static native int get_derivAperture_0(long var0);

    private static native double get_winSigma_0(long var0);

    private static native int get_histogramNormType_0(long var0);

    private static native double get_L2HysThreshold_0(long var0);

    private static native boolean get_gammaCorrection_0(long var0);

    private static native long get_svmDetector_0(long var0);

    private static native int get_nlevels_0(long var0);

    private static native boolean get_signedGradient_0(long var0);

    private static native void delete(long var0);
}

