/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.util.HashMap;
import java.util.Map;
import jxgrabkey.HotkeyConflictException;
import jxgrabkey.JXGrabKey;
import org.sikuli.basics.Debug;
import org.sikuli.basics.HotkeyEvent;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.HotkeyManager;
import org.sikuli.script.support.RunTime;

public class LinuxHotkeyManager
extends HotkeyManager {
    private Map<Integer, HotkeyData> _idCallbackMap = new HashMap<Integer, HotkeyData>();
    private int _gHotkeyId = 1;

    @Override
    public boolean _addHotkey(int keyCode, int modifiers, HotkeyListener listener) {
        JXGrabKey grabKey = JXGrabKey.getInstance();
        if (this._gHotkeyId == 1) {
            grabKey.addHotkeyListener(new MyHotkeyHandler());
        }
        this._removeHotkey(keyCode, modifiers);
        int id = this._gHotkeyId++;
        HotkeyData data = new HotkeyData(keyCode, modifiers, listener);
        this._idCallbackMap.put(id, data);
        try {
            grabKey.registerAwtHotkey(id, modifiers, keyCode);
        }
        catch (HotkeyConflictException e) {
            Debug.error("Hot key conflicts", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean _removeHotkey(int keyCode, int modifiers) {
        for (Map.Entry<Integer, HotkeyData> entry : this._idCallbackMap.entrySet()) {
            HotkeyData data = entry.getValue();
            if (data.key != keyCode || data.modifiers != modifiers) continue;
            JXGrabKey grabKey = JXGrabKey.getInstance();
            int id = entry.getKey();
            grabKey.unregisterHotKey(id);
            this._idCallbackMap.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public int _removeAll(Map<String, Integer[]> hotkeys, boolean isTerminating) {
        for (Integer[] keyMods : hotkeys.values()) {
            if (this._removeHotkey(keyMods[0], keyMods[1])) continue;
            return -1;
        }
        return hotkeys.size();
    }

    @Override
    public void cleanUp() {
        JXGrabKey grabKey = JXGrabKey.getInstance();
        for (Map.Entry<Integer, HotkeyData> entry : this._idCallbackMap.entrySet()) {
            int id = entry.getKey();
            grabKey.unregisterHotKey(id);
        }
        this._gHotkeyId = 1;
        this._idCallbackMap.clear();
        grabKey.getInstance().cleanUp();
    }

    static {
        RunTime.loadLibrary("JXGrabKey");
    }

    class MyHotkeyHandler
    implements jxgrabkey.HotkeyListener {
        MyHotkeyHandler() {
        }

        @Override
        public void onHotkey(int id) {
            Debug.log(4, "Hotkey pressed", new Object[0]);
            HotkeyData data = (HotkeyData)LinuxHotkeyManager.this._idCallbackMap.get(id);
            HotkeyEvent e = new HotkeyEvent(data.key, data.modifiers);
            data.listener.invokeHotkeyPressed(e);
        }
    }

    class HotkeyData {
        int key;
        int modifiers;
        HotkeyListener listener;

        public HotkeyData(int key_, int mod_, HotkeyListener l_) {
            this.key = key_;
            this.modifiers = mod_;
            this.listener = l_;
        }
    }
}

