/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.sikuli.guide.GlobalMouseMotionListener;
import org.sikuli.script.Env;
import org.sikuli.script.Location;

public class GlobalMouseMotionTracker
implements ActionListener {
    static final int IDLE_COUNT_THRESHOLD = 200;
    int idle_count;
    Location lastLocation = null;
    static GlobalMouseMotionTracker _instance = null;
    ArrayList<GlobalMouseMotionListener> listeners = new ArrayList();
    Timer timer = new Timer(10, this);

    public static GlobalMouseMotionTracker getInstance() {
        if (_instance == null) {
            _instance = new GlobalMouseMotionTracker();
        }
        return _instance;
    }

    public void addListener(GlobalMouseMotionListener listener) {
        this.listeners.add(listener);
    }

    private GlobalMouseMotionTracker() {
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent arg) {
        Location newLocation = Env.getMouseLocation();
        if (this.lastLocation != null) {
            if (this.lastLocation.x != newLocation.x || this.lastLocation.y != newLocation.y) {
                for (GlobalMouseMotionListener listener : this.listeners) {
                    listener.globalMouseMoved(newLocation.x, newLocation.y);
                }
                this.idle_count = 0;
            } else {
                ++this.idle_count;
            }
            if (this.idle_count > 200) {
                for (GlobalMouseMotionListener listener : this.listeners) {
                    listener.globalMouseIdled(newLocation.x, newLocation.y);
                }
                this.idle_count = 0;
            }
        }
        this.lastLocation = newLocation;
    }
}

