/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.natives.OSUtil;
import org.sikuli.natives.SysUtil;
import org.sikuli.script.Region;
import org.sikuli.script.support.RunTime;

public class App {
    private static OSUtil _osUtil = null;
    private static final Map<Type, String> appsWindows;
    private static final Map<Type, String> appsMac;
    private static final Region aRegion;
    private boolean isGivenAsWindowTitle = false;
    private static boolean shouldLog;
    private String appNameGiven = "";
    private String appName = "";
    private String appToken = "";
    private String appExec = "";
    private String appExecPath = "";
    private String appWorkDir = "";
    private String appOptions = "";
    private String appWindow = "";
    private int appPID = -1;
    private int maxWait = 10;
    boolean isOpen = false;
    private boolean isClosing = false;
    private boolean isFocused = false;
    public static int lastRunReturnCode;
    public static String lastRunStdout;
    public static String lastRunStderr;
    public static String lastRunResult;

    public boolean isWindow() {
        return this.isGivenAsWindowTitle;
    }

    private void setGivenAsWindowTitle() {
        this.isGivenAsWindowTitle = true;
    }

    private void resetGivenAsWindowTitle() {
        this.isGivenAsWindowTitle = false;
    }

    public static Region start(Type appType) {
        App app = null;
        try {
            if (Type.EDITOR.equals((Object)appType)) {
                if (RunTime.get().runningMac) {
                    app = new App(appsMac.get((Object)appType));
                    if (app.window() != null) {
                        app.focus();
                        aRegion.wait(0.5);
                        Region win = app.window();
                        aRegion.click(win);
                        aRegion.write("#M.a#B.");
                        return win;
                    }
                    app.open();
                    Region win = app.waitForWindow();
                    app.focus();
                    aRegion.wait(0.5);
                    aRegion.click(win);
                    return win;
                }
                if (RunTime.get().runningWindows) {
                    app = new App(appsWindows.get((Object)appType));
                    if (app.window() != null) {
                        app.focus();
                        aRegion.wait(0.5);
                        Region win = app.window();
                        aRegion.click(win);
                        aRegion.write("#C.a#B.");
                        return win;
                    }
                    app.open();
                    Region win = app.waitForWindow();
                    app.focus();
                    aRegion.wait(0.5);
                    aRegion.click(win);
                    return win;
                }
            } else {
                if (Type.BROWSER.equals((Object)appType)) {
                    if (RunTime.get().runningWindows) {
                        app = new App(appsWindows.get((Object)appType));
                        if (app.window() != null) {
                            app.focus();
                            aRegion.wait(0.5);
                            Region win = app.window();
                            aRegion.click(win);
                            return win;
                        }
                        app.open();
                        Region win = app.waitForWindow();
                        app.focus();
                        aRegion.wait(0.5);
                        aRegion.click(win);
                        return win;
                    }
                    return null;
                }
                if (Type.VIEWER.equals((Object)appType)) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Region waitForWindow() {
        return this.waitForWindow(5);
    }

    public Region waitForWindow(int seconds) {
        Region win = null;
        while ((win = this.window()) == null && seconds > 0) {
            aRegion.wait(0.5);
            seconds = (int)((double)seconds - 0.5);
        }
        return win;
    }

    public static boolean openLink(String url) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        try {
            Desktop.getDesktop().browse(new URL(url).toURI());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static Region asRegion(Rectangle r) {
        if (r != null) {
            return Region.create(r);
        }
        return null;
    }

    public static void pause(int time) {
        try {
            Thread.sleep(time * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void pause(float time) {
        try {
            Thread.sleep((int)(time * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void log(String msg, Object ... args) {
        if (shouldLog) {
            Debug.logp("[AppLog] " + msg, args);
        }
    }

    public static void logOn() {
        shouldLog = true;
    }

    public static void logOff() {
        shouldLog = false;
    }

    public void reset() {
        this.appPID = -1;
        this.appWindow = "";
    }

    public App() {
        if (_osUtil == null) {
            _osUtil = SysUtil.getOSUtil();
            _osUtil.checkFeatureAvailability();
        }
    }

    public App(String name) {
        this();
        this.init(name);
    }

    private void init(String name) {
        if (name.isEmpty()) {
            return;
        }
        this.appNameGiven = name.trim();
        String[] parts = this.appNameGiven.split(" -- ");
        String possibleAppExec = "";
        if (parts.length > 1) {
            this.appOptions = parts[1].trim();
            possibleAppExec = parts[0].replace("\"", "").trim();
        } else if (this.appNameGiven.startsWith("\"")) {
            parts = this.appNameGiven.substring(1).split("\"");
            if (parts.length > 1) {
                this.appOptions = this.appNameGiven.substring(parts[0].length() + 2).trim();
                possibleAppExec = parts[0];
            } else {
                possibleAppExec = this.appNameGiven.replace("\"", "");
            }
        } else {
            possibleAppExec = this.appNameGiven;
        }
        File fExec = new File(possibleAppExec);
        if (fExec.isAbsolute()) {
            if (!fExec.exists()) {
                App.log("App: init: does not exist or not valid: %s", fExec);
            } else {
                this.appExec = fExec.getAbsolutePath();
                this.appExecPath = fExec.getParent();
            }
        }
        if (!this.appExec.isEmpty()) {
            this.appName = fExec.getName();
        } else if (RunTime.get().runningWindows || possibleAppExec.startsWith("?")) {
            this.appName = this.appNameGiven;
            this.setGivenAsWindowTitle();
            if (this.appName.startsWith("?")) {
                this.appName = this.appName.substring(1);
            }
        } else if (!RunTime.get().runningWindows) {
            this.appExec = possibleAppExec;
            this.appName = possibleAppExec;
        }
        App.log("App.create: %s", this.toString());
    }

    public String toString() {
        if (this.isWindow()) {
            return String.format("[%d:?%s (%s)] %s", this.appPID, this.appName, this.appWindow, this.appNameGiven);
        }
        return String.format("[%d:%s (%s)] %s %s", this.appPID, this.appName, this.appWindow, this.appExec, this.appOptions);
    }

    public String toStringShort() {
        if (this.isWindow()) {
            return String.format("[%d:?%s]", this.appPID, this.appName);
        }
        return String.format("[%d:%s]", this.appPID, this.appName);
    }

    public static List<App> getApps() {
        new App();
        return _osUtil.getApps("");
    }

    public static List<App> getApps(String name) {
        new App();
        return _osUtil.getApps(name);
    }

    public static void listApps() {
        new App();
        List<App> appList = _osUtil.getApps("");
        App.logOn();
        App.log("***** all running apps", new Object[0]);
        for (App app : appList) {
            if (app.getPID() <= 0) continue;
            App.log("%s", app);
        }
        App.log("***** end of list (%d)", appList.size());
        App.logOff();
    }

    public static void listApps(String name) {
        new App();
        List<App> appList = _osUtil.getApps(name);
        App.logOn();
        App.log("***** running apps matching: %s", name);
        for (App app : appList) {
            App.log("%s", app);
        }
        App.log("***** end of list (%d)", appList.size());
        App.logOff();
    }

    public String getToken() {
        return this.appToken;
    }

    public void setToken(String appToken) {
        this.appToken = appToken;
    }

    public App setUsing(String options) {
        this.appOptions = options != null ? options : "";
        return this;
    }

    public void setNameGiven(String nameGiven) {
        this.appNameGiven = nameGiven;
    }

    public String getNameGiven() {
        return this.appNameGiven;
    }

    public String getOptions() {
        return this.appOptions;
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getExec() {
        return this.appExec;
    }

    public void setExec(String exec) {
        this.appExec = exec;
    }

    public String getTitle() {
        return this.getWindowTitle();
    }

    public String getTitle(int windowNumber) {
        return this.getWindowTitle();
    }

    public String getWindowTitle() {
        return this.appWindow == null ? "" : this.appWindow;
    }

    public void setWindow(String appWindow) {
        this.appWindow = appWindow;
    }

    public void setPID(int appPID) {
        this.appPID = appPID;
    }

    public void setPID(String appPID) {
        try {
            this.appPID = Integer.parseInt(appPID);
        }
        catch (NumberFormatException e) {
            this.reset();
        }
    }

    public int getPID() {
        return this.appPID;
    }

    public boolean setWorkDir() {
        if (this.appExecPath.isEmpty()) {
            return false;
        }
        this.appWorkDir = this.appExecPath;
        return true;
    }

    public boolean setWorkDir(String workDirPath) {
        if (workDirPath == null || workDirPath.isEmpty()) {
            return false;
        }
        File fWorkDir = new File(workDirPath);
        if (!(fWorkDir.isAbsolute() && fWorkDir.isDirectory() && fWorkDir.exists())) {
            return false;
        }
        this.appWorkDir = fWorkDir.getAbsolutePath();
        return true;
    }

    public String getWorkDir() {
        return this.appWorkDir;
    }

    public boolean isValid() {
        return this.appPID > 0;
    }

    public boolean isRunning() {
        return this.isRunning(0);
    }

    public boolean isRunning(int maxTime) {
        _osUtil.get(this);
        if (maxTime == 0 && !this.isValid()) {
            return false;
        }
        while (!this.isValid() && maxTime > 0) {
            --maxTime;
            App.pause(1);
            _osUtil.get(this);
        }
        return this.isValid();
    }

    public boolean hasWindow() {
        if (!this.isValid()) {
            return false;
        }
        return !this.getWindowTitle().isEmpty();
    }

    public static App open(String appName, int waitTime) {
        App app = new App(appName);
        app.openAndWait(waitTime);
        return app;
    }

    public static App open(String appName) {
        return App.open(appName, 1);
    }

    public boolean open() {
        this.openAndWait(5);
        return this.isValid();
    }

    public boolean open(int waitTime) {
        this.openAndWait(waitTime);
        return this.isValid() & this.hasWindow();
    }

    private void openAndWait(int waitTime) {
        this.isOpen = false;
        if (!this.isRunning(0)) {
            boolean isOpen = _osUtil.open(this);
            if (isOpen) {
                if (!this.isRunning(waitTime)) {
                    App.log("App.open: not running after %d secs (%s)", waitTime, this.appNameGiven);
                } else {
                    App.log("App.open: %s", this);
                    if (!this.focus()) {
                        while (!this.hasWindow() && waitTime > 0) {
                            --waitTime;
                            App.pause(1);
                            this.focus();
                        }
                    }
                }
            } else {
                App.log("App.open: %s: did not work - app not valid", this.appNameGiven);
            }
        } else {
            App.log("App.open: already running: %s", this);
            this.isOpen = true;
            this.focus();
        }
    }

    public static boolean close(String appName) {
        return new App(appName).close();
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public boolean close() {
        return this.close(5);
    }

    public boolean close(int waitTime) {
        if (!this.isRunning()) {
            App.log("App.close: not running: %s", this);
            return false;
        }
        boolean success = _osUtil.close(this);
        if (success) {
            this.isClosing = true;
            int timeTowait = this.maxWait;
            if (waitTime > 0) {
                timeTowait = waitTime;
            }
            while (this.isRunning(0) && timeTowait > 0) {
                App.pause(1);
                --timeTowait;
            }
        }
        this.isClosing = false;
        if (this.isValid() || !success) {
            App.log("App.close: did not work: %s", this);
            return false;
        }
        App.log("App.close: %s", this);
        this.reset();
        return true;
    }

    public int closeByKey() {
        return this.closeByKey(0);
    }

    public int closeByKey(int waitTime) {
        if (!this.isRunning()) {
            App.log("App.closeByKey: not running: %s", this);
            return 1;
        }
        this.focus();
        RunTime.pause(1);
        if (RunTime.get().runningWindows) {
            this.window().type("\ue014", "\ue022");
        } else if (RunTime.get().runningMac) {
            this.window().type("q", "\ue023");
        } else {
            this.window().type("q", "\ue021");
        }
        int timeTowait = this.maxWait;
        if (waitTime > 0) {
            timeTowait = waitTime;
        }
        while (this.isRunning(0) && timeTowait > 0) {
            --timeTowait;
        }
        if (this.isValid()) {
            App.log("App.closeByKey: did not work: %s", this);
            return 1;
        }
        App.log("App.closeByKey: %s", this);
        return 0;
    }

    public void setFocused(boolean state) {
        this.isFocused = state;
    }

    public boolean hasFocus() {
        return this.isFocused;
    }

    public static App focus(String title) {
        return App.focus(title, 0);
    }

    public static App focus(String title, int index) {
        App app = new App(title);
        app.focus();
        return app;
    }

    public boolean focus() {
        this.isFocused = false;
        if (!this.isOpen && !this.isRunning(0)) {
            App.log("App.focus: not running: %s", this.toString());
            return false;
        }
        this.isOpen = false;
        if (!_osUtil.switchto(this)) {
            App.log("App.focus: no window for %s", this.toString());
            return false;
        }
        this.isFocused = true;
        if (this.isWindow()) {
            this.resetGivenAsWindowTitle();
        }
        App.log("App.focus: %s", this);
        return true;
    }

    public Region window() {
        return this.window(0);
    }

    public Region window(int winNum) {
        Region windowRegion = null;
        Rectangle windowRect = _osUtil.getWindow(this, winNum);
        if (null != windowRect) {
            windowRegion = App.asRegion(windowRect);
            if (winNum == 0) {
                windowRegion.setName(this.getTitle());
            }
        }
        return windowRegion;
    }

    public static Region focusedWindow() {
        new App();
        return App.asRegion(_osUtil.getFocusedWindow());
    }

    public List<Region> getWindows() {
        new App();
        ArrayList regWindows = new ArrayList();
        return _osUtil.getWindows(this);
    }

    public static int run(String cmd) {
        lastRunResult = RunTime.get().runcmd(cmd);
        String NL = RunTime.get().runningWindows ? "\r\n" : "\n";
        String[] res = lastRunResult.split(NL);
        try {
            lastRunReturnCode = Integer.parseInt(res[0].trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastRunStdout = "";
        lastRunStderr = "";
        boolean isError = false;
        for (int n = 1; n < res.length; ++n) {
            if (isError) {
                lastRunStderr = lastRunStderr + res[n] + NL;
                continue;
            }
            RunTime.get();
            if ("*****error*****".equals(res[n])) {
                isError = true;
                continue;
            }
            lastRunStdout = lastRunStdout + res[n] + NL;
        }
        return lastRunReturnCode;
    }

    public static String getClipboard() {
        Transferable content = null;
        try {
            content = Clipboard.getSystemClipboard().getContents(null);
        }
        catch (Exception ex) {
            Debug.error("Env.getClipboard: %s", ex.getMessage());
        }
        if (content != null) {
            try {
                if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return (String)content.getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (UnsupportedFlavorException ex) {
                Debug.error("Env.getClipboard: UnsupportedFlavorException: " + content, new Object[0]);
            }
            catch (IOException ex) {
                Debug.error("Env.getClipboard: %s", ex.getMessage());
            }
        }
        return "";
    }

    public static void setClipboard(String text) {
        try {
            Clipboard.putText(Clipboard.PLAIN, Clipboard.UTF8, Clipboard.CHAR_BUFFER, text);
        }
        catch (Exception ex) {
            Debug.error("Env.setClipboard: %s", ex.getMessage());
        }
    }

    static {
        aRegion = new Region();
        appsWindows = new HashMap<Type, String>();
        appsWindows.put(Type.EDITOR, "Notepad");
        appsWindows.put(Type.BROWSER, "Google Chrome");
        appsWindows.put(Type.VIEWER, "");
        appsMac = new HashMap<Type, String>();
        appsMac.put(Type.EDITOR, "TextEdit");
        appsMac.put(Type.BROWSER, "Safari");
        appsMac.put(Type.VIEWER, "Preview");
        shouldLog = false;
        lastRunReturnCode = -1;
        lastRunStdout = "";
        lastRunStderr = "";
        lastRunResult = "";
    }

    public static enum Type {
        EDITOR,
        BROWSER,
        VIEWER;

    }

    private static class Clipboard {
        public static final TextType HTML = new TextType("text/html");
        public static final TextType PLAIN = new TextType("text/plain");
        public static final Charset UTF8 = new Charset("UTF-8");
        public static final Charset UTF16 = new Charset("UTF-16");
        public static final Charset UNICODE = new Charset("unicode");
        public static final Charset US_ASCII = new Charset("US-ASCII");
        public static final TransferType READER = new TransferType(Reader.class);
        public static final TransferType INPUT_STREAM = new TransferType(InputStream.class);
        public static final TransferType CHAR_BUFFER = new TransferType(CharBuffer.class);
        public static final TransferType BYTE_BUFFER = new TransferType(ByteBuffer.class);
        private static java.awt.datatransfer.Clipboard systemClipboard = null;

        private Clipboard() {
        }

        public static void putText(CharSequence data) throws Exception {
            StringSelection copy = new StringSelection(data.toString());
            Clipboard.getSystemClipboard().setContents(copy, copy);
        }

        public static void putText(TextType type, Charset charset, TransferType transferType, CharSequence data) throws Exception {
            String mimeType = type + "; charset=" + charset + "; class=" + transferType;
            TextTransferable transferable = new TextTransferable(mimeType, data.toString());
            Clipboard.getSystemClipboard().setContents(transferable, transferable);
        }

        public static java.awt.datatransfer.Clipboard getSystemClipboard() throws Exception {
            if (systemClipboard == null && (systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard()) == null) {
                throw new Exception("Clipboard: Toolkit.getDefaultToolkit().getSystemClipboard() returns null");
            }
            return systemClipboard;
        }

        private static class TextTransferable
        implements Transferable,
        ClipboardOwner {
            private String data;
            private DataFlavor flavor;

            public TextTransferable(String mimeType, String data) {
                this.flavor = new DataFlavor(mimeType, "Text");
                this.data = data;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.flavor, DataFlavor.stringFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                boolean b = this.flavor.getPrimaryType().equals(flavor.getPrimaryType());
                return b || flavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor.isRepresentationClassInputStream()) {
                    return new StringReader(this.data);
                }
                if (flavor.isRepresentationClassReader()) {
                    return new StringReader(this.data);
                }
                if (flavor.isRepresentationClassCharBuffer()) {
                    return CharBuffer.wrap(this.data);
                }
                if (flavor.isRepresentationClassByteBuffer()) {
                    return ByteBuffer.wrap(this.data.getBytes());
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return this.data;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            @Override
            public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable contents) {
            }
        }

        public static class TextType {
            private String type;

            private TextType(String type) {
                this.type = type;
            }

            public String toString() {
                return this.type;
            }
        }

        public static class Charset {
            private String name;

            private Charset(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }

        public static class TransferType {
            private Class dataClass;

            private TransferType(Class streamClass) {
                this.dataClass = streamClass;
            }

            public Class getDataClass() {
                return this.dataClass;
            }

            public String toString() {
                return this.dataClass.getName();
            }
        }
    }
}

