/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Finder;
import org.sikuli.script.Image;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.support.RunTime;

public class ScreenImage {
    public int x;
    public int y;
    public int w;
    public int h;
    protected Rectangle _roi;
    protected BufferedImage _img;
    protected String _filename = null;
    public Location start;
    public Location end;

    public void setStartEnd(Location start, Location end) {
        this.start = start;
        this.end = end;
    }

    public Location getStart() {
        return this.start;
    }

    public Location getEnd() {
        return this.end;
    }

    public ScreenImage(Rectangle roi, BufferedImage img) {
        this._img = img;
        this._roi = roi;
        this.x = (int)roi.getX();
        this.y = (int)roi.getY();
        this.w = this._img.getWidth();
        this.h = this._img.getHeight();
    }

    public ScreenImage getSub(Rectangle sub) {
        if (!this._roi.contains(sub)) {
            return this;
        }
        BufferedImage img = this._img.getSubimage(sub.x - this.x, sub.y - this.y, sub.width, sub.height);
        return new ScreenImage(sub, img);
    }

    @Deprecated
    public String getFilename() throws IOException {
        return this.getFile();
    }

    public String getFile() {
        if (this._filename == null) {
            this._filename = this.save();
        }
        return this._filename;
    }

    public String getStoredAt() {
        return this._filename;
    }

    public String save() {
        return FileManager.saveTimedImage(this._img, RunTime.get().fpBaseTempPath, "#sikuliximage");
    }

    public String getFile(String path) {
        return this.save(path);
    }

    public String save(String path) {
        return FileManager.saveTimedImage(this._img, path, "#sikuliximage");
    }

    public String save(String path, String name) {
        return FileManager.saveTimedImage(this._img, path, name);
    }

    public String getFile(String path, String name) {
        if (name == null) {
            name = Settings.getTimestamp() + ".png";
        } else if (!name.endsWith(".png")) {
            name = name + ".png";
        }
        try {
            File image = new File(path, name);
            this.storeImage(image);
            Debug.log(3, "ScreenImage.store: %s", image);
        }
        catch (IOException iOException) {
            Debug.error("ScreenImage.store: IOException", iOException);
            return null;
        }
        return this._filename;
    }

    public String saveInBundle(String name) {
        if (!name.endsWith(".png")) {
            name = name + ".png";
        }
        if (!name.startsWith("_")) {
            name = "_" + name;
        }
        File fImage = null;
        if (null != ImagePath.getBundlePath()) {
            try {
                fImage = new File(ImagePath.getBundlePath(), name);
                this.storeImage(fImage);
                Debug.log(3, "ScreenImage: saveInBundle: %s", fImage);
            }
            catch (IOException iOException) {
                Debug.error("ScreenImage: saveInBundle: did not work: %s (%s)", fImage, iOException);
                return null;
            }
            Image.reload(fImage.getAbsolutePath());
            return fImage.getAbsolutePath();
        }
        return null;
    }

    private void storeImage(File image) throws IOException {
        String filename = image.getAbsolutePath();
        if (!filename.equals(this._filename) || image.getName().startsWith("_")) {
            ImageIO.write((RenderedImage)this._img, "png", image);
            this._filename = filename;
        }
    }

    public BufferedImage getImage() {
        return this._img;
    }

    public Region getRegion() {
        return new Region(this._roi);
    }

    public Rectangle getROI() {
        return this._roi;
    }

    public void saveLastScreenImage(File fPath) {
        try {
            ImageIO.write((RenderedImage)this._img, "png", new File(fPath, "LastScreenImage.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ScreenImage)) {
            return false;
        }
        Mat thisGray = new Mat();
        Mat otherGray = new Mat();
        Mat mDiffAbs = new Mat();
        Imgproc.cvtColor(Finder.Finder2.makeMat(this.getImage()), thisGray, 6);
        Imgproc.cvtColor(Finder.Finder2.makeMat(((ScreenImage)other).getImage()), otherGray, 6);
        Core.absdiff(thisGray, otherGray, mDiffAbs);
        return Core.countNonZero(mDiffAbs) == 0;
    }
}

