/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import org.sikuli.script.runners.AbstractScriptRunner;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.Runner;
import org.sikuli.util.AbortableScriptRunnerWrapper;

public class SikulixRunner
extends AbstractScriptRunner {
    public static final String NAME = "Sikulix";
    public static final String TYPE = "directory/sikulix";
    private AbortableScriptRunnerWrapper wrapper = new AbortableScriptRunnerWrapper();

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return new String[0];
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean canHandle(String identifier) {
        File file = new File(identifier);
        if (file.isDirectory()) {
            File innerScriptFile = Runner.getScriptFile(file);
            return null != innerScriptFile;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRunScript(String scriptFolder, String[] scriptArgs, IScriptRunner.Options options) {
        IScriptRunner.EffectiveRunner runnerAndFile = this.getEffectiveRunner(scriptFolder);
        IScriptRunner runner = runnerAndFile.getRunner();
        String innerScriptFile = runnerAndFile.getScript();
        if (null != runner) {
            try {
                this.wrapper.setRunner(runner);
                int n = runner.runScript(innerScriptFile, scriptArgs, options);
                return n;
            }
            finally {
                this.wrapper.clearRunner();
            }
        }
        return 256;
    }

    @Override
    public IScriptRunner.EffectiveRunner getEffectiveRunner(String scriptFileOrFolder) {
        File scriptFile = new File(scriptFileOrFolder);
        File innerScriptFile = Runner.getScriptFile(scriptFile);
        if (null != innerScriptFile) {
            String innerScriptFilePath = innerScriptFile.getAbsolutePath();
            return new IScriptRunner.EffectiveRunner(Runner.getRunner(innerScriptFilePath), innerScriptFilePath, true);
        }
        return new IScriptRunner.EffectiveRunner(null, null, false);
    }

    @Override
    public boolean isAbortSupported() {
        return this.wrapper.isAbortSupported();
    }

    @Override
    protected void doAbort() {
        this.wrapper.doAbort();
    }
}

