/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.script.runners.ProcessRunner;
import org.sikuli.script.support.RunTime;

public class ExtensionManager {
    private static File sxExtensions = new File(RunTime.getAppPath(), "Extensions");
    private static String outerClassPath = System.getProperty("java.class.path");
    private static String separator = File.pathSeparator;
    private static String extensionClassPath = "";
    private static List<String> sxExtensionsFileContent = new ArrayList<String>();
    private static File sxExtensionsFile = null;
    static String jythonVersion = "2.7.1";
    private static boolean moveJython = false;
    private static boolean jythonReady = false;
    private static boolean jythonExtern = false;
    private static String python = "";
    private static String jrubyVersion = "9.2.0.0";
    private static boolean moveJRuby = false;
    private static boolean jrubyReady = false;
    private static boolean jrubyExtern = false;
    public static final String shebangPython = "#!PYTHON";
    public static final String shebangJython = "#!JYTHON";
    private static File sxSitesTxt = new File(RunTime.getAppPath(), "Lib/site-packages/sites.txt");
    static final int WARNING_CANCEL = 2;
    static final int WARNING_ACCEPTED = 1;
    static final int WARNING_DO_NOTHING = 0;
    private static ExtensionManager _instance = null;
    private ArrayList<Extension> extensions = new ArrayList();
    private File fExtensions = null;

    public static String makeClassPath(File jarFile) {
        RunTime.startLog(1, "starting with classpath: %.100s ...", outerClassPath);
        String jarPath = jarFile.getAbsolutePath();
        if (!outerClassPath.isEmpty()) {
            outerClassPath = outerClassPath.replace(jarPath, "");
            if ((outerClassPath = outerClassPath.replace(separator + separator, separator)).startsWith(separator)) {
                outerClassPath = outerClassPath.substring(1);
            }
        }
        extensionClassPath = jarPath;
        File[] sxFolderList = jarFile.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith(".jar")) {
                    if (name.contains("jython") && name.contains("standalone")) {
                        moveJython = true;
                        return true;
                    }
                    if (name.contains("jruby") && name.contains("complete")) {
                        moveJRuby = true;
                        return true;
                    }
                }
                return false;
            }
        });
        boolean extensionsOK = true;
        if (!sxExtensions.exists()) {
            sxExtensions.mkdir();
        }
        if (!sxExtensions.exists()) {
            RunTime.startLog(1, "folder extension not available: %s", sxExtensions);
            extensionsOK = false;
        }
        if (extensionsOK) {
            ExtensionManager.readExtensions(false);
            File[] fExtensions = sxExtensions.listFiles();
            if (moveJython || moveJRuby) {
                for (File fExtension : fExtensions) {
                    String name = fExtension.getName();
                    if ((!moveJython || !name.contains("jython") || !name.contains("standalone")) && (!moveJRuby || !name.contains("jruby") || !name.contains("complete"))) continue;
                    fExtension.delete();
                }
            }
            if (null != sxFolderList && sxFolderList.length > 0) {
                for (File fJar : sxFolderList) {
                    try {
                        Files.move(fJar.toPath(), sxExtensions.toPath().resolve(fJar.toPath().getFileName()), StandardCopyOption.REPLACE_EXISTING);
                        RunTime.startLog(1, "moving to extensions: %s", fJar);
                    }
                    catch (IOException e) {
                        RunTime.startLog(-1, "moving to extensions: %s (%s)", fJar, e.getMessage());
                    }
                }
            }
            for (File fExtension : fExtensions = sxExtensions.listFiles()) {
                String pExtension = fExtension.getAbsolutePath();
                if (!pExtension.endsWith(".jar")) continue;
                if (pExtension.contains("jython") && pExtension.contains("standalone")) {
                    if (jythonReady) continue;
                    if (pExtension.contains(jythonVersion)) {
                        jythonReady = true;
                    }
                } else if (pExtension.contains("jruby") && pExtension.contains("complete")) {
                    if (jrubyReady) continue;
                    if (pExtension.contains(jrubyVersion)) {
                        jrubyReady = true;
                    }
                } else {
                    if (pExtension.contains("py4j")) {
                        RunTime.get();
                        RunTime.startLog(-1, "Extension: py4j: not supported", new Object[0]);
                        continue;
                    }
                    if (extensionClassPath.contains(pExtension)) continue;
                }
                if (!extensionClassPath.isEmpty()) {
                    extensionClassPath = extensionClassPath + separator;
                }
                extensionClassPath = extensionClassPath + pExtension;
                RunTime.startLog(1, "adding extension file: %s", fExtension);
            }
        }
        String finalClassPath = outerClassPath;
        if (!extensionClassPath.isEmpty()) {
            finalClassPath = !outerClassPath.isEmpty() ? extensionClassPath + separator + outerClassPath : extensionClassPath;
        }
        if (!(jythonReady || jrubyReady || finalClassPath.toLowerCase().contains("jython") || finalClassPath.toLowerCase().contains("jruby"))) {
            String helpURL = "https://github.com/RaiMan/SikuliX1/wiki/How-to-make-Jython-ready-in-the-IDE";
            String message = "Neither Jython nor JRuby available\nPlease consult the docs for a solution.\n\nIDE might not be useable with JavaScript only";
            if (RunTime.isIDE()) {
                JOptionPane.showMessageDialog(null, message + "\n\nClick OK to get more help in a browser window", "IDE startup problem", 0);
                try {
                    Desktop.getDesktop().browse(new URI(helpURL));
                }
                catch (IOException iOException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return finalClassPath;
    }

    public static void readExtensions(boolean afterStart) {
        sxExtensionsFileContent = new ArrayList<String>();
        sxExtensionsFile = new File(sxExtensions, "extensions.txt");
        String txtExtensions = FileManager.readFileToString(sxExtensionsFile).trim();
        if (!txtExtensions.isEmpty()) {
            String[] lines = txtExtensions.split("\\n");
            String extlines = "";
            for (String line : lines) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
                extlines = extlines + line + "\n";
                sxExtensionsFileContent.add(line);
            }
            if (sxExtensionsFileContent.size() > 0) {
                RunTime.startLog(1, "extensions.txt\n%s", extlines.trim());
            }
        }
        if (sxExtensionsFileContent.size() == 0) {
            if (!afterStart) {
                RunTime.startLog(1, "no extensions.txt nor valid content", new Object[0]);
            }
            return;
        }
        for (String line : sxExtensionsFileContent) {
            File extFile;
            String token = "";
            String extPath = line;
            String[] lineParts = line.split("=");
            if (lineParts.length > 1) {
                token = lineParts[0].trim().toUpperCase();
                extPath = lineParts[1].trim();
            }
            if ((extFile = new File(extPath)).isAbsolute()) {
                if (!extFile.exists() || !extFile.getName().endsWith(".jar")) {
                    RunTime.startLog(-1, "extension path not valid: %s", line);
                    continue;
                }
            } else if (!(extFile = new File(sxExtensions, extFile.getPath())).exists() || !extFile.getName().endsWith(".jar")) {
                RunTime.startLog(-1, "extension path not valid: %s", line);
                continue;
            }
            if (!token.isEmpty()) {
                if ("JYTHON".equals(token)) {
                    if (afterStart) continue;
                    if (!extFile.getName().endsWith(".jar")) {
                        RunTime.startLog(-1, "Jython: extension is not jar: %s", line);
                        continue;
                    }
                    jythonReady = true;
                    ExtensionManager.setJythonExtern(true);
                }
                if ("JRUBY".equals(token)) {
                    if (afterStart) continue;
                    if (!extFile.getName().endsWith(".jar")) {
                        RunTime.startLog(-1, "JRuby: extension is not jar: %s", line);
                        continue;
                    }
                    jrubyReady = true;
                    ExtensionManager.setJrubyExtern(true);
                }
                if ("python".equals(token)) {
                    if (!afterStart) continue;
                    if (extFile.isAbsolute()) {
                        if (!extFile.exists()) continue;
                        RunTime.startLog(1, "Python available at: %s", extPath);
                        python = extPath;
                        continue;
                    }
                    String runOut = ProcessRunner.run(extPath, "-V");
                    if (!runOut.startsWith("0\n")) continue;
                    python = extPath;
                    RunTime.startLog(1, "Python available as command: %s (%s)", extPath, runOut.substring(2));
                    continue;
                }
            }
            if (afterStart) continue;
            if (!extensionClassPath.isEmpty()) {
                extensionClassPath = extensionClassPath + File.pathSeparator;
            }
            extensionClassPath = extensionClassPath + new File(extPath).getAbsolutePath();
            RunTime.startLog(1, "adding extension entry: %s", extPath);
        }
    }

    public static boolean hasExtensionsFile() {
        return sxExtensionsFile != null;
    }

    public static File getExtensionsFile() {
        return sxExtensionsFile;
    }

    public static String getExtensionsFileDefault() {
        return "# add absolute paths one per line, that point to other jars,\n# that need to be available on Java's classpath at runtime\n# They will be added automatically at startup in the given sequence\n\n# empty lines and lines beginning with # or // are ignored\n# delete the leading # to activate a prepared keyword line\n\n# pointer to a Jython install outside SikuliX\n# jython = c:/jython2.7.1/jython.jar\n\n# the Python executable as used on a commandline\n# activating will enable the support for real Python\n# python = python\n";
    }

    public static List<String> getExtensionNames() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (File extension : sxExtensions.listFiles()) {
            String name = extension.getName();
            if (name.startsWith(".") || !name.endsWith(".jar")) {
                if (!name.startsWith("extension_classpath.txt")) continue;
                extensions.add(0, name);
                ArrayList<String> classpath = new ArrayList<String>();
                List<String> content = Arrays.asList(FileManager.readFileToString(extension).split("\\n"));
                for (String line : content) {
                    if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                    classpath.add(line);
                }
                continue;
            }
            extensions.add(name);
        }
        return extensions;
    }

    public static boolean isJythonExtern() {
        return jythonExtern;
    }

    public static void setJythonExtern(boolean jythonExtern) {
        ExtensionManager.jythonExtern = jythonExtern;
    }

    public static boolean hasPython() {
        return !python.isEmpty();
    }

    public static String getPython() {
        return python;
    }

    public static boolean isJrubyExtern() {
        return jrubyExtern;
    }

    public static void setJrubyExtern(boolean jrubyExtern) {
        ExtensionManager.jrubyExtern = jrubyExtern;
    }

    public static boolean shouldCheckContent(String type, String identifier) {
        boolean usePython = false;
        if (type.contains("ython") && ExtensionManager.hasPython()) {
            if (type.equals(identifier)) {
                return true;
            }
            if (RunTime.shouldRunPythonServer()) {
                usePython = true;
            } else if (ExtensionManager.hasShebang(shebangPython, identifier)) {
                usePython = true;
            }
            if (usePython) {
                return "text/python".equals(type);
            }
            return "text/jython".equals(type);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasShebang(String type, String scriptFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(scriptFile), "UTF-8");){
            char[] chars = new char[type.length()];
            int read = reader.read(chars);
            if (read != type.length()) return false;
            if (!type.equals(new String(chars).toUpperCase())) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            if (scriptFile.length() < type.length()) return false;
            if (!type.equals(scriptFile.substring(0, type.length()).toUpperCase())) return false;
            return true;
        }
    }

    public static File getSitesTxt() {
        return sxSitesTxt;
    }

    public static String getSitesTxtDefault() {
        return "# add absolute paths one per line, that point to other directories/jars,\n# where importable modules (Jython, plain Python, SikuliX scripts, ...) can be found.\n# They will be added automatically at startup to the end of sys.path in the given sequence\n\n# lines beginning with # and blank lines are ignored and can be used as comments\n";
    }

    public static void show() {
        Object[] options;
        String title;
        int ret;
        String warn = "Nothing to do here currently - click what you like ;-)\n\nExtensions folder: \n" + sxExtensions + "\n\nCurrent content:";
        List<String> extensionNames = ExtensionManager.getExtensionNames();
        for (String extension : extensionNames) {
            warn = warn + "\n" + extension;
        }
        if (ExtensionManager.hasExtensionsFile()) {
            warn = warn + "\n\nextensions.txt content:";
            for (String extension : sxExtensionsFileContent) {
                warn = warn + "\n" + extension;
            }
        }
        if ((ret = JOptionPane.showOptionDialog(null, warn = warn + "\n\nsee menu File -> Open Special Files", title = "SikuliX1 Extensions", 0, 2, null, options = new String[]{"OK", "More ...", "Cancel"}, options[2])) == 2 || ret == -1) {
            return;
        }
    }

    private ExtensionManager() {
        this.fExtensions = RunTime.get().fSikulixExtensions;
        for (File d : this.fExtensions.listFiles()) {
            String version;
            if (!d.getAbsolutePath().endsWith(".jar")) continue;
            String path = d.getAbsolutePath();
            String name = d.getName();
            if ((name = name.substring(0, name.length() - 4)).contains("-")) {
                version = name.substring(name.lastIndexOf("-") + 1);
                name = name.substring(0, name.lastIndexOf("-"));
            } else {
                version = "0.0";
            }
            Extension e = new Extension(name, path, version);
            this.extensions.add(e);
        }
    }

    public static ExtensionManager getInstance() {
        if (_instance == null) {
            _instance = new ExtensionManager();
        }
        return _instance;
    }

    public boolean install(String name, String url, String version) {
        if (url.startsWith("---extensions---")) {
            // empty if block
        }
        String extPath = this.fExtensions.getAbsolutePath();
        String tmpdir = RunTime.get().fpBaseTempPath;
        try {
            File localFile = new File(FileManager.downloadURL(new URL(url), tmpdir));
            String extName = localFile.getName();
            File targetFile = new File(extPath, extName);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            if (!localFile.renameTo(targetFile)) {
                Debug.error("ExtensionManager: Failed to install " + localFile.getName() + " to " + targetFile.getAbsolutePath(), new Object[0]);
                return false;
            }
            this.addExtension(name, localFile.getAbsolutePath(), version);
        }
        catch (IOException e) {
            Debug.error("ExtensionManager: Failed to download " + url, new Object[0]);
            return false;
        }
        return true;
    }

    private void addExtension(String name, String path, String version) {
        Extension e = this.find(name, version);
        if (e == null) {
            this.extensions.add(new Extension(name, path, version));
        } else {
            e.path = path;
        }
    }

    public boolean isInstalled(String name) {
        return this.find(name) != null;
    }

    public String getLoadPath(String name) {
        Extension e = this.find(name);
        if (e != null) {
            Debug.log(2, "ExtensionManager: found: " + name + " ( " + e.version + " )", new Object[0]);
            return e.path;
        }
        if (!name.endsWith(".jar")) {
            Debug.error("ExtensionManager: not found: " + name, new Object[0]);
        }
        return null;
    }

    public boolean isOutOfDate(String name, String version) {
        String s2;
        Extension e = this.find(name);
        if (e == null) {
            return false;
        }
        String s1 = ExtensionManager.normalisedVersion(e.version);
        int cmp = s1.compareTo(s2 = ExtensionManager.normalisedVersion(version));
        return cmp < 0;
    }

    public String getVersion(String name) {
        Extension e = this.find(name);
        if (e != null) {
            return e.version;
        }
        return null;
    }

    private Extension find(String name) {
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.contains("-")) {
            String v = name.substring(name.lastIndexOf("-") + 1);
            return this.find(name.substring(0, name.lastIndexOf("-")), v);
        }
        String v = ExtensionManager.normalisedVersion("0.0");
        Extension ext = null;
        for (Extension e : this.extensions) {
            if (!e.name.equals(name) || v.compareTo(ExtensionManager.normalisedVersion(e.version)) > 0) continue;
            ext = e;
            v = ExtensionManager.normalisedVersion(e.version);
        }
        return ext;
    }

    private Extension find(String name, String version) {
        String v = ExtensionManager.normalisedVersion(version);
        for (Extension e : this.extensions) {
            if (!e.name.equals(name) || !ExtensionManager.normalisedVersion(e.version).equals(v)) continue;
            return e;
        }
        return null;
    }

    private static String normalisedVersion(String version) {
        return ExtensionManager.normalisedVersion(version, ".", 4);
    }

    private static String normalisedVersion(String version, String sep, int maxWidth) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(String.format("%" + maxWidth + 's', s));
        }
        return sb.toString();
    }

    static class Extension
    implements Serializable {
        public String name;
        public String path;
        public String version;

        public Extension(String name_, String path_, String version_) {
            this.name = name_;
            this.path = path_;
            this.version = version_;
        }
    }
}

