/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.io.File;
import java.io.PrintStream;
import org.sikuli.script.SikuliXception;

public interface IScriptRunner {
    public void init(String[] var1) throws SikuliXception;

    public int runScript(String var1, String[] var2, Options var3);

    public int evalScript(String var1, Options var2);

    public void runLines(String var1, Options var2);

    public boolean isSupported();

    public String getName();

    public String[] getExtensions();

    public String getDefaultExtension();

    public String getType();

    public boolean hasExtension(String var1);

    public void close();

    public void execBefore(String[] var1);

    public void execAfter(String[] var1);

    public boolean canHandle(String var1);

    public EffectiveRunner getEffectiveRunner(String var1);

    public void redirect(PrintStream var1, PrintStream var2);

    public void reset();

    public boolean isRunning();

    public void abort();

    public boolean isAborted();

    public boolean isAbortSupported();

    public String[] getFileEndings();

    public static class EffectiveRunner {
        private IScriptRunner runner = null;
        String script = null;
        private Boolean bundle = false;

        public EffectiveRunner() {
        }

        public EffectiveRunner(IScriptRunner runner, String script, Boolean bundle) {
            this.runner = runner;
            this.script = script;
            this.bundle = bundle;
        }

        public IScriptRunner getRunner() {
            return this.runner;
        }

        public String getScript() {
            return this.script;
        }

        public boolean isBundle() {
            return this.bundle == null || this.bundle != false;
        }

        public boolean isTempBundle() {
            return this.bundle == null;
        }
    }

    public static class Options {
        private boolean silent = false;
        private int errorLine = -1;
        private boolean runningInIDE = false;
        private boolean runningFromScript = false;
        private long timeout = 0L;
        private File baseFolder = null;

        public boolean isSilent() {
            return this.silent;
        }

        public Options setSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public int getErrorLine() {
            return this.errorLine;
        }

        public Options setErrorLine(int errorLine) {
            this.errorLine = errorLine;
            return this;
        }

        public boolean isRunningInIDE() {
            return this.runningInIDE;
        }

        public Options setRunningInIDE() {
            this.runningInIDE = true;
            return this;
        }

        public boolean isRunningFromScript() {
            return this.runningFromScript;
        }

        public Options setRunningFromScript() {
            this.runningFromScript = true;
            return this;
        }

        public void setRunningInIDE(boolean runningInIDE) {
            this.runningInIDE = runningInIDE;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public Options setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public File getBaseFolder() {
            return this.baseFolder;
        }

        public void setBaseFolder(File baseFolder) {
            this.baseFolder = baseFolder;
        }
    }
}

