/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.sikuli.basics.Debug;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.basics.Settings;

public class SikulixFileChooser {
    static final int FILES = 0;
    static final int DIRS = 1;
    static final int DIRSANDFILES = 2;
    static final int SAVE = 1;
    static final int LOAD = 0;
    private Frame parentFrame;
    private boolean fromPopFile = false;

    public SikulixFileChooser(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    private String getLastDir() {
        return PreferencesUser.get().get("LAST_OPEN_DIR", "");
    }

    public File open() {
        File selectedFile = this.show("Open a file or folder", 0, 2, new Object[0]);
        return selectedFile;
    }

    public File open(String title) {
        File selectedFile = this.show(title, 0, 2, new Object[0]);
        return selectedFile;
    }

    public File save() {
        File selectedFile = this.show("Save a File or Folder", 1, 2, new Object[0]);
        return selectedFile;
    }

    public File saveAs(String extension, boolean isBundle) {
        File selectedFile = isBundle ? this.show("Save as .sikuli, folder or file", 1, 2, new SXFilter("as file", extension), new SXFilter("as plain folder", "d"), new SXFilter("as folder.sikuli", "s")) : this.show("Save as .sikuli, folder or file", 1, 2, new SXFilter("as file", extension));
        return selectedFile;
    }

    public File export() {
        String title = "Export packed as .skl or .zip";
        File ret = this.show(title, 1, 0, new Object[0]);
        return ret;
    }

    public File loadImage() {
        File ret = this.show("Load Image File", 0, 0, new FileNameExtensionFilter("Image files (jpg, png)", "jpg", "jpeg", "png"));
        return ret;
    }

    private File show(final String title, final int mode, final int theSelectionMode, Object ... filters) {
        Debug.log(3, "SikulixFileChooser: %s at %s", new Object[]{title.split(" ")[0], this.getLastDir()});
        final Object[] genericFilters = filters;
        final Object[] result = new Object[]{null, null};
        if (this.fromPopFile) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SikulixFileChooser.this.processDialog(theSelectionMode, SikulixFileChooser.this.getLastDir(), title, mode, genericFilters, result);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.processDialog(theSelectionMode, this.getLastDir(), title, mode, filters, result);
            if (filters.length == 0) {
                result[1] = new SXFilter("", "g");
            }
        }
        if (null != result[0]) {
            File fileChosen = (File)result[0];
            PreferencesUser.get().put("LAST_OPEN_DIR", fileChosen.getParent());
            if (result[1] != null && result[1].getClass().equals(SXFilter.class)) {
                SXFilter filter = (SXFilter)result[1];
                if (filter.isType("g")) {
                    if (fileChosen.getName().equals(fileChosen.getParentFile().getName())) {
                        fileChosen = fileChosen.getParentFile();
                    }
                } else if (filter.isType("s")) {
                    if (FilenameUtils.getExtension((String)fileChosen.getName()).equals("")) {
                        fileChosen = new File(fileChosen.getAbsolutePath() + ".sikuli");
                    } else if (!FilenameUtils.getExtension((String)fileChosen.getName()).equals("sikuli")) {
                        fileChosen = new File(FilenameUtils.removeExtension((String)fileChosen.getAbsolutePath()) + ".sikuli");
                    }
                } else if (filter.isType("d")) {
                    fileChosen = new File(FilenameUtils.removeExtension((String)fileChosen.getAbsolutePath()));
                } else if (filter.isType("f")) {
                    fileChosen = new File(FilenameUtils.removeExtension((String)fileChosen.getAbsolutePath()) + filter.getExtension());
                } else {
                    return null;
                }
            }
            return fileChosen;
        }
        Debug.log(-1, "SikulixFileChooser: action cancelled or did not work", new Object[0]);
        return null;
    }

    private void processDialog(int selectionMode, String last_dir, String title, int mode, Object[] filters, Object[] result) {
        int dialogResponse;
        JFileChooser fchooser = new JFileChooser();
        File fileChoosen = null;
        Object filterChoosen = null;
        if (!last_dir.isEmpty()) {
            fchooser.setCurrentDirectory(new File(last_dir));
        }
        fchooser.setSelectedFile(null);
        fchooser.setDialogTitle(title);
        String btnApprove = "Select";
        if (this.fromPopFile) {
            fchooser.setFileSelectionMode(2);
            fchooser.setAcceptAllFileFilterUsed(true);
        } else {
            fchooser.setFileSelectionMode(selectionMode);
            if (mode == 1) {
                fchooser.setDialogType(1);
                btnApprove = "Save";
            }
            if (filters.length == 0) {
                fchooser.setAcceptAllFileFilterUsed(true);
            } else {
                fchooser.setAcceptAllFileFilterUsed(false);
                for (Object filter : filters) {
                    fchooser.setFileFilter((FileFilter)filter);
                }
            }
        }
        if (Settings.isMac()) {
            fchooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
        }
        fileChoosen = (dialogResponse = fchooser.showDialog(this.parentFrame, btnApprove)) != 0 ? null : fchooser.getSelectedFile();
        result[0] = fileChoosen;
        if (filters.length > 0) {
            result[1] = fchooser.getFileFilter();
        }
    }

    class SXFilter
    extends FileFilter {
        public static final String SIKULI = "s";
        public static final String FOLDER = "d";
        public static final String FILE = "f";
        public static final String GENERIC = "g";
        private String type;
        private String description;
        private String extension;

        public SXFilter(String description, String type) {
            this.type = type;
            if (type != SIKULI && type != FOLDER && type != GENERIC) {
                this.extension = type;
                this.type = FILE;
            }
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public boolean isType(String type) {
            return this.type.equals(type);
        }

        public String getExtension() {
            return "." + this.extension;
        }
    }
}

