/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.report;

import com.sksamuel.hoplite.BooleanNode;
import com.sksamuel.hoplite.DoubleNode;
import com.sksamuel.hoplite.LongNode;
import com.sksamuel.hoplite.NullNode;
import com.sksamuel.hoplite.PrimitiveNode;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.report.HashObfuscator;
import com.sksamuel.hoplite.report.Obfuscator;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/sksamuel/hoplite/report/HashObfuscator;", "Lcom/sksamuel/hoplite/report/Obfuscator;", "()V", "obfuscate", "", "node", "Lcom/sksamuel/hoplite/PrimitiveNode;", "hoplite-core"})
public final class HashObfuscator
implements Obfuscator {
    @NotNull
    public static final HashObfuscator INSTANCE = new HashObfuscator();

    private HashObfuscator() {
    }

    @Override
    @NotNull
    public String obfuscate(@NotNull PrimitiveNode node2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        PrimitiveNode primitiveNode = node2;
        if (primitiveNode instanceof BooleanNode) {
            string = String.valueOf(((BooleanNode)node2).getValue());
        } else if (primitiveNode instanceof NullNode) {
            string = String.valueOf(node2.getValue());
        } else if (primitiveNode instanceof DoubleNode) {
            string = String.valueOf(((DoubleNode)node2).getValue());
        } else if (primitiveNode instanceof LongNode) {
            string = String.valueOf(((LongNode)node2).getValue());
        } else {
            if (primitiveNode instanceof StringNode) {
                Double maybeDouble;
                Long maybeLong;
                Boolean maybeBoolean;
                Boolean bl = maybeBoolean = StringsKt.toBooleanStrictOrNull((String)((StringNode)node2).getValue());
                if (bl != null) {
                    return bl.toString();
                }
                Long l = maybeLong = StringsKt.toLongOrNull((String)((StringNode)node2).getValue());
                if (l != null) {
                    return l.toString();
                }
                Double d = maybeDouble = StringsKt.toDoubleOrNull((String)((StringNode)node2).getValue());
                if (d != null) {
                    return d.toString();
                }
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] byArray = digest.digest(StringsKt.encodeToByteArray((String)((StringNode)node2).getValue()));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest\n          .digest\u2026alue.encodeToByteArray())");
                return CollectionsKt.joinToString$default((Iterable)ArraysKt.take((byte[])byArray, (int)8), (CharSequence)"", (CharSequence)"hash(", (CharSequence)"...)", (int)0, null, (Function1)obfuscate.1.INSTANCE, (int)24, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

