/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

public class FileSummary
implements Loggable,
Cloneable {
    public int totalCount;
    public int totalSize;
    public int totalINCount;
    public int totalINSize;
    public int totalLNCount;
    public int totalLNSize;
    public int maxLNSize;
    public int obsoleteINCount;
    public int obsoleteLNCount;
    public int obsoleteLNSize;
    public int obsoleteLNSizeCounted;

    public FileSummary clone() {
        try {
            return (FileSummary)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this.totalCount == 0 && this.totalSize == 0 && this.obsoleteINCount == 0 && this.obsoleteLNCount == 0;
    }

    public int getObsoleteLNSize() {
        return this.getObsoleteLNSize(Float.NaN);
    }

    public int getObsoleteLNSize(float obsoleteLNSizeCorrectionFactor) {
        if (this.totalLNCount == 0) {
            return 0;
        }
        int obsLNCount = Math.min(this.obsoleteLNCount, this.totalLNCount);
        int obsLNSize = Math.min(this.obsoleteLNSize, this.totalLNSize);
        int obsLNSizeCounted = Math.min(this.obsoleteLNSizeCounted, obsLNCount);
        long obsSize = obsLNSize;
        int obsCountNotCounted = obsLNCount - obsLNSizeCounted;
        if (obsCountNotCounted > 0) {
            float avgLNSizeNotCounted;
            if (Float.isNaN(obsoleteLNSizeCorrectionFactor)) {
                obsoleteLNSizeCorrectionFactor = 1.0f;
            }
            if (!Float.isNaN(avgLNSizeNotCounted = this.getAvgObsoleteLNSizeNotCounted() * obsoleteLNSizeCorrectionFactor)) {
                obsSize += (long)((int)((float)obsCountNotCounted * avgLNSizeNotCounted));
            }
        }
        return obsSize > (long)this.totalLNSize ? this.totalLNSize : (int)obsSize;
    }

    public float getAvgObsoleteLNSizeNotCounted() {
        int obsLNCount = Math.min(this.obsoleteLNCount, this.totalLNCount);
        int obsLNSize = Math.min(this.obsoleteLNSize, this.totalLNSize);
        int obsLNSizeCounted = Math.min(this.obsoleteLNSizeCounted, obsLNCount);
        int obsCountNotCounted = obsLNCount - obsLNSizeCounted;
        if (obsCountNotCounted <= 0) {
            return Float.NaN;
        }
        int totalSizeNotCounted = this.totalLNSize - obsLNSize;
        int totalCountNotCounted = this.totalLNCount - obsLNSizeCounted;
        if (totalSizeNotCounted <= 0 || totalCountNotCounted <= 0) {
            return Float.NaN;
        }
        return (float)totalSizeNotCounted / (float)totalCountNotCounted;
    }

    public int getMaxObsoleteLNSize() {
        if (this.maxLNSize == 0) {
            return this.getObsoleteLNSize();
        }
        if (this.totalLNCount == 0) {
            return 0;
        }
        int obsLNCount = Math.min(this.obsoleteLNCount, this.totalLNCount);
        int obsLNSize = Math.min(this.obsoleteLNSize, this.totalLNSize);
        int obsLNSizeCounted = Math.min(this.obsoleteLNSizeCounted, obsLNCount);
        long obsSize = obsLNSize;
        long obsCountNotCounted = obsLNCount - obsLNSizeCounted;
        if (obsCountNotCounted > 0L) {
            long maxLNSizeNotCounted = obsCountNotCounted * (long)this.maxLNSize;
            long maxObsSizeNotCounted = this.totalLNSize - obsLNSize - (this.totalLNCount - obsLNCount) * 16;
            obsSize += Math.min(maxLNSizeNotCounted, maxObsSizeNotCounted);
        }
        return obsSize > (long)this.totalLNSize ? this.totalLNSize : (int)obsSize;
    }

    public int getObsoleteINSize() {
        if (this.totalINCount == 0) {
            return 0;
        }
        int obsINCount = Math.min(this.obsoleteINCount, this.totalINCount);
        float size = this.totalINSize;
        float avgSizePerIN = size / (float)this.totalINCount;
        return (int)((float)obsINCount * avgSizePerIN);
    }

    public int getObsoleteSize() {
        return this.calculateObsoleteSize(this.getObsoleteLNSize());
    }

    public int getObsoleteSize(float obsoleteLNSizeCorrectionFactor) {
        return this.calculateObsoleteSize(this.getObsoleteLNSize(obsoleteLNSizeCorrectionFactor));
    }

    public int getMaxObsoleteSize() {
        return this.calculateObsoleteSize(this.getMaxObsoleteLNSize());
    }

    private int calculateObsoleteSize(int lnObsoleteSize) {
        if (this.totalSize > 0) {
            int leftoverSize = this.totalSize - (this.totalINSize + this.totalLNSize);
            int obsoleteSize = lnObsoleteSize + this.getObsoleteINSize() + leftoverSize;
            if (obsoleteSize > this.totalSize) {
                obsoleteSize = this.totalSize;
            }
            return obsoleteSize;
        }
        return 0;
    }

    public int getEntriesCounted() {
        return this.totalCount + this.obsoleteLNCount + this.obsoleteINCount;
    }

    public int getNonObsoleteCount() {
        return this.totalLNCount + this.totalINCount - this.obsoleteLNCount - this.obsoleteINCount;
    }

    public int utilization() {
        return FileSummary.utilization(this.getObsoleteSize(), this.totalSize);
    }

    public int utilization(float obsoleteLNSizeCorrectionFactor) {
        return FileSummary.utilization(this.getObsoleteSize(obsoleteLNSizeCorrectionFactor), this.totalSize);
    }

    public static int utilization(long obsoleteSize, long totalSize) {
        if (totalSize == 0L) {
            return 0;
        }
        return Math.round(100.0f * (float)(totalSize - obsoleteSize) / (float)totalSize);
    }

    public void reset() {
        this.totalCount = 0;
        this.totalSize = 0;
        this.totalINCount = 0;
        this.totalINSize = 0;
        this.totalLNCount = 0;
        this.totalLNSize = 0;
        this.maxLNSize = 0;
        this.obsoleteINCount = 0;
        this.obsoleteLNCount = 0;
        this.obsoleteLNSize = 0;
        this.obsoleteLNSizeCounted = 0;
    }

    public void add(FileSummary o) {
        this.totalCount += o.totalCount;
        this.totalSize += o.totalSize;
        this.totalINCount += o.totalINCount;
        this.totalINSize += o.totalINSize;
        this.totalLNCount += o.totalLNCount;
        this.totalLNSize += o.totalLNSize;
        if (this.maxLNSize < o.maxLNSize) {
            this.maxLNSize = o.maxLNSize;
        }
        this.obsoleteINCount += o.obsoleteINCount;
        this.obsoleteLNCount += o.obsoleteLNCount;
        this.obsoleteLNSize += o.obsoleteLNSize;
        this.obsoleteLNSizeCounted += o.obsoleteLNSizeCounted;
    }

    public int getLogSize() {
        return 11 * LogUtils.getIntLogSize();
    }

    public void writeToLog(ByteBuffer buf) {
        LogUtils.writeInt(buf, this.totalCount);
        LogUtils.writeInt(buf, this.totalSize);
        LogUtils.writeInt(buf, this.totalINCount);
        LogUtils.writeInt(buf, this.totalINSize);
        LogUtils.writeInt(buf, this.totalLNCount);
        LogUtils.writeInt(buf, this.totalLNSize);
        LogUtils.writeInt(buf, this.maxLNSize);
        LogUtils.writeInt(buf, this.obsoleteINCount);
        LogUtils.writeInt(buf, this.obsoleteLNCount);
        LogUtils.writeInt(buf, this.obsoleteLNSize);
        LogUtils.writeInt(buf, this.obsoleteLNSizeCounted);
    }

    public void readFromLog(ByteBuffer buf, int entryVersion) {
        this.totalCount = LogUtils.readInt(buf);
        this.totalSize = LogUtils.readInt(buf);
        this.totalINCount = LogUtils.readInt(buf);
        this.totalINSize = LogUtils.readInt(buf);
        this.totalLNCount = LogUtils.readInt(buf);
        this.totalLNSize = LogUtils.readInt(buf);
        if (entryVersion >= 8) {
            this.maxLNSize = LogUtils.readInt(buf);
        }
        this.obsoleteINCount = LogUtils.readInt(buf);
        if (this.obsoleteINCount == -1) {
            this.obsoleteINCount = this.totalINCount;
        }
        this.obsoleteLNCount = LogUtils.readInt(buf);
        if (entryVersion >= 3) {
            this.obsoleteLNSize = LogUtils.readInt(buf);
            this.obsoleteLNSizeCounted = LogUtils.readInt(buf);
        } else {
            this.obsoleteLNSize = 0;
            this.obsoleteLNSizeCounted = 0;
        }
    }

    public void dumpLog(StringBuilder buf, boolean verbose) {
        buf.append("<summary totalCount=\"");
        buf.append(this.totalCount);
        buf.append("\" totalSize=\"");
        buf.append(this.totalSize);
        buf.append("\" totalINCount=\"");
        buf.append(this.totalINCount);
        buf.append("\" totalINSize=\"");
        buf.append(this.totalINSize);
        buf.append("\" totalLNCount=\"");
        buf.append(this.totalLNCount);
        buf.append("\" totalLNSize=\"");
        buf.append(this.totalLNSize);
        buf.append("\" maxLNSize=\"");
        buf.append(this.maxLNSize);
        buf.append("\" obsoleteINCount=\"");
        buf.append(this.obsoleteINCount);
        buf.append("\" obsoleteLNCount=\"");
        buf.append(this.obsoleteLNCount);
        buf.append("\" obsoleteLNSize=\"");
        buf.append(this.obsoleteLNSize);
        buf.append("\" obsoleteLNSizeCounted=\"");
        buf.append(this.obsoleteLNSizeCounted);
        buf.append("\" getObsoleteSize=\"");
        buf.append(this.getObsoleteSize());
        buf.append("\" getObsoleteINSize=\"");
        buf.append(this.getObsoleteINSize());
        buf.append("\" getObsoleteLNSize=\"");
        buf.append(this.getObsoleteLNSize());
        buf.append("\" getMaxObsoleteSize=\"");
        buf.append(this.getMaxObsoleteSize());
        buf.append("\" getMaxObsoleteLNSize=\"");
        buf.append(this.getMaxObsoleteLNSize());
        buf.append("\" getAvgObsoleteLNSizeNotCounted=\"");
        buf.append(this.getAvgObsoleteLNSizeNotCounted());
        buf.append("\"/>");
    }

    public long getTransactionId() {
        return 0L;
    }

    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.dumpLog(buf, true);
        return buf.toString();
    }
}

