/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.LSNAccumulator;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.SizeofMarker;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedLSNTreeWalker {
    protected final DatabaseImpl[] dbImpls;
    protected final EnvironmentImpl envImpl;
    private final long[] rootLsns;
    private final boolean setDbState;
    private long internalMemoryLimit = Long.MAX_VALUE;
    private long internalMemoryUsage;
    private final TreeNodeProcessor callback;
    protected boolean accumulateLNs = false;
    protected boolean accumulateDupLNs = false;
    private final List<DatabaseException> savedExceptions;
    private final ExceptionPredicate excPredicate;
    private long lsnBatchSize = Long.MAX_VALUE;
    private final DatabaseEntry lnKeyEntry = new DatabaseEntry();
    private final Map<Long, INEntry> lsnINMap = new HashMap<Long, INEntry>();

    public SortedLSNTreeWalker(DatabaseImpl[] dbImpls, boolean setDbState, long[] rootLsns, TreeNodeProcessor callback, List<DatabaseException> savedExceptions, ExceptionPredicate excPredicate) throws DatabaseException {
        if (dbImpls == null || dbImpls.length < 1) {
            throw EnvironmentFailureException.unexpectedState("DatabaseImpls array is null or 0-length for SortedLSNTreeWalker");
        }
        this.dbImpls = dbImpls;
        this.envImpl = dbImpls[0].getDbEnvironment();
        for (DatabaseImpl di : dbImpls) {
            EnvironmentImpl ei = di.getDbEnvironment();
            if (ei == null) {
                throw EnvironmentFailureException.unexpectedState("environmentImpl is null for target db " + di.getDebugName());
            }
            if (ei == this.envImpl) continue;
            throw new IllegalArgumentException("Environment.preload() must be called with Databases which are all in the same Environment. (" + di.getDebugName() + ")");
        }
        this.setDbState = setDbState;
        this.rootLsns = rootLsns;
        this.callback = callback;
        this.savedExceptions = savedExceptions;
        this.excPredicate = excPredicate;
    }

    void setLSNBatchSize(long lsnBatchSize) {
        this.lsnBatchSize = lsnBatchSize;
    }

    void setInternalMemoryLimit(long internalMemoryLimit) {
        this.internalMemoryLimit = internalMemoryLimit;
    }

    void incInternalMemoryUsage(long increment) {
        this.internalMemoryUsage += increment;
    }

    private LSNAccumulator createLSNAccumulator() {
        return new LSNAccumulator(){

            void noteMemUsage(long increment) {
                SortedLSNTreeWalker.this.incInternalMemoryUsage(increment);
            }
        };
    }

    public void walk() throws DatabaseException {
        this.walkInternal();
    }

    protected void walkInternal() throws DatabaseException {
        LSNAccumulator pendingLSNs = this.createLSNAccumulator();
        for (int i = 0; i < this.dbImpls.length; ++i) {
            this.processRootLSN(this.dbImpls[i], pendingLSNs, this.rootLsns[i]);
        }
        this.processAccumulatedLSNs(pendingLSNs);
    }

    protected void processAccumulatedLSNs(LSNAccumulator pendingLSNs) {
        long[] currentLSNs = null;
        while (!pendingLSNs.isEmpty()) {
            currentLSNs = pendingLSNs.getAndSortPendingLSNs();
            pendingLSNs = this.createLSNAccumulator();
            for (long lsn : currentLSNs) {
                this.fetchAndProcessLSN(lsn, pendingLSNs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRootLSN(DatabaseImpl dbImpl, LSNAccumulator pendingLSNs, long rootLsn) {
        IN root = this.getOrFetchRootIN(dbImpl, rootLsn);
        if (root != null) {
            try {
                this.accumulateLSNs(root, pendingLSNs);
                Object var7_5 = null;
                this.releaseRootIN(root);
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.releaseRootIN(root);
                throw throwable;
            }
        }
        if (this.setDbState) {
            dbImpl.finishedINListHarvest();
        }
    }

    protected void accumulateLSNs(IN in, LSNAccumulator pendingLSNs) throws DatabaseException {
        boolean allChildrenAreLNs;
        boolean accumulateChildren = true;
        DatabaseImpl db = in.getDatabase();
        boolean dups = db.getSortedDuplicates();
        if (!dups || db.getDupsConverted()) {
            allChildrenAreLNs = in.isBIN();
        } else {
            boolean bl = allChildrenAreLNs = in.isBIN() && (!dups || in.containsDuplicates());
        }
        if (allChildrenAreLNs) {
            accumulateChildren = dups ? this.accumulateDupLNs : this.accumulateLNs;
        }
        for (int i = 0; i < in.getNEntries(); ++i) {
            byte[] lnKey;
            long lsn = in.getLsn(i);
            Node node = in.getTarget(i);
            boolean nodeInCache = node != null;
            Object object = lnKey = (Object)(!nodeInCache || node.isLN() ? in.getKey(i) : null);
            if (in.isEntryPendingDeleted(i) || in.isEntryKnownDeleted(i)) {
                this.processDirtyLN(node, lsn, lnKey);
                continue;
            }
            if (accumulateChildren && !nodeInCache && lsn != -1L) {
                boolean internalMemoryExceeded;
                pendingLSNs.add(lsn);
                this.addToLsnINMap(lsn, in, i);
                boolean bl = internalMemoryExceeded = this.internalMemoryUsage > this.internalMemoryLimit;
                if ((long)pendingLSNs.getNTotalEntries() <= this.lsnBatchSize && !internalMemoryExceeded) continue;
                if (internalMemoryExceeded) {
                    this.callback.noteMemoryExceeded();
                }
                this.processAccumulatedLSNs(pendingLSNs);
                pendingLSNs.clear();
                continue;
            }
            this.processResidentChild(lsn, node, lnKey, pendingLSNs);
        }
    }

    private void processDirtyLN(Node node, long lsn, byte[] lnKey) {
        LN ln;
        if (node != null && node.isLN() && (ln = (LN)node).isDirty()) {
            this.callback.processDirtyDeletedLN(lsn, ln, lnKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResidentChild(long lsn, Node node, byte[] lnKey, LSNAccumulator pendingLSNs) {
        boolean nodeInCache = node != null;
        this.callProcessLSNHandleExceptions(lsn, !nodeInCache ? LogEntryType.LOG_INS_LN : node.getGenericLogType(), node, lnKey);
        if (nodeInCache && node.isIN()) {
            IN nodeAsIN = (IN)node;
            try {
                nodeAsIN.latch(CacheMode.UNCHANGED);
                this.accumulateLSNs(nodeAsIN, pendingLSNs);
                Object var9_7 = null;
                nodeAsIN.releaseLatch();
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                nodeAsIN.releaseLatch();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndProcessLSN(long lsn, LSNAccumulator pendingLSNs) throws DatabaseException {
        this.lnKeyEntry.setData(null);
        Node node = this.fetchLSNHandleExceptions(lsn, this.lnKeyEntry, pendingLSNs);
        if (node == null) {
            return;
        }
        boolean isIN = node instanceof IN;
        IN in = null;
        try {
            if (isIN) {
                in = (IN)node;
                in.latch(CacheMode.UNCHANGED);
            }
            this.callProcessLSNHandleExceptions(lsn, node.getGenericLogType(), node, this.lnKeyEntry.getData());
            if (isIN) {
                this.accumulateLSNs(in, pendingLSNs);
            }
            Object var8_6 = null;
            if (isIN) {
                in.releaseLatch();
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (isIN) {
                in.releaseLatch();
            }
            throw throwable;
        }
    }

    private Node fetchLSNHandleExceptions(long lsn, DatabaseEntry lnKeyEntry, LSNAccumulator pendingLSNs) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                return this.fetchLSN(lsn, lnKeyEntry, pendingLSNs);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
        return null;
    }

    protected void callProcessLSNHandleExceptions(long childLSN, LogEntryType childType, Node theNode, byte[] lnKey) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                this.callback.processLSN(childLSN, childType, theNode, lnKey);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
    }

    protected IN getOrFetchRootIN(DatabaseImpl dbImpl, long rootLsn) {
        IN root = this.getResidentRootIN(dbImpl);
        if (root != null) {
            return root;
        }
        if (rootLsn == -1L) {
            return null;
        }
        return this.getRootIN(dbImpl, rootLsn);
    }

    protected IN getRootIN(DatabaseImpl dbImpl, long rootLsn) {
        IN root = (IN)this.envImpl.getLogManager().getEntryHandleFileNotFound(rootLsn);
        if (root == null) {
            return null;
        }
        root.latchShared(CacheMode.DEFAULT);
        root.setDatabase(dbImpl);
        return root;
    }

    protected IN getResidentRootIN(DatabaseImpl dbImpl) {
        return dbImpl.getTree().getResidentRootIN(true);
    }

    protected void releaseRootIN(IN root) {
        root.releaseLatch();
    }

    private void addToLsnINMap(long lsn, IN in, int index) {
        this.addEntryToLsnMap(lsn, new INEntry(in, index));
    }

    private void addToLsnINMap(long lsn, IN in, int index, BINDelta delta, long deltaLsn) {
        this.addEntryToLsnMap(lsn, new DeltaINEntry(in, index, delta, deltaLsn));
    }

    private void addEntryToLsnMap(long lsn, INEntry inEntry) {
        if (this.lsnINMap.put(lsn, inEntry) == null) {
            this.incInternalMemoryUsage(inEntry.getMemorySize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node fetchLSN(long lsn, DatabaseEntry lnKeyEntry, LSNAccumulator pendingLSNs) throws FileNotFoundException, DatabaseException {
        BINDelta delta;
        LogEntry entry;
        int index;
        boolean isLatchedAlready;
        IN in;
        INEntry inEntry;
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            inEntry = this.lsnINMap.remove(lsn);
                            assert (inEntry != null) : DbLsn.getNoFormatString(lsn);
                            this.incInternalMemoryUsage(-inEntry.getMemorySize());
                            in = inEntry.in;
                            isLatchedAlready = in.isLatchOwnerForWrite();
                            if (!isLatchedAlready) {
                                in.latch();
                            }
                            try {
                                index = inEntry.index;
                                if (!in.isEntryPendingDeleted(index) && !in.isEntryKnownDeleted(index)) break block23;
                                Node node = null;
                                Object var19_12 = null;
                                if (!isLatchedAlready) {
                                    in.releaseLatch();
                                }
                                return node;
                            }
                            catch (Throwable throwable) {
                                block28: {
                                    Object var19_18 = null;
                                    if (isLatchedAlready) break block28;
                                    in.releaseLatch();
                                }
                                throw throwable;
                            }
                        }
                        if (inEntry.getDelta() != null) break block24;
                        if (in.getLsn(index) != lsn) {
                            Node node = null;
                            Object var19_13 = null;
                            if (!isLatchedAlready) {
                                in.releaseLatch();
                            }
                            return node;
                        }
                        break block25;
                    }
                    if (in.getLsn(index) == inEntry.getDeltaLsn()) break block25;
                    Node node = null;
                    Object var19_14 = null;
                    if (!isLatchedAlready) {
                        in.releaseLatch();
                    }
                    return node;
                }
                Node residentNode = in.getTarget(index);
                if (residentNode == null) break block26;
                if (residentNode.isLN()) {
                    lnKeyEntry.setData(in.getKey(index));
                }
                Node node = residentNode;
                Object var19_15 = null;
                if (!isLatchedAlready) {
                    in.releaseLatch();
                }
                return node;
            }
            entry = this.envImpl.getLogManager().getLogEntry(lsn);
            if (!(entry instanceof BINDeltaLogEntry)) break block27;
            BINDelta delta2 = (BINDelta)entry.getMainItem();
            long fullLsn = delta2.getLastFullLsn();
            pendingLSNs.add(fullLsn);
            this.addToLsnINMap(fullLsn, in, index, delta2, lsn);
            Node node = null;
            Object var19_16 = null;
            if (!isLatchedAlready) {
                in.releaseLatch();
            }
            return node;
        }
        DatabaseImpl dbImpl = in.getDatabase();
        byte[] lnKey = null;
        if (entry instanceof LNLogEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            lnEntry.postFetchInit(dbImpl);
            lnKey = lnEntry.getKey();
            lnKeyEntry.setData(lnKey);
        }
        Node ret = (Node)entry.getResolvedItem(dbImpl);
        long lastLoggedLsn = lsn;
        if (ret instanceof IN) {
            IN retIn = (IN)ret;
            retIn.setDatabase(dbImpl);
        }
        if ((delta = inEntry.getDelta()) != null) {
            assert (lsn == delta.getLastFullLsn());
            assert (ret instanceof BIN);
            delta.reconstituteBIN(dbImpl, (BIN)ret);
            lastLoggedLsn = inEntry.getDeltaLsn();
        }
        if (this.fetchAndInsertIntoTree()) {
            ret.postFetchInit(dbImpl, lastLoggedLsn);
            in.updateNode(index, ret, lnKey);
        }
        Node node = ret;
        Object var19_17 = null;
        if (!isLatchedAlready) {
            in.releaseLatch();
        }
        return node;
    }

    protected boolean fetchAndInsertIntoTree() {
        return false;
    }

    public List<DatabaseException> getSavedExceptions() {
        return this.savedExceptions;
    }

    public static class DeltaINEntry
    extends INEntry {
        private final BINDelta delta;
        private final long deltaLsn;

        DeltaINEntry(IN in, int index, BINDelta delta, long deltaLsn) {
            super(in, index);
            assert (delta != null);
            assert (deltaLsn != -1L);
            this.delta = delta;
            this.deltaLsn = deltaLsn;
        }

        public DeltaINEntry(SizeofMarker marker) {
            super(marker);
            this.delta = null;
            this.deltaLsn = 0L;
        }

        BINDelta getDelta() {
            return this.delta;
        }

        long getDeltaLsn() {
            return this.deltaLsn;
        }

        long getMemorySize() {
            return (long)(MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.DELTAINENTRY_OVERHEAD) + this.delta.getMemorySize();
        }
    }

    public static class INEntry {
        final IN in;
        final int index;

        INEntry(IN in, int index) {
            assert (in != null);
            assert (in.getDatabase() != null);
            this.in = in;
            this.index = index;
        }

        public INEntry(SizeofMarker marker) {
            this.in = null;
            this.index = 0;
        }

        BINDelta getDelta() {
            return null;
        }

        long getDeltaLsn() {
            return -1L;
        }

        long getMemorySize() {
            return MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.INENTRY_OVERHEAD;
        }
    }

    public static interface ExceptionPredicate {
        public boolean ignoreException(Exception var1);
    }

    public static interface TreeNodeProcessor {
        public void processLSN(long var1, LogEntryType var3, Node var4, byte[] var5) throws FileNotFoundException, DatabaseException;

        public void processDirtyDeletedLN(long var1, LN var3, byte[] var4) throws DatabaseException;

        public void noteMemoryExceeded();
    }
}

