/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.PrivateSelector;
import com.sleepycat.je.evictor.TargetSelector;
import java.util.HashMap;
import java.util.Map;

public class PrivateEvictor
extends Evictor {
    public PrivateEvictor(EnvironmentImpl envImpl) {
        super(envImpl);
    }

    TargetSelector makeSelector() {
        return new PrivateSelector(this.envImpl);
    }

    Evictor.DbCache createDbCache() {
        return new Evictor.DbCache(){
            final Map<DatabaseId, DatabaseImpl> map = new HashMap<DatabaseId, DatabaseImpl>();
            int nOperations = 0;

            public DatabaseImpl getDb(EnvironmentImpl envImpl, DatabaseId dbId) {
                assert (envImpl == PrivateEvictor.this.envImpl);
                ++this.nOperations;
                if (this.nOperations % PrivateEvictor.this.dbCacheClearCount == 0) {
                    this.releaseDbs();
                }
                return envImpl.getDbTree().getDb(dbId, -1L, this.map);
            }

            public void releaseDbs() {
                PrivateEvictor.this.envImpl.getDbTree().releaseDbs(this.map);
                this.map.clear();
            }
        };
    }
}

