/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.okhttp;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.WebSocket;
import okio.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sttp.client3.internal.ws.SimpleQueue;
import sttp.client3.internal.ws.WebSocketEvent;
import sttp.client3.okhttp.SendMessageException;
import sttp.model.Header$;
import sttp.model.Headers;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.ws.WebSocketClosed;
import sttp.ws.WebSocketFrame;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!\u0002\b\u0010\u0001=)\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011]\u0002!\u0011!Q\u0001\naB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"A1\u000b\u0001BC\u0002\u0013\rA\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u001dA\b!%A\u0005\u0002eDq!!\u0003\u0001\t\u0013\tY\u0001\u0003\u0006\u0002\u0012\u0001A)\u0019!C!\u0003'Aq!a\b\u0001\t\u0003\n\tCA\u0007XK\n\u001cvnY6fi&k\u0007\u000f\u001c\u0006\u0003!E\taa\\6iiR\u0004(B\u0001\n\u0014\u0003\u001d\u0019G.[3oiNR\u0011\u0001F\u0001\u0005gR$\b/\u0006\u0002\u0017KM\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\rq\u0012eI\u0007\u0002?)\u0011\u0001eE\u0001\u0003oNL!AI\u0010\u0003\u0013]+'mU8dW\u0016$\bC\u0001\u0013&\u0019\u0001!QA\n\u0001C\u0002!\u0012\u0011AR\u0002\u0001+\tI\u0003'\u0005\u0002+[A\u0011\u0001dK\u0005\u0003Ye\u0011qAT8uQ&tw\r\u0005\u0002\u0019]%\u0011q&\u0007\u0002\u0004\u0003:LH!B\u0019&\u0005\u0004I#!A0\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nqa\\6iiR\u00048'\u0003\u0002#i\u0005)\u0011/^3vKB!\u0011(P\u0012@\u001b\u0005Q$B\u0001\u0011<\u0015\ta\u0014#\u0001\u0005j]R,'O\\1m\u0013\tq$HA\u0006TS6\u0004H.Z)vKV,\u0007CA\u001dA\u0013\t\t%H\u0001\bXK\n\u001cvnY6fi\u00163XM\u001c;\u0002\u000f}K7o\u00149f]B\u0011A)T\u0007\u0002\u000b*\u0011aiR\u0001\u0007CR|W.[2\u000b\u0005!K\u0015AC2p]\u000e,(O]3oi*\u0011!jS\u0001\u0005kRLGNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059+%!D!u_6L7MQ8pY\u0016\fg.\u0001\u0005`Q\u0016\fG-\u001a:t!\t\u0019\u0014+\u0003\u0002Si\t9\u0001*Z1eKJ\u001c\u0018!B7p]\u0006$W#A+\u0011\u0007YC6%D\u0001X\u0015\t\u00196#\u0003\u0002Z/\nQQj\u001c8bI\u0016\u0013(o\u001c:\u0002\r5|g.\u00193!\u0003\u0019a\u0014N\\5u}Q)Q,\u00192dIR\u0011a\f\u0019\t\u0004?\u0002\u0019S\"A\b\t\u000bM;\u00019A+\t\u000b\u0001:\u0001\u0019\u0001\u001a\t\u000b]:\u0001\u0019\u0001\u001d\t\u000b\t;\u0001\u0019A\"\t\u000b=;\u0001\u0019\u0001)\u0002\u000fI,7-Z5wKR\tq\rE\u0002%K!\u0004\"AH5\n\u0005)|\"AD,fEN{7m[3u\rJ\fW.Z\u0001\u0005g\u0016tG\rF\u0002ncN\u00042\u0001J\u0013o!\tAr.\u0003\u0002q3\t!QK\\5u\u0011\u0015\u0011\u0018\u00021\u0001i\u0003\u00051\u0007b\u0002;\n!\u0003\u0005\r!^\u0001\u000fSN\u001cuN\u001c;j]V\fG/[8o!\tAb/\u0003\u0002x3\t9!i\\8mK\u0006t\u0017AD:f]\u0012$C-\u001a4bk2$HEM\u000b\u0002u*\u0012Qo_\u0016\u0002yB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004e\t!\"\u00198o_R\fG/[8o\u0013\r\t9A \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00034s_6\u0014un\u001c7fC:$2!\\A\u0007\u0011\u0019\tya\u0003a\u0001k\u00061!/Z:vYR\fa\"\u001e9he\u0006$W\rS3bI\u0016\u00148/\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cM\tQ!\\8eK2L1AUA\r\u0003\u0019I7o\u00149f]R\u0011\u00111\u0005\t\u0004I\u0015*\b")
public class WebSocketImpl<F>
implements sttp.ws.WebSocket<F> {
    private Headers upgradeHeaders;
    private final WebSocket ws;
    private final SimpleQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean _isOpen;
    private okhttp3.Headers _headers;
    private final MonadError<F> monad;
    private volatile boolean bitmap$0;

    public F receiveDataFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveDataFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveDataFrame$default$1() {
        return sttp.ws.WebSocket.receiveDataFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveTextFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveTextFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveTextFrame$default$1() {
        return sttp.ws.WebSocket.receiveTextFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveBinaryFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveBinaryFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveBinaryFrame$default$1() {
        return sttp.ws.WebSocket.receiveBinaryFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveText(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveText$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveText$default$1() {
        return sttp.ws.WebSocket.receiveText$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveBinary(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveBinary$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public <T> F eitherClose(Function0<F> f) {
        return (F)sttp.ws.WebSocket.eitherClose$((sttp.ws.WebSocket)this, f);
    }

    public <T> F either(Function0<F> f) {
        return (F)sttp.ws.WebSocket.either$((sttp.ws.WebSocket)this, f);
    }

    public F sendText(String payload) {
        return (F)sttp.ws.WebSocket.sendText$((sttp.ws.WebSocket)this, (String)payload);
    }

    public F sendBinary(byte[] payload) {
        return (F)sttp.ws.WebSocket.sendBinary$((sttp.ws.WebSocket)this, (byte[])payload);
    }

    public F close() {
        return (F)sttp.ws.WebSocket.close$((sttp.ws.WebSocket)this);
    }

    public MonadError<F> monad() {
        return this.monad;
    }

    public F receive() {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> $this.queue.poll()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var2_11;
            boolean bl = false;
            WebSocketEvent.Error error = null;
            boolean bl2 = false;
            WebSocketEvent.Frame frame = null;
            WebSocketEvent webSocketEvent = x0$1;
            if (webSocketEvent instanceof WebSocketEvent.Open) {
                Object f = this.receive();
                return var2_11;
            }
            if (webSocketEvent instanceof WebSocketEvent.Error) {
                bl = true;
                error = (WebSocketEvent.Error)webSocketEvent;
                Throwable t = error.t();
                if (t instanceof Exception) {
                    Exception exception = (Exception)t;
                    $this.queue.offer((Object)error);
                    Object object = this.monad().error((Throwable)exception);
                    return var2_11;
                }
            }
            if (bl) {
                Throwable t = error.t();
                throw t;
            }
            if (webSocketEvent instanceof WebSocketEvent.Frame) {
                bl2 = true;
                frame = (WebSocketEvent.Frame)webSocketEvent;
                WebSocketFrame f = frame.f();
                if (f instanceof WebSocketFrame.Close) {
                    WebSocketFrame.Close close = (WebSocketFrame.Close)f;
                    $this.queue.offer((Object)new WebSocketEvent.Error((Throwable)new WebSocketClosed((Option)new Some((Object)close))));
                    Object object = this.monad().unit((Object)close);
                    return var2_11;
                }
            }
            if (!bl2) throw new MatchError((Object)webSocketEvent);
            WebSocketFrame f = frame.f();
            if (f == null) throw new MatchError((Object)webSocketEvent);
            WebSocketFrame webSocketFrame = f;
            Object object = this.monad().unit((Object)webSocketFrame);
            return var2_11;
        }, this.monad());
    }

    public F send(WebSocketFrame f, boolean isContinuation) {
        return (F)this.monad().flatten(this.monad().eval((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            WebSocketFrame webSocketFrame = f;
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                WebSocketFrame.Text text = (WebSocketFrame.Text)webSocketFrame;
                String payload = text.payload();
                object = this.fromBoolean($this.ws.send(payload));
            } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
                WebSocketFrame.Binary binary = (WebSocketFrame.Binary)webSocketFrame;
                byte[] payload = binary.payload();
                object = this.fromBoolean($this.ws.send(new ByteString(payload)));
            } else if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
                int statusCode = close.statusCode();
                String reasonText = close.reasonText();
                boolean wasOpen = $this._isOpen.getAndSet(false);
                object = wasOpen ? this.fromBoolean($this.ws.close(statusCode, reasonText)) : syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)BoxedUnit.UNIT), this.monad());
            } else if (webSocketFrame instanceof WebSocketFrame.Ping) {
                object = this.monad().error((Throwable)new UnsupportedOperationException("Ping is handled by okhttp under the hood"));
            } else if (webSocketFrame instanceof WebSocketFrame.Pong) {
                object = this.monad().error((Throwable)new UnsupportedOperationException("Pong is handled by okhttp under the hood"));
            } else {
                throw new MatchError((Object)webSocketFrame);
            }
            return object;
        }));
    }

    public boolean send$default$2() {
        return false;
    }

    private F fromBoolean(boolean result) {
        return (F)(!result ? this.monad().error((Throwable)((Object)new SendMessageException())) : this.monad().unit((Object)BoxedUnit.UNIT));
    }

    private Headers upgradeHeaders$lzycompute() {
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (!this.bitmap$0) {
                this.upgradeHeaders = new Headers((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this._headers.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Header$.MODULE$.apply((String)p.getFirst(), (String)p.getSecond())).toList());
                this.bitmap$0 = true;
            }
        }
        this._headers = null;
        return this.upgradeHeaders;
    }

    public Headers upgradeHeaders() {
        return !this.bitmap$0 ? this.upgradeHeaders$lzycompute() : this.upgradeHeaders;
    }

    public F isOpen() {
        return (F)this.monad().eval((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this._isOpen.get());
    }

    public WebSocketImpl(WebSocket ws, SimpleQueue<F, WebSocketEvent> queue, AtomicBoolean _isOpen, okhttp3.Headers _headers, MonadError<F> monad) {
        this.ws = ws;
        this.queue = queue;
        this._isOpen = _isOpen;
        this._headers = _headers;
        this.monad = monad;
        sttp.ws.WebSocket.$init$((sttp.ws.WebSocket)this);
    }
}

