/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.xpe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Xpe
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final String[] EMPTY_NS = new String[0];
    private String _expression;
    private String[] _namespaces = null;
    private String _expanded = null;
    private String _creator;

    public Xpe(String expression) {
        this(expression, EMPTY_NS);
    }

    public Xpe(String expression, String[] namespaces) {
        this(expression, namespaces, null);
    }

    public Xpe(String expression, String[] namespaces, String creator) {
        this.setExpression(expression);
        this._namespaces = namespaces == null ? EMPTY_NS : namespaces;
        Arrays.sort(this._namespaces);
        this._creator = creator;
    }

    public String getExpression() {
        return this._expression;
    }

    public String[] getNamespaces() {
        return this._namespaces;
    }

    public String getCreator() {
        return this._creator;
    }

    private void setExpression(String rawExpr) {
        if (rawExpr == null) {
            throw new IllegalArgumentException("Expression field cannot be null");
        }
        this._expression = rawExpr;
    }

    public int hashCode() {
        return this.asExpandedString().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Xpe) {
            Xpe other = (Xpe)o;
            return this.asExpandedString().equals(other.asExpandedString());
        }
        return false;
    }

    public String toFilterString() {
        StringBuffer sb = new StringBuffer(this._expression);
        for (int i = 0; i < this._namespaces.length; ++i) {
            sb.append(";");
            sb.append(this._namespaces[i]);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this._expression);
        sb.append(" ");
        for (int i = 0; i < this._namespaces.length; ++i) {
            sb.append(this._namespaces[i]);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public String asExpandedString() {
        if (this._expanded != null) {
            return this._expanded;
        }
        if (this._namespaces.length == 0) {
            return this._expression;
        }
        this._expanded = new String(this._expression);
        for (int i = 0; i < this._namespaces.length; ++i) {
            StringTokenizer nsTokenizer;
            if (this._namespaces[i] == null || (nsTokenizer = new StringTokenizer(this._namespaces[i], "=")).countTokens() != 2) continue;
            String prefix = nsTokenizer.nextToken().trim();
            String ns = nsTokenizer.nextToken().trim();
            if (prefix.length() == 0 || ns.length() == 0) continue;
            StringTokenizer prefixTokenizer = new StringTokenizer(prefix, ":");
            if (prefixTokenizer.countTokens() == 2) {
                prefixTokenizer.nextToken();
                prefix = prefixTokenizer.nextToken();
            }
            int index = 0;
            while ((index = this._expanded.indexOf(prefix, index)) != -1) {
                if (index == 0 || index == this._expanded.length() - prefix.length()) {
                    ++index;
                    continue;
                }
                if (!Character.isLetterOrDigit(this._expanded.charAt(index - 1)) && this._expanded.charAt(index + prefix.length()) == ':') {
                    String left = this._expanded.substring(0, index);
                    String right = this._expanded.substring(index + prefix.length());
                    this._expanded = left + ns + right;
                    index = index + ns.length() + 1;
                    continue;
                }
                ++index;
            }
        }
        return this._expanded;
    }

    public static Xpe parse(String expression) {
        int nsStart = expression.indexOf(10);
        if (nsStart == -1) {
            return new Xpe(expression);
        }
        String expr = expression.substring(0, nsStart).trim();
        boolean finished = false;
        ArrayList<String> namespaces = new ArrayList<String>();
        while (!finished) {
            String namespaceStr;
            StringTokenizer t;
            int nsEnd = expression.indexOf(10, nsStart + 1);
            if (nsEnd == -1) {
                finished = true;
                nsEnd = expression.length();
            }
            if ((t = new StringTokenizer(namespaceStr = expression.substring(nsStart + 1, nsEnd).trim(), " ")).countTokens() != 3) {
                return null;
            }
            namespaces.add(new String(t.nextToken() + t.nextToken() + t.nextToken()));
            nsStart = nsEnd;
        }
        String[] ns = new String[namespaces.size()];
        ns = namespaces.toArray(ns);
        return new Xpe(expr, ns);
    }

    public static void main(String[] args) {
        String[][] exprs = new String[][]{{"", "ns1="}, {"", "ns1= "}, {"", "ns1=\""}, {"/x/www.yahoo.ca:abc"}, {"/x/ns1:abc", "ns1=www.yahoo.ca"}, {"/x/ns2:abc", "ns2=www.yahoo.ca"}, {"/x/ns1:abc", "xmlns:ns1=www.yahoo.ca"}, {"/x/ns1:abc", "xmlns:ns1=\"www.yahoo.ca\""}, {"/x/nns1:abc", "ns1=www.yahoo.ca"}, {"/x/ns12:abc", "ns1=www.yahoo.ca"}, {"/x/nns12:abc", "ns1=www.yahoo.ca"}, {"/x/ns12:abc", "ns1=www.yahoo.ca", "ns12=www.google.ca"}, {"/x/ns12:abc", "s12=www.yahoo.ca", "ns12=www.google.ca"}, {"/x/abc", "abc=www.yahoo.ca"}, {"abc", "abc=www.yahoo.ca"}, {"/x/ns1:abc/ns2:def", "ns1=www.yahoo.ca", "ns2=www.google.ca"}, {"/x/ns1:abc/ns2:def", "ns1=\"www.yahoo.ca\"", "ns2=\"www.google.ca\""}, {"/x/ns2:abc/ns1:def", "ns2=www.yahoo.ca", "ns1=www.google.ca"}};
        Xpe previous = null;
        for (int i = 0; i < exprs.length; ++i) {
            String[] namespaces = new String[exprs[i].length - 1];
            for (int j = 0; j < exprs[i].length - 1; ++j) {
                namespaces[j] = exprs[i][j + 1];
            }
            Xpe xpe = new Xpe(exprs[i][0], namespaces);
            System.out.println(xpe.asExpandedString() + " " + xpe.equals(previous));
            previous = xpe;
        }
    }

    public void setCreator(String creator) {
        this._creator = creator;
    }
}

