/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

import com.solacesystems.jcsmp.impl.XMLMessageQueue;
import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.queues.AbstractUnackedMessageList;
import com.solacesystems.jcsmp.protocol.WireMessage;

public class TransactedFlowAckMessageList
extends AbstractUnackedMessageList {
    XMLMessageQueue messageQueue;

    public TransactedFlowAckMessageList(int size, FlowHandle flow, XMLMessageQueue messageQueue) {
        super(flow);
        this.messageQueue = messageQueue;
    }

    public boolean hasUnsentAcks() {
        return true;
    }

    public void sendAcks(String reason, boolean allowReactorComplete) {
        this.flowHandle.setNumUnackedTpMsgs(0);
        WireMessage ackMsg = this.flowHandle.tpCreateAck();
        this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
    }

    public void sendCloseAcks(String reason, boolean allowReactorComplete) {
        this.flowHandle.setNumUnackedTpMsgs(0);
        WireMessage ackMsg = this.flowHandle.tpCreateStopAck();
        this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
    }

    public AbstractUnackedMessageList.EAppAckResult applicationAck(long msgId, boolean force_send) {
        return AbstractUnackedMessageList.EAppAckResult.OK;
    }

    public AbstractUnackedMessageList.EAddResult add(long msgId) {
        return AbstractUnackedMessageList.EAddResult.OK;
    }

    public int getWindowSize() {
        return this.messageQueue.capacityToCongestion();
    }

    public void clear() {
    }

    public boolean isKnownAppAcked(long msgId) {
        return false;
    }
}

