/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.encoding;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.impl.sdt.JMSInteropTest;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.message.SolMessage;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class InteropTest {
    public static boolean IgnoreGeneratedSendTimestamps = false;
    public static final String TestNoPropertyKey = "TestNoProperty";

    public static int validateRecvMsg(Message msg) throws SDTException {
        JMSInteropTest test;
        block10: {
            test = null;
            byte[] userData = ((SolMessage)msg).getMessage().getUserData();
            if (userData == null || userData.length == 0) {
                throw new IllegalArgumentException("no test number specified in user data");
            }
            test = JMSInteropTest.Tests.get(userData[0]);
            if (test == null) {
                throw new IllegalArgumentException("unknown test number specified - " + userData[0]);
            }
            try {
                InteropTest.testMessageTypes(test, msg);
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(test.jmsMsgID, msg.getJMSMessageID(), test.testNo, "App Message IDs don't match");
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(test.jmsType, msg.getJMSType(), test.testNo, "App Message Types don't match");
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(test.jmsCorrelationID, msg.getJMSCorrelationID(), test.testNo, "Correlation IDs don't match");
                InteropTest.testProperties(test, msg, test.testNo);
                InteropTest.testReplyTo(test.jmsReplyTo, msg.getJMSReplyTo(), test.testNo);
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testSendTimestamps(test.jmsSendTs, msg.getJMSTimestamp(), test.testNo, "Send Timestamps don't match");
                if (test.jmsMessageType == 10) {
                    InteropTest.testMapValues((SDTMap)test.payload, (MapMessage)msg, test.testNo);
                    break block10;
                }
                if (test.jmsMessageType == 11) {
                    InteropTest.testStreamValues((SDTStream)test.payload, (StreamMessage)msg, test.testNo);
                    break block10;
                }
                if (test.jmsMessageType == 7) {
                    com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(test.payload, ((TextMessage)msg).getText(), test.testNo, "text values don't match");
                    break block10;
                }
                if (test.jmsMessageType == 2) {
                    InteropTest.testBytesValues((byte[])test.payload, (BytesMessage)msg, test.testNo);
                    break block10;
                }
                if (test.jmsMessageType == 3) {
                    InteropTest.testObjectValues(test.payload, (ObjectMessage)msg, test.testNo);
                    break block10;
                }
                if (test.jmsMessageType == 4) break block10;
                if (test.jmsMessageType == 1) {
                    com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(test.payload, ((TextMessage)msg).getText(), test.testNo, "text values don't match");
                    break block10;
                }
                throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(test.testNo, "Unknown structured message type"));
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        return test.testNo;
    }

    public static void testMessageTypes(JMSInteropTest test, Message received) {
        if (BytesMessage.class.isAssignableFrom(received.getClass())) {
            if (test.jmsMessageType == 2) {
                return;
            }
        } else if (MapMessage.class.isAssignableFrom(received.getClass())) {
            if (test.jmsMessageType == 10) {
                return;
            }
        } else if (ObjectMessage.class.isAssignableFrom(received.getClass())) {
            if (test.jmsMessageType == 3) {
                return;
            }
        } else if (StreamMessage.class.isAssignableFrom(received.getClass())) {
            if (test.jmsMessageType == 11) {
                return;
            }
        } else if (TextMessage.class.isAssignableFrom(received.getClass())) {
            if (test.jmsMessageType == 7) {
                return;
            }
            if (test.jmsMessageType == 1) {
                return;
            }
        } else if (Message.class.isAssignableFrom(received.getClass()) && test.jmsMessageType == 4) {
            return;
        }
        throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(test.testNo, "jms message type difference, expected=" + test.jmsMessageType + ", received=" + received.getClass().getSimpleName()));
    }

    public static void testProperties(JMSInteropTest test, Message received, int testNo) throws JMSException, SDTException {
        if (test.jmsProps == null) {
            Enumeration enumer = received.getPropertyNames();
            while (enumer.hasMoreElements()) {
                String prop = (String)enumer.nextElement();
                Object value = received.getObjectProperty(prop);
                if (prop.equals("Solace_JMS_Prop_IS_Reply_Message") && Boolean.FALSE.equals(value) || prop.equals("JMS_Solace_DeliverToOne") && Boolean.FALSE.equals(value) || prop.equals("JMS_Solace_isXML") && Boolean.TRUE.equals(value) && test.jmsMessageType == 1 || prop.equals("JMS_Solace_isXML") && Boolean.FALSE.equals(value) || prop.equals("JMS_Solace_DeadMsgQueueEligible") && Boolean.FALSE.equals(value) || prop.equals("JMS_Solace_ElidingEligible") && Boolean.FALSE.equals(value)) continue;
                throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms message properties difference, expected none"));
            }
        } else {
            for (String key : test.jmsProps.keySet()) {
                Object value = test.jmsProps.get(key);
                Object receivedValue = received.getObjectProperty(key);
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(value, receivedValue, testNo, "Properties don't match");
            }
            Enumeration enumer = received.getPropertyNames();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                Object value = received.getObjectProperty(key);
                if (key.equals("Solace_JMS_Prop_IS_Reply_Message") && Boolean.FALSE.equals(value) || key.equals("JMS_Solace_DeliverToOne") && Boolean.FALSE.equals(value) || key.equals("JMS_Solace_isXML") && Boolean.TRUE.equals(value) && test.jmsMessageType == 1 || key.equals("JMS_Solace_isXML") && Boolean.FALSE.equals(value) || key.equals("JMS_Solace_DeadMsgQueueEligible") && Boolean.FALSE.equals(value) || key.equals("JMS_Solace_ElidingEligible") && Boolean.FALSE.equals(value)) continue;
                Object expectedValue = test.jmsProps.get(key);
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(value, expectedValue, testNo, "Properties don't match");
            }
        }
    }

    public static void testReplyTo(com.solacesystems.jcsmp.Destination expected, Destination received, int testNo) throws JMSException {
        if (expected == null) {
            if (received != null) {
                throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms ReplyTo difference, expected null"));
            }
        } else {
            SolDestination jmsExpected = SolDestination.createDestination(expected);
            if (!((Object)jmsExpected).equals(received)) {
                throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms ReplyTo difference, (Expected= " + jmsExpected + ", Received= " + received));
            }
        }
    }

    public static void testMapValues(SDTMap expected, MapMessage received, int testNo) throws JMSException, SDTException {
        if (expected == null) {
            if (received.getMapNames().hasMoreElements()) {
                throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms map difference, expected none"));
            }
        } else {
            for (String key : expected.keySet()) {
                Object value = expected.get(key);
                Object receivedValue = received.getObject(key);
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(value, receivedValue, testNo, "map values don't match");
            }
            Enumeration enumer = received.getMapNames();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                Object value = received.getObject(key);
                Object expectedValue = expected.get(key);
                if (value instanceof byte[]) {
                    com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(new ByteArray((byte[])value), expectedValue, testNo, "map values don't match");
                    continue;
                }
                com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(value, expectedValue, testNo, "map values don't match");
            }
        }
    }

    public static void testStreamValues(SDTStream expected, StreamMessage received, int testNo) throws JMSException, SDTException {
        if (expected == null) {
            try {
                received.readObject();
            }
            catch (MessageEOFException e) {
                return;
            }
            throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms stream difference, expected none"));
        }
        expected.rewind();
        while (expected.hasRemaining()) {
            Object value = expected.read();
            Object receivedValue = received.readObject();
            com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(value, receivedValue, testNo, "stream values don't match");
        }
        try {
            received.readObject();
        }
        catch (MessageEOFException e) {
            return;
        }
        throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms stream difference, expected none"));
    }

    public static void testBytesValues(byte[] expected, BytesMessage received, int testNo) throws JMSException, SDTException {
        if (expected == null) {
            if (received.getBodyLength() != 0L) {
                throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms bytes difference, expected none"));
            }
        } else {
            byte[] receivedBytes = new byte[(int)received.getBodyLength()];
            received.readBytes(receivedBytes);
            com.solacesystems.jcsmp.impl.sdt.InteropTest.testBytes(expected, receivedBytes, testNo, "bytes values don't match");
        }
    }

    public static void testObjectValues(Object expected, ObjectMessage received, int testNo) throws JMSException, SDTException {
        if (expected == null) {
            if (received.getObject() != null) {
                throw new IllegalArgumentException(com.solacesystems.jcsmp.impl.sdt.InteropTest.getErrorStr(testNo, "jms object difference, expected none"));
            }
        } else {
            com.solacesystems.jcsmp.impl.sdt.InteropTest.testValues(expected, received.getObject(), testNo, "object values don't match");
        }
    }

    public static Message createMessageByNumber(Session session, MessageProducer producer, Integer msgId) throws JMSException, SDTException {
        JMSInteropTest interopTest = null;
        switch (msgId) {
            case 1: {
                interopTest = JMSInteropTest.interopTest1();
                break;
            }
            case 2: {
                interopTest = JMSInteropTest.interopTest2();
                break;
            }
            case 3: {
                interopTest = JMSInteropTest.interopTest3();
                break;
            }
            case 4: {
                interopTest = JMSInteropTest.interopTest4();
                break;
            }
            case 5: {
                interopTest = JMSInteropTest.interopTest5();
                break;
            }
            case 6: {
                interopTest = JMSInteropTest.interopTest6();
                break;
            }
            case 7: {
                interopTest = JMSInteropTest.interopTest7();
                break;
            }
            case 8: {
                interopTest = JMSInteropTest.interopTest8();
                break;
            }
            case 9: {
                interopTest = JMSInteropTest.interopTest9();
                break;
            }
            case 10: {
                interopTest = JMSInteropTest.interopTest10();
                break;
            }
            case 11: {
                interopTest = JMSInteropTest.interopTest11();
                break;
            }
            case 12: {
                interopTest = JMSInteropTest.interopTest12();
                break;
            }
            case 13: {
                interopTest = JMSInteropTest.interopTest13();
                break;
            }
            case 14: {
                interopTest = JMSInteropTest.interopTest14();
                break;
            }
            case 15: {
                interopTest = JMSInteropTest.interopTest15();
                break;
            }
            case 16: {
                interopTest = JMSInteropTest.interopTest16();
                break;
            }
            default: {
                throw new JMSException("Unexpected msgId: " + msgId);
            }
        }
        interopTest.testNo = msgId;
        return InteropTest.createJMSMessage(session, producer, interopTest);
    }

    public static Message createJMSMessage(Session session, MessageProducer producer, JMSInteropTest test) throws JMSException, SDTException {
        BytesMessage message = null;
        if (test.jmsMessageType == 2) {
            message = session.createBytesMessage();
            if (test.payload instanceof byte[]) {
                message.writeBytes((byte[])test.payload);
            }
        } else if (test.jmsMessageType == 10) {
            message = session.createMapMessage();
            if (test.payload != null) {
                SDTMap payloadMap = (SDTMap)test.payload;
                for (String key : payloadMap.keySet()) {
                    Object value = payloadMap.get(key);
                    if (value instanceof ByteArray) {
                        ((MapMessage)message).setObject(key, (Object)((ByteArray)value).asBytes());
                        continue;
                    }
                    ((MapMessage)message).setObject(key, value);
                }
            }
        } else if (test.jmsMessageType == 3) {
            message = session.createObjectMessage();
            if (test.payload != null) {
                ((ObjectMessage)message).setObject((Serializable)test.payload);
            }
        } else if (test.jmsMessageType == 11) {
            message = session.createStreamMessage();
            if (test.payload != null) {
                SDTStream stream = (SDTStream)test.payload;
                stream.rewind();
                while (stream.hasRemaining()) {
                    try {
                        Object obj = stream.read();
                        if (obj instanceof ByteArray) {
                            ((StreamMessage)message).writeObject((Object)((ByteArray)obj).asBytes());
                            continue;
                        }
                        ((StreamMessage)message).writeObject(obj);
                    }
                    catch (SDTException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (test.jmsMessageType == 7) {
            message = session.createTextMessage();
            ((TextMessage)message).setText((String)test.payload);
            message.setBooleanProperty("JMS_Solace_isXML", false);
        } else if (test.jmsMessageType == 4) {
            message = session.createMessage();
        } else if (test.jmsMessageType == 1) {
            message = session.createTextMessage();
            ((TextMessage)message).setText((String)test.payload);
            message.setBooleanProperty("JMS_Solace_isXML", true);
        } else {
            throw new IllegalArgumentException("illegal jms message type");
        }
        producer.setDeliveryMode(1);
        message.setJMSMessageID(test.jmsMsgID);
        producer.setDisableMessageID(true);
        message.setJMSType(test.jmsType);
        message.setJMSCorrelationID(test.jmsCorrelationID);
        if (test.jmsProps != null) {
            for (String key : test.jmsProps.keySet()) {
                Object value = test.jmsProps.get(key);
                if (value instanceof ByteArray) {
                    message.setObjectProperty(key, (Object)((ByteArray)value).asBytes());
                    continue;
                }
                message.setObjectProperty(key, value);
            }
        }
        if (test.jmsReplyTo != null) {
            message.setJMSReplyTo((Destination)SolDestination.createDestination(test.jmsReplyTo));
        }
        producer.setDisableMessageTimestamp(test.jmsSendTs != null);
        if (test.jmsSendTs != null) {
            message.setJMSTimestamp(test.jmsSendTs.longValue());
        }
        message.setByteProperty(TestNoPropertyKey, (byte)test.testNo);
        return message;
    }
}

