/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflection {
    public void execute1(String arg1, Integer arg2, Double arg3) {
        System.out.println(arg1);
        System.out.println(arg2);
        System.out.println(arg3);
    }

    public static Object convert(Object fromValue, String toClassStr) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = Class.forName(toClassStr);
        return Reflection.convert(fromValue, clazz);
    }

    public static Object convert(Object fromValue, Class<?> toClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (fromValue.getClass().equals(toClass)) {
            return fromValue;
        }
        Class[] valueOfArgs = new Class[]{fromValue.getClass()};
        Method convertMethod = toClass.getDeclaredMethod("valueOf", valueOfArgs);
        Object[] invokeArgs = new Object[]{fromValue};
        return convertMethod.invoke(null, invokeArgs);
    }

    public static Method[] getMethods(Object obj, String methodName, String[] args) {
        Method[] methods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        int numArgs = 0;
        if (args != null) {
            numArgs = args.length;
        }
        if ((methods = obj.getClass().getDeclaredMethods()) != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName) || methods[i].getParameterTypes().length != numArgs) continue;
                methodList.add(methods[i]);
            }
        }
        Method[] methodArray = new Method[methodList.size()];
        if (methodList.size() > 0) {
            methodArray = methodList.toArray(methodArray);
        }
        return methodArray;
    }

    public static Object execute(Object obj, String methodName, String[] args) throws InvocationTargetException, IllegalAccessException {
        Method method = null;
        int numArgs = 0;
        if (args != null) {
            numArgs = args.length;
        }
        Object[] methodArgs = new Object[numArgs];
        Method[] methods = Reflection.getMethods(obj, methodName, args);
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int j = 0; j < numArgs; ++j) {
                try {
                    methodArgs[j] = Reflection.convert((Object)args[j], parameterTypes[j]);
                    continue;
                }
                catch (Exception e) {
                    method = null;
                    break;
                }
            }
            if (method != null) break;
        }
        if (method != null) {
            return method.invoke(obj, methodArgs);
        }
        throw new IllegalArgumentException("Couldn't access method: " + methodName);
    }

    public static String[] getFieldNames(Class<?> aClass, int size) {
        String[] strings = new String[size];
        Field[] fields = aClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isFinal(fields[i].getModifiers()) || !Modifier.isPublic(fields[i].getModifiers()) || !Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                int value = fields[i].getInt(null);
                if (value >= size) continue;
                strings[value] = fields[i].getName();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return strings;
    }

    public static Class<?> getClass(String[] classpath, String classname) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(classname);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (classpath != null) {
                for (int i = 0; i < classpath.length; ++i) {
                    String path = classpath[i] + "." + classname;
                    try {
                        Class<?> clazz = Class.forName(path);
                        return clazz;
                    }
                    catch (ClassNotFoundException e2) {
                        continue;
                    }
                }
            }
            throw new ClassNotFoundException(classname);
        }
    }

    public static String toString(Object obj) {
        return obj.getClass().getName() + "#" + obj.toString();
    }

    public static Object fromString(String str) {
        String[] tokens = str.split("#");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Illegally formed argument, no #");
        }
        try {
            return Reflection.convert((Object)tokens[1], tokens[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Object creation failed: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        Reflection tester = new Reflection();
        String[] testArgs = new String[]{"arg1", "32", "26.122"};
        try {
            Object obj = Reflection.execute(tester, "execute1", testArgs);
            System.out.println(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

